#ifndef __PARPRE_PIPELINE_PACKAGE 
#define __PARPRE_PIPELINE_PACKAGE
#include "petscis.h"
#include "petscpc.h"

/*
typedef enum {PIPELINE_DOWN=0,PIPELINE_UP=1
	    } PipelineDirection;
typedef enum {PIPELINE_NONE=1, PIPELINE_SEQUENTIAL=2,
	      PIPELINE_REDBLACK=3, PIPELINE_MULTICOLOUR=4,
	      PIPELINE_USER=5
	    } PipelineType;
typedef struct _p_VecPipeline*  VecPipeline;
*/
#define PIPELINE_MULTICOLOUR 4
#define PIPELINE_USER 5

typedef struct _PCP_CommStruct* PCP_CommStruct;
typedef struct _PipelineObject* PipelineObject;

extern int VecPipelineCreate(MPI_Comm comm,
			     Vec xin,IS ix,Vec yin,IS iy,VecPipeline *newctx);
extern int VecPipelineSetup(VecPipeline ctx);
extern int VecPipelineDestroy(VecPipeline ctx);
extern int VecPipelineSetType(VecPipeline ctx,PipelineType typ,PetscObject x);
extern int VecPipelineBegin(Vec,Vec,InsertMode,
			    ScatterMode,PipelineDirection,VecPipeline);
extern int VecPipelineEnd(Vec,Vec,InsertMode,
			  ScatterMode,PipelineDirection,VecPipeline); 
extern int VecPipelineIsStartOfPipe(VecPipeline ctx,
				    PipelineDirection pmode,int *flg);

extern int VecPipelineView(VecPipeline pipe,Viewer viewer);

#endif
