#ifndef __PARPRE_MAT_PACKAGE 
#define __PARPRE_MAT_PACKAGE
/****************************************************************
 * prototypes of auxiliary matrix functions in ParPre           *
 ****************************************************************/
#include "petscmat.h"
#include "parpre_vec.h"
#include "parpre_pipeline.h"

/* typedef enum {MatNeedsCreating=1,MatAlreadyCreated=2} MatReuse;*/

typedef struct _MatGatherCtx* MatGatherCtx;

extern int  MatCreateScatterPipeline
(Mat base_mat,PipelineType pipe_type,PetscObject pipe_obj,
 Vec *border_vec,VecPipeline *main_pipe);

extern int MatGatherCtxCreate(Mat mat,IS wanted,MatGatherCtx *rgs);
extern int MatGatherCtxDestroy(MatGatherCtx gs);
extern int MatGatherRows(Mat mat,MatGatherCtx gs, Mat *res_mat);
extern int MatGatherRowsPipelineBegin
(Mat mat,PipelineDirection ptype,MatGatherCtx gs, Mat *ret);
extern int MatGatherRowsPipelineEnd
(Mat mat,PipelineDirection ptype,MatGatherCtx gs, Mat *ret);

extern int MatrixAij2MpiAbut(MPI_Comm comm,
			     int part,Mat in,int jconform,Mat *out);
extern int MatrixAij2MpiAdd(int m,int n,int M,int N,
			    Mat in,MPI_Comm comm,Mat *out);
extern int MatrixAij2MpiIndex(MPI_Comm comm,IS iptr,IS jptr,
			      int m,int n,int M,int N,
			      Mat in,InsertMode addv,Mat *out);

/* dense matrix routines */
extern int MatMatMultDense(Mat a,Mat b,Mat c);
extern int MatTMatMultDense(Mat a,Mat b,Mat c);
extern int MatHMatMultDense(Mat a,Mat b,Mat c);
extern int MatInverseDense(Mat a,Mat b);

/* block matrices, or rather, matrices for block vectors */
typedef struct _p_BlockMat* BlockMat;

extern int BlockMatMult(BlockMat A,BlockVec bi,BlockVec bo);
extern int BlockMatCreate(Mat A,int nrhs,BlockMat *bA);
extern int BlockMatDestroy(BlockMat bA);

/* utility stuff */
extern int MatFileDump(Mat mat,char *name,int num);

#endif
