/*   Example Program to test ParPre Library */
/*  This is a very simple test and by no means exhaustive */

#include <stdlib.h>
#include <stdio.h>
#include "petsc.h"
#include "parpre.h"
#include "vec.h"
#define PARPRE 1
#ifdef PARPRE
#include "pc.h"
#else
#include "sles.h"
#endif
#include "sys.h"
#include "options.h"
#include <math.h>
#include "./examples.h"

extern int PCRegisterParPre(char *path);
/* void __main() {}*/

#undef __FUNC__
#define __FUNC__ "main"
int main(int Argc,char **Args)
{
  Mat       A;
  PC        B;
  Vec       V;
  MPI_Comm comm;
  int       numtids,mytid,flg,ierr;
  int local_size,domain_size = 20,its;
  Scalar *rhs_values,*sol_values;

  ParPreInitialize(&Argc,&Args,PETSC_NULL,PETSC_NULL);

  comm = MPI_COMM_WORLD;
  MPI_Comm_size(comm,&numtids);
  MPI_Comm_rank(comm,&mytid);
  
  ierr = OptionsHasName(PETSC_NULL,"-help",&flg); CHKERRA(ierr);
  if (flg) {
    PetscPrintf(comm,"Options for the ParPre tester:\n    -size <nn> for the domain size (=sqrt of matrix size)\n");
    ierr = prec_setup(comm,PETSC_NULL,PETSC_NULL); CHKERRA(ierr);
    goto end_of_main;
  }
  
  /* make Poisson matrix */
  {
    int pside,ipx,ipy,npx,npy, problem,domain_size;

    ierr = OptionsGetInt(PETSC_NULL,"-size",&domain_size,&flg); CHKERRA(ierr);
    if (!flg && (mytid==0) ) {
      PetscPrintf(comm,"Domain size: "); scanf("%d",&domain_size);
      PetscPrintf(comm,"=> %d\n",domain_size);
    }
    MPI_Bcast(&domain_size,1,MPI_INT,0,comm);
    
    ierr = OptionsGetInt(PETSC_NULL,"-pside",&pside,&flg); CHKERRA(ierr);
    if (!flg) {
      npx = numtids; ipx = mytid; npy = 1; ipy = 0;
    } else {
      npy = pside; npx = numtids/pside;
      if (npy*npx != numtids)
	SETERRQ(1,1,"Cannot divvy up processors like that");
      ipy = mytid/npx; ipx = mytid-npx*ipy;
      printf("[%d] I am processor (%d,%d)\n",mytid,ipx,ipy);
    }

    ierr = OptionsGetInt(PETSC_NULL,"-problem",&problem,&flg); CHKERRA(ierr);
    if (!flg) problem = 0;
    
    ierr = make_mat
      (comm,problem, ipx,ipy,npx,npy,
       &A,&V,domain_size,&local_size,&rhs_values); CHKERRQ(ierr);
  }
  sol_values = (double *) malloc(local_size*sizeof(double));

  /* setup and execute cg method */
#ifdef PARPRE
  ierr = PCCreate(comm,&B); CHKERRQ(ierr);
  ierr = PCSetVector(B,V); CHKERRQ(ierr);
  ierr = prec_setup(comm,A,B); CHKERRA(ierr);
  ierr = PCView(B,VIEWER_STDOUT_(comm)); CHKERRA(ierr);
  ierr = cg(comm,A,B,sol_values,rhs_values,local_size,&its); CHKERRA(ierr);
  PetscPrintf(comm,"Number of iterations: %d\n",its);
#else
  {
    SLES cg;
    Vec rhs,sol;
    Scalar one = 1.0;
    int its;

    ierr = VecCreateMPI(comm,local_size,PETSC_DECIDE,&rhs); CHKERRA(ierr);
    ierr = VecSet(&one,rhs); CHKERRA(ierr);
    ierr = VecDuplicate(rhs,&sol); CHKERRA(ierr);
    ierr = SLESCreate(MPI_COMM_WORLD,&cg); CHKERRA(ierr);
    ierr = SLESSetOperators(cg,A,A,0); CHKERRA(ierr);
    {
      KSP I;
      PC B;
      ierr = SLESGetKSP(cg,&I); CHKERRA(ierr);
      ierr = KSPSetMonitor(I,&KSPDefaultMonitor,(void*)0); CHKERRA(ierr);
#ifdef USE_PETSC_BOPT_g
#endif
      ierr = SLESGetPC(cg,&B); CHKERRA(ierr);
      ierr = prec_setup(comm,A,B); CHKERRA(ierr);
      ierr = SLESSetFromOptions(cg); CHKERRA(ierr);
      /*    ierr = SLESSetUp(cg,rhs,sol); CHKERRA(ierr);*/
      /*      ierr = PCView(B,VIEWER_STDOUT_(comm)); CHKERRA(ierr);*/
    }
    ierr = SLESSolve(cg,rhs,sol,&its); CHKERRA(ierr);
    PetscPrintf(comm,"Number of iterations: %d\n",its);
  }
#endif

  /* cleanup after ourselves. */
#ifdef PARPRE
  PCDestroy(B);
#endif
 end_of_main:
  ierr = OptionsLeft(); CHKERRA(ierr);

  ParPreFinalize();
  
return 0;
}
