#include <stdio.h>
#include "./examples.h"

#undef __FUNC__
#define __FUNC__ "prec_setup"
int prec_setup(MPI_Comm comm,Mat A,PC the_pc)
{
  PCType pc_name = PCMultiLevel;
  int mytid,flg,method, ierr;

  PetscFunctionBegin;

  ierr = OptionsHasName(PETSC_NULL,"-help",&flg); CHKERRQ(ierr);
  if (flg) {
    PetscPrintf(comm,"Multilevel methods available by using -method <nn>:\n");
    PetscPrintf(comm,"    0=Identity\n    1=Jacobi\n    2=SSOR\n    3=ILU(0)\n");
    PetscPrintf(comm,"    4=ILU(k)\n    5=Multigrid\n\n");
    PetscPrintf(comm,"Secret option -orth for faking an orthogonal grid;\n");
    PetscPrintf(comm,"-- this does not work for all grid sizes.\n");
    PetscFunctionReturn(0);
  }
 
  MPI_Comm_rank(comm,&mytid);
  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
  PetscPrintf(comm,"Setting up AMG pc\n");
  ierr = PCSetType(the_pc,pc_name); CHKERRQ(ierr);

  /* undocumented option */
  ierr = OptionsHasName(PETSC_NULL,"-orth",&flg);
  if (flg) {ierr = AMLorth(the_pc); CHKERRQ(ierr);}

  ierr = AMLSetTraceLevel
    (the_pc,AMLTraceProgress | AMLTraceColours | AMLTraceFill ); CHKERRQ(ierr);
  /*   | AMLTraceIndexSets */

  ierr = OptionsGetInt(PETSC_NULL,"-method",&method,&flg); CHKERRQ(ierr);
  if (!flg) method=0;

  /****************
   * multigrid 
   ****************/
    
  ierr = AMLSetISFromOriginal/*Strong*/(the_pc); CHKERRQ(ierr);
  ierr = AMLSetStrongRatio(the_pc,.18); CHKERRQ(ierr);
  ierr = AMLSetCoarseGridIndependent(the_pc); CHKERRQ(ierr);
  /*
  ierr = AMLSetSchurElimination(the_pc); CHKERRQ(ierr);
  */
  ierr = AMLSetSchurVariational(the_pc); CHKERRQ(ierr);
  ierr = AMLSetModification(the_pc,AMLModDiag); CHKERRQ(ierr);
  ierr = AMLSetFillMethod(the_pc,AMLFillFull); CHKERRQ(ierr);
  ierr = AMLSetSolutionScheme(the_pc,AMLSolveMG); CHKERRQ(ierr);
  ierr = AMLSetSmootherChoice(the_pc,AMLPrePostSmooth); CHKERRQ(ierr);
  ierr = AMLSetCutoffSize(the_pc,10); CHKERRQ(ierr);

  switch (method) {

  case 4:
    ierr = AMLSetCycleDegree(the_pc,2); CHKERRQ(ierr);
    break;

  case 3:
    ierr = OptionsSetValue("-11solver_ksp_type","cg"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-11solver_ksp_max_it","2"); CHKERRQ(ierr);

  case 2:
    ierr = AMLSetCutoffSize(the_pc,100); CHKERRQ(ierr);
    ierr = OptionsSetValue("-lastlevel_ksp_type","cg"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-lastlevel_ksp_max_it","3"); CHKERRQ(ierr);

  case 1:
    ierr = OptionsSetValue("-presmoother_ksp_type","cg"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-postsmoother_ksp_type","cg"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-presmoother_ksp_max_it","3"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-postsmoother_ksp_max_it","3"); CHKERRQ(ierr);

  case 0:
    ierr = OptionsSetValue("-presmoother_pc_type","jacobi"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-postsmoother_pc_type","jacobi"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-11solver_pc_type","jacobi"); CHKERRQ(ierr);
    ierr = OptionsSetValue("-lastlevel_pc_type","jacobi"); CHKERRQ(ierr);
    break;

  }
  /* ---------------------------------- */

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  PetscFunctionReturn(0);
}

