#include <stdio.h>
#include "./examples.h"

#undef __FUNC__
#define __FUNC__ "prec_setup"
int prec_setup(MPI_Comm comm,Mat A,PC the_pc)
{
  PCType pc_name = PCDomainDecomp;
  int ierr;

  /* ---------------------------------- *
   * ---- here is the crucial part ---- *
   * ---------------------------------- */
  ierr = PCSetType(the_pc,pc_name); CHKERRQ(ierr);
  /* ---------------------------------- */

#define JACOBI 1
#define EXACT 2
#define ITER 3
#define METHOD EXACT
#if METHOD == ITER
  /* interface method */
  {
    SLES intface_sles; KSP intface_ksp; PC intface_pc;
    ierr = PCDomainDecompGetInterfaceSLES(the_pc,&intface_sles); CHKERRQ(ierr);
    ierr = SLESGetKSP(intface_sles,&intface_ksp); CHKERRQ(ierr);
    ierr = KSPSetType(intface_ksp,KSPCG); CHKERRQ(ierr);
    ierr = KSPSetTolerances(intface_ksp,1.e-4,1.e-4,1.e+4,200); CHKERRQ(ierr);
    ierr = SLESGetPC(intface_sles,&intface_pc); CHKERRQ(ierr);
    ierr = PCSetType(intface_pc,PCJACOBI); CHKERRQ(ierr);
  }
  /* local solver */
  {
    SLES local_sles; KSP local_ksp; PC local_pc;
    ierr = PCParallelGetLocalSLES(the_pc,&local_sles); CHKERRQ(ierr);
    ierr = SLESGetKSP(local_sles,&local_ksp); CHKERRQ(ierr);
    ierr = KSPSetType(local_ksp,KSPCG); CHKERRQ(ierr);
    ierr = KSPSetTolerances(local_ksp,1.e-4,1.e-4,1.e+4,200); CHKERRQ(ierr);
    ierr = SLESGetPC(local_sles,&local_pc); CHKERRQ(ierr);
    ierr = PCSetType(local_pc,PCJACOBI); CHKERRQ(ierr);
  }
#elif METHOD == JACOBI
  /* interface method */
  {
    SLES intface_sles; KSP intface_ksp; PC intface_pc;
    ierr = PCDomainDecompGetInterfaceSLES(the_pc,&intface_sles); CHKERRQ(ierr);
    ierr = SLESGetKSP(intface_sles,&intface_ksp); CHKERRQ(ierr);
    ierr = KSPSetType(intface_ksp,KSPCG); CHKERRQ(ierr);
    ierr = KSPSetTolerances(intface_ksp,1.e-4,1.e-4,1.e+4,200); CHKERRQ(ierr);
    ierr = SLESGetPC(intface_sles,&intface_pc); CHKERRQ(ierr);
    ierr = PCSetType(intface_pc,PCJACOBI); CHKERRQ(ierr);
  }
  /* local solver */
  {
    SLES local_sles; KSP local_ksp; PC local_pc;
    ierr = PCParallelGetLocalSLES(the_pc,&local_sles); CHKERRQ(ierr);
    ierr = SLESGetKSP(local_sles,&local_ksp); CHKERRQ(ierr);
    ierr = KSPSetType(local_ksp,KSPCG); CHKERRQ(ierr);
    ierr = KSPSetTolerances(local_ksp,1.e-4,1.e-4,1.e+4,200); CHKERRQ(ierr);
    ierr = SLESGetPC(local_sles,&local_pc); CHKERRQ(ierr);
    ierr = PCSetType(local_pc,PCJACOBI); CHKERRQ(ierr);
  }
#elif METHOD == EXACT
  /* interface method */
  {
    PC intface_pc;
    ierr = PCDomainDecompGetInterfacePC(the_pc,&intface_pc); CHKERRQ(ierr);
    ierr = PCSetType(intface_pc,PCGenBlockSSOR); CHKERRQ(ierr);
    ierr = PCGenBlockSSORSetGlobalFactorisation(intface_pc); CHKERRQ(ierr);
    {
      PC very_local_pc;
      ierr = PCParallelGetLocalPC(intface_pc,&very_local_pc); CHKERRQ(ierr);
      ierr = PCSetType(very_local_pc,PCLU); CHKERRQ(ierr);
    }
  }
  /* local solver */
  {
    PC local_pc;
    ierr = PCParallelGetLocalPC(the_pc,&local_pc); CHKERRQ(ierr);
    ierr = PCSetType(local_pc,PCLU); CHKERRQ(ierr);
  }
#endif

  ierr = ParPreSetup(comm,A,the_pc); CHKERRQ(ierr);

  /*  {
    Mat intmat;
    ierr = PCDomainDecompGetInterfaceMat(the_pc,&intmat); CHKERRQ(ierr);
    ierr = MatFileDump(intmat,"int",0); CHKERRQ(ierr);
    }*/

  return 0;
}
