/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	"o_l_ext.h"
construct_cross_items(graphs_seps_list_ce, max_graphs, field_size,
		seps_list, index_seps_list,	 count_seps_list,
		pad_code, pad_list)
int
                *graphs_seps_list_ce, 
		max_graphs, field_size,
		*seps_list, *index_seps_list,	 *count_seps_list,
		pad_code, *pad_list;
/*
construct a list of edges or cliques that straddle the separating
coordinate for each graph 
this is used to construct separators along with vtxs at separating coordinate 
values
*/
{

			int dim, max_sep_coord, last_used, 
				*coords_list,
				*scratch_list_for_seps;;

			coords_list = 
				scratch_list+last_used_in_scratch_list;
			last_used_in_scratch_list+= max_graphs;
			scratch_list_for_seps=
				scratch_list+last_used_in_scratch_list;
			set_to(scratch_list_for_seps, ( Asubs),-1);

			for (dim=0, 
				last_used=0; dim <D; dim++){

				make_coords_list(graphs_seps_list_ce,
						max_graphs,
						field_size,
						dim,
						coords_list, 
						&max_sep_coord);
				if (max_sep_coord != EMPTY_LEVEL){
					initialize_counts( count_seps_list, 
					            	coords_list,
							max_graphs);
					sep_from_items(max_sep_coord, 
						in_graph_ce,
						ce_list_starts[dim], 	
						count_ce_list_starts[dim],
						index_ce_list_starts[dim],	
						limits_ce_list_starts[dim],
						scratch_list_for_seps,
						coords_list,
						seps_list, index_seps_list,	
						count_seps_list,
						BETA,
						pad_code,
						pad_list);

					sep_from_items(max_sep_coord, 
						in_graph_ce,
						ce_list_ends[dim], 	
						count_ce_list_ends[dim],
						index_ce_list_ends[dim],	
						limits_ce_list_ends[dim],
						scratch_list_for_seps,
						coords_list,
						seps_list, index_seps_list,	
						count_seps_list,
						EPS,
						pad_code,
						pad_list);
					initialize_index_count(index_seps_list, 
						count_seps_list,
						coords_list, max_graphs,
						&last_used);
					sep_from_items(max_sep_coord, 
						in_graph_ce,
						ce_list_starts[dim], 	
						count_ce_list_starts[dim],
						index_ce_list_starts[dim],	
						limits_ce_list_starts[dim],
						scratch_list_for_seps,
						coords_list,
						seps_list, 
						index_seps_list,	
						count_seps_list,
						GATHER,
						pad_code,
						pad_list);
				}
			}/*for*/
			last_used_in_scratch_list -= max_graphs;
			
}/*end construct_seps*/
sep_from_items(		max_sep_coord, in_graph, item_list, 	count_item_list,
			index_item_list,	limits_item_list,
			scratch_list_for_seps,
			coords_list,
			seps_list, index_seps_list,	
			count_seps_list,
			op_code, pad_code, pad_list)
int	
                      	max_sep_coord, *in_graph,	
			*item_list, 	*count_item_list,
			*coords_list,
			*index_item_list,	*limits_item_list,
			*seps_list, 		*count_seps_list,
			*index_seps_list,
			*scratch_list_for_seps, op_code,
			pad_code, *pad_list;

/*
make a  list of indices (seps list) that make up seperators for graphs
from an items list in the appropriate dimension

(op_code = BETA)
(count_seps_list must be zero)
is called with items_list corresponding to starts to set indices in
scratch list to level 
(op_code = EPS)
(count_seps_list must be  untouched after call with BETA = op_code)
is called with items_list corresponding to  ends to  set indices in
scratch list to EMPTY LEVEL 
(op_code == GATHER)
later these indices get gathered into a seps list
(count_seps_list must be zero)
*/
{

		

		int 	count, grf,i, i_limit, j, j_limit, next;

		
		
		for (next=count= 0, i=limits_item_list[0],
			i_limit = max_sep_coord ;
			i <= (i_limit) ; i++) {
			

			for(j=index_item_list[i],
				j_limit=index_item_list[i] + count_item_list[i];
			j < j_limit; j++){
			next = item_list[j];
			grf = in_graph[next];
			if (coords_list[grf] != EMPTY_LEVEL){
			/*if this dim is not right for this grf
			coords_list[grf] = EMPTY_LEVEL (-1)*/
			if ((op_code == BETA)) {
				if ((pad_code ==0)&&
				(coords_list[grf] >i))	{
					scratch_list_for_seps[next]
						=1;
					count_seps_list[grf] +=1;
				} else if((pad_code ==1)){ 
					if ( (pad_list[grf] ==1)
					&& (coords_list[grf] >=i)){
					scratch_list_for_seps[next]
						=1;
					count_seps_list[grf] +=1;
					}
					else if ( 
					(pad_list[grf] ==0)
					&& (coords_list[grf] >i)){
					scratch_list_for_seps[next]
						=1;
					count_seps_list[grf] +=1;
					}
				}	

				
			} else if ((op_code == EPS)) {
				if ( (coords_list[grf] >=i)){
					if (
					 scratch_list_for_seps[next]!= 
					EMPTY_LEVEL){ 
					count_seps_list[grf] -=1;
					 scratch_list_for_seps[next] =
						EMPTY_LEVEL ;
					}	
				}	
						 
			} 
			else if ((op_code == GATHER)){
				if ((pad_code ==0)&&
				(coords_list[grf] >i) &&
				(scratch_list_for_seps[next]
				 != EMPTY_LEVEL)){
				seps_list[index_seps_list[grf]+
				count_seps_list[grf]] = next;
				count_seps_list[grf] +=1;
				}	
				 else if((pad_code ==1)) {
					if( (pad_list[grf] ==1)&&
					(coords_list[grf] >=i) &&
					(scratch_list_for_seps[next]
					 != EMPTY_LEVEL)){
					seps_list[index_seps_list[grf]+
					count_seps_list[grf]] = next;
					count_seps_list[grf] +=1;
					}	
					else if( (pad_list[grf] ==0)&&
					(coords_list[grf] >i) &&
					(scratch_list_for_seps[next]
					 != EMPTY_LEVEL)){
					seps_list[index_seps_list[grf]+
					count_seps_list[grf]] = next;
					count_seps_list[grf] +=1;
					}	
				}	
			}	
			}	
		}
		}
	
}/*end sep_from_items*/
initialize_counts	( count_seps_list, coords_list, max_graphs)
int		*count_seps_list,	*coords_list, max_graphs;
{

			int i;
			for(i=0; i < max_graphs; i++)
				if (coords_list[i] != EMPTY_LEVEL)
					count_seps_list[i] =0;
}/*end initialize counts */
initialize_index_count	(index_seps_list, 
				count_seps_list, 
				coords_list, max_graphs, last_used)
int                   		*index_seps_list, 
				*count_seps_list, 
				*coords_list, max_graphs, *last_used;

{

			int i, used;
			for(i=0, used= *last_used; i < max_graphs; i++) {
				if (coords_list[i] != EMPTY_LEVEL){
				index_seps_list[i] = used;
				used += count_seps_list[i];
				count_seps_list[i] =0;
				}
			}
			*last_used = used;
}/*end initialize_index_count*/
make_coords_list(
		graphs_s_list,
		max_graphs,
		field_size,
		dim,
		coords_list, 
		max_sep_coord)
int		*graphs_s_list,
		max_graphs,
		field_size,
		dim,
		*coords_list, 
		*max_sep_coord;
{

		int i, max_coord;
		
		for (i=0, max_coord= -1; i <max_graphs; i++)
		{
			if (graphs_s_list[field_size*i] == dim){
				coords_list[i] = 
			   	 graphs_s_list[field_size*i+1];
				if (coords_list[i] > max_coord)
					max_coord= coords_list[i];
			}	else coords_list[i] = EMPTY_LEVEL;
		}
		*max_sep_coord = max_coord;
}/*make_coords_list*/ 

construct_sep_vtxs   (  graphs_seps_list_v, max_graphs,
			field_size,	sepv_list,
			index_sepv_list,
			count_sepv_list)
int		*graphs_seps_list_v, 	max_graphs,
		field_size, 		*sepv_list,
		*index_sepv_list,	*count_sepv_list;
{
		int dim, i, *item_list, limit, lvl, next;      
		for (i=next=0; i <max_graphs; i++){
			dim= graphs_seps_list_v[field_size*i];
			lvl= graphs_seps_list_v[field_size*i+1];
			index_sepv_list[i]= next;
			count_sepv_list[i] = 0;
			if (lvl != EMPTY){
				item_list = v_list[dim];
				item_list += *(index_v_list[dim]+ lvl);
				limit = *( count_v_list[dim] +lvl);
				for (; limit>0; limit --){	
					if(in_graph_v[*item_list] == i){
						sepv_list[next] = *item_list;
						count_sepv_list[i] += 1;
						next++;
					} 
					item_list++;
				}
			}
		}
		
}/*end construct_sep_vtxs */

		
l_dissect(graph_seps_list_ce,
		graph_seps_list_v)
int 		*graph_seps_list_ce,
		*graph_seps_list_v;
{
		int used, 	*separator_list,
				*index_separator_list,
				*count_separator_list;
		last_used_in_scratch_list =0;
			used = make_local_seps( graph_seps_list_ce,
						graph_seps_list_v,
						&separator_list,
						&index_separator_list,
						&count_separator_list,
						0, NULL);
			l_number_etc(used, 
					graph_seps_list_ce,
					graph_seps_list_v,
					separator_list,
					index_separator_list,
					count_separator_list);
		last_used_in_scratch_list =0;
}/*end l_dissect*/
int make_local_seps(graph_seps_list_ce,
			graph_seps_list_v,
			list, index, count, pad_code,
			pad_list)	
int		*graph_seps_list_ce,
		*graph_seps_list_v,
		**list, **index, **count, pad_code, *pad_list;
{
		int total, 	*separator_list,
				*index_separator_list,
				*count_separator_list;
		extern		int *global_levels[];


		construct_cross_items(	
					graph_seps_list_ce, max_graphs, 
					3, cross_list, 
					index_cross_list,      
					count_cross_list,
					pad_code,
					pad_list);
		construct_sep_vtxs   (  graph_seps_list_v, max_graphs,
					3,	sepv_list,
					index_sepv_list,
					count_sepv_list);

		if (MSGLVL == TRACE_ALL)
		print_vec(stdout,sepv_list,
		0,count_sepv_list[max_graphs-1]+
			index_sepv_list[max_graphs-1],
		"sepv_list\n");
		index_separator_list = scratch_list+
					last_used_in_scratch_list;
		last_used_in_scratch_list += max_graphs;
		count_separator_list = scratch_list+
					last_used_in_scratch_list;
		last_used_in_scratch_list += max_graphs;
		separator_list = scratch_list+
					last_used_in_scratch_list;
		total=
		consolidate_sep(	
					graph_seps_list_ce, max_graphs, 
					3, 
					cross_list, 
					index_cross_list,      
					count_cross_list,
					sepv_list,
					index_sepv_list,
					count_sepv_list,
					separator_list, 
					index_separator_list,
					count_separator_list, T);
		last_used_in_scratch_list += total;
		*list = separator_list;
		*index = index_separator_list;
		*count= count_separator_list;
		return(total);

}/*make_local_seps*/
l_number_etc(used, graph_seps_list_ce,
		graph_seps_list_v,
		separator_list, index_separator_list, count_separator_list)
int	used,	*graph_seps_list_ce,
		*graph_seps_list_v,
		 separator_list, index_separator_list, count_separator_list;
{
		int	new_max_graphs, *scratch_start, 
			*new_graph_numbers,	*scratch_end,
			*total_sep_size, 	*to_be_deleted_list,
			*coords_list;

		scratch_start = scratch_list + last_used_in_scratch_list;
		last_used_in_scratch_list += max_graphs;
		scratch_end= scratch_list + last_used_in_scratch_list;
		last_used_in_scratch_list += max_graphs;
		new_graph_numbers = scratch_list + last_used_in_scratch_list;
		last_used_in_scratch_list += 2*max_graphs;
		total_sep_size = scratch_list + last_used_in_scratch_list;
		last_used_in_scratch_list += max_graphs;
		coords_list = scratch_list + last_used_in_scratch_list;
		last_used_in_scratch_list += max_graphs; 
		new_max_graphs= l_number(		
					graph_seps_list_v,
					max_graphs,
					3,
					end_numbers,
							/*sep_numbers*/
					start_numbers, end_numbers, 
					new_numbers,
					new_graph_numbers,
					separator_list, 
					index_separator_list,
					count_separator_list,
					scratch_start,
					scratch_end, 
					coords_list,
					total_sep_size
					);
		l_update_lists (new_max_graphs, graph_seps_list_ce,
				coords_list,
				new_graph_numbers,
				separator_list,
				index_separator_list,
				count_separator_list);
		if ( new_max_graphs == 0) l_phase =0;
				
}/*l_number_etc*/
l_update_lists(new_max_graphs, graph_seps_list_ce,
			coords_list,	new_graph_number,
			separator_list,
				index_separator_list,
				count_separator_list)
int	new_max_graphs, *graph_seps_list_ce,
			*coords_list,	*new_graph_number,
			*separator_list,
			*index_separator_list,
			*count_separator_list;
{


		int	dim, 	max_sep_coord;
		
		scatter(separator_list, index_separator_list, 
				count_separator_list, 
				max_graphs, deleted_v);
		

		
		for (dim=0; dim < D; dim++)
			delete_items_v(deleted_v,
				limits_v_list[dim],
				v_list[dim],
				index_v_list[dim],
				count_v_list[dim]);


		
		for (dim=0; dim <D; dim++){
			make_coords_list(graph_seps_list_ce,
					max_graphs,
					3,
					dim,
					coords_list, 
					&max_sep_coord);
			if (P==1)
			update_in_graphs(
					limits_v_list[dim], 
					in_graph_v, new_graph_number,
					v_list[dim], 	
					count_v_list[dim],
					index_v_list[dim],
					coords_list,xyz[dim]);
			else
			update_in_graphs(
					limits_v_list[dim], 
					in_graph_v, new_graph_number,
					v_list[dim], 	
					count_v_list[dim],
					index_v_list[dim],
					coords_list,xyz_int[dim]);
		}
		redo_in_graphs(limits_v_list[0], 
					in_graph_v, new_graph_number,
					v_list[0], 	
					count_v_list[0],
					index_v_list[0],
					coords_list);
		max_graphs = new_max_graphs;
}/* l_update_lists*/

update_in_graphs(	limits, in_graph, new_graph_number,
			item_list, 	count_item_list,
			index_item_list,
			coords_list, x_y_z)
int	
                      	*limits, *in_graph,	
			*new_graph_number,
			*item_list, 	*count_item_list,
			*index_item_list,	
			*coords_list, *x_y_z;

/*
update in_graph list_ce or v
*/
{

		

		int	count, i, j, j_limit, next, this_coord,grf;
		
		
		for (next=count= 0, i=limits[0] ;
			i < (limits[1]) ; i++) {
			
			for(j=index_item_list[i],
				j_limit=index_item_list[i] + count_item_list[i];
				j < j_limit; j++){
				next = item_list[j];
				grf = in_graph[next];
				this_coord = *(x_y_z + next);
				if  ( (grf >=0) &&
				(coords_list[grf] != EMPTY_LEVEL)){
					if (coords_list[grf] >this_coord)
					in_graph[next] = 0-
						new_graph_number[2*grf]-1;
					else 
					in_graph[next] = 0-
						new_graph_number[2*grf+1]-1;
					
				}	
			}	
		}
	
}/*end update_in_graphs*/

redo_in_graphs(	limits, in_graph, new_graph_number,
			item_list, 	count_item_list,
			index_item_list,
			coords_list)
int	
                      	*limits, *in_graph,	
			*new_graph_number,
			*item_list, 	*count_item_list,
			*index_item_list,	
			*coords_list;

{

		

		int	count, i, j, j_limit, next, grf;
		
		
		for (next=count= 0, i=limits[0] ;
			i < (limits[1]) ; i++) {
			
			for(j=index_item_list[i],
				j_limit=index_item_list[i] + count_item_list[i];
				j < j_limit; j++){
				next = item_list[j];
				grf = in_graph[next];
				if  ( (grf <0))
					in_graph[next] = 0-in_graph[next]-1;
					
			}	
		}
	
}/*end redoin_graphs*/
un_scatter (list, index_list, count_list, 
	max_graphs, to_be_deleted_list)
int *list, *index_list, *count_list, max_graphs, *to_be_deleted_list;
{

		int i,j, j_limit;
		for (i=0; i <max_graphs; i++){
			for(j=index_list[i], j_limit = index_list[i] +
				count_list[i]; j <j_limit; j++)
				to_be_deleted_list[list[j]] = 0;
		}
}/*end un_scatte*/
scatter (list, index_list, count_list, 
	max_graphs, to_be_deleted_list)
int *list, *index_list, *count_list, max_graphs, *to_be_deleted_list;
{

		int i,j, j_limit;
		for (i=0; i <max_graphs; i++){
			for(j=index_list[i], j_limit = index_list[i] +
				count_list[i]; j <j_limit; j++)
				to_be_deleted_list[list[j]] = 1;
		}
}/*end scatte*/
size_seps (list, index_list, count_list, 
	max_graphs, s_list, field_size, offset,
	to_be_deleted_list)
int
	*list, *index_list, *count_list, max_graphs, 
	*s_list, field_size, offset,	*to_be_deleted_list;
{

		int i,j, j_limit,k;
		for (i=0; i <max_graphs; i++){
			k = i*field_size+offset;
			s_list[k]= 0;
			for(j=index_list[i], j_limit = index_list[i] +
				count_list[i]; j <j_limit; j++)
				if ( to_be_deleted_list[list[j]] != 1){
				     	to_be_deleted_list[list[j]] = 1;
					s_list[k] +=1;
				}
		}
}/*end size_seps*/
count_up_halves(
			graph_seps_list_v,
			new_graph_numbers,
			vtxs_list, index_vtxs_list,
			count_vtxs_list, coords_list,
			to_be_deleted_list)
int
			*graph_seps_list_v,
			*new_graph_numbers,
			*vtxs_list, *index_vtxs_list,
			*count_vtxs_list,	*coords_list,
			*to_be_deleted_list;
{
			int	grf, dim, limit, next;

			for (grf=0, limit = 2*max_graphs; 
					grf < limit; grf++)
				new_graph_numbers[grf] = 0;

			set_to(to_be_deleted_list,my_N,0);
		
			scatter (vtxs_list, index_vtxs_list, 
				count_vtxs_list, 
				max_graphs, to_be_deleted_list);


			if (MSGLVL == TRACE_ALL)
				print_vec(stdout, 
					to_be_deleted_list, 0, N, 
					"\nto_be_deleted_list,count_up\n");
			for (dim=0; dim <D; dim++){
				make_coords_list(graph_seps_list_v,
						max_graphs,
						3,
						dim,
						coords_list, 
						&limit);
				if (P==1)
				add_up(	coords_list,
					max_graphs,
					in_graph_v,
					limits_v_list[dim],
					v_list[dim],
					index_v_list[dim],
					count_v_list[dim],
					xyz[dim],
					to_be_deleted_list,
					new_graph_numbers);
				else 
				add_up(	coords_list,
					max_graphs,
					in_graph_v,
					limits_v_list[dim],
					v_list[dim],
					index_v_list[dim],
					count_v_list[dim],
					xyz_int[dim],
					to_be_deleted_list,
					new_graph_numbers);
			}
			if (MSGLVL == TRACE_ALL)
				print_vec(dbgfile, new_graph_numbers,0,
					2*max_graphs, "\nnew_graph_numbers\n");
}/*end count_up_halves*/
int assign_new_numbers	( 
                        max_graphs, field_size,
			sep_numbers,
               		start_numbers, end_numbers, 
			new_numbers,
			total_sep_size,
			new_graph_numbers,
			vtx_list, index_vtx_list,
			count_vtx_list,
			scratch_start,
			scratch_end
			)
int			
                	max_graphs, field_size,
			*sep_numbers,
			*start_numbers, *end_numbers, 
			*new_numbers,
			*total_sep_size,
			*new_graph_numbers,
			*vtx_list, *index_vtx_list,
			*count_vtx_list,
			*scratch_start,
			*scratch_end;
{
			int i, j, next, grf, limit, j_count ;
				
					/* number seps*/
			for (i=0; i <max_graphs; i++){
				next = sep_numbers[i];
				for (j= index_vtx_list[i], 
				j_count = count_vtx_list[i];
					j_count>0; j_count--,j++){
					if (new_numbers[vtx_list[j]] == EMPTY){
						new_numbers[vtx_list[j]] = next;
						
						next --;
					}
				}
			}
			if (l_phase ==1)
			l_tree_stuff(
				vtx_list, index_vtx_list,
				count_vtx_list,
				new_graph_numbers,
				end_numbers, 
				total_sep_size);

			for (grf=0, limit = 2*max_graphs; 
					grf < limit; grf++)
				if (new_graph_numbers[grf] == 0)
					new_graph_numbers[grf] = -1;

				/*set up new range of numbers per graph*/
			for (grf=0; grf <max_graphs; grf++){
				scratch_start[grf] = start_numbers[grf];
				scratch_end[grf] = end_numbers[grf];
			}

			for (grf=next=0; grf <max_graphs; grf++){
				if (new_graph_numbers[2*grf] != -1){
				start_numbers[next] = scratch_start[grf];
				end_numbers[next] =
				 new_graph_numbers[2*grf]
					+ start_numbers[next] -1;
				scratch_start[grf] = 
				 new_graph_numbers[2*grf]
					+ start_numbers[next] ;
				next++;
				}
				if (new_graph_numbers[2*grf+1] != -1){
				start_numbers[next] = scratch_start[grf];
				end_numbers[next] =
				new_graph_numbers[2*grf+1]
					+ start_numbers[next] -1;
				next++;
				}
			}

					/*set up new _graph numbers*/
			for (grf=next=0, limit = 2*max_graphs; 
						grf < limit; grf++){
				if (new_graph_numbers[grf] != -1)
					new_graph_numbers[grf] = next++;
			}

return (next);
}/*end*/
int	l_number(	graph_seps_list_v, max_graphs, field_size,
			sep_numbers,
               		start_numbers, end_numbers, 
			new_numbers,
			new_graph_numbers,
			vtxs_list, index_vtxs_list,
			count_vtxs_list,
			scratch_start,
			scratch_end, coords_list,
			total_sep_size)
int			
                	*graph_seps_list_v, max_graphs, field_size,
			*sep_numbers,
			*start_numbers, *end_numbers, 
			*new_numbers,
			*new_graph_numbers,
			*vtxs_list, *index_vtxs_list,
			*count_vtxs_list,
			scratch_start,
			scratch_end, 	*coords_list,
			*total_sep_size;
{

			int	dim, limit, next;


			count_up_halves(
			graph_seps_list_v,
			new_graph_numbers,
			vtxs_list, index_vtxs_list,
			count_vtxs_list, 
			coords_list,deleted_v);

			size_seps (
				vtxs_list, index_vtxs_list,
				count_vtxs_list,
				max_graphs, 
				total_sep_size, 1, 0, deleted_v);
							/*tree chains etc*/




			next = 
			 	assign_new_numbers( 
                         	max_graphs, field_size,
				sep_numbers,
               			start_numbers, end_numbers, 
				new_numbers,
				total_sep_size,
				new_graph_numbers,
				vtxs_list, index_vtxs_list,
				count_vtxs_list,
				scratch_start,
				scratch_end
				);
			

return(next);
}/*end l_number_seps*/
add_up(					coords_list,
					max_graphs,
					in_graph,
					limits,
					vtx_list,
					index_vtx_list,
					count_vtx_list,
					xyz,
					to_be_deleted_list,
					new_graph_numbers)
/*
new_graph_numbers[2*grf], 2*grf+1 contains the number of vtxs 
remaining in each half
*/
int      		 		*coords_list,
					max_graphs,
					*in_graph,
					*limits,
					*vtx_list,
					*index_vtx_list,
					*count_vtx_list,
					*xyz,
					*to_be_deleted_list,
					*new_graph_numbers;
{

		
			int i, j, j_count, grf;
			for(i=limits[0] ; i < limits[1] ; i++){
				for(j= index_vtx_list[i],
				j_count = count_vtx_list[i];
					j_count > 0; j_count--, j++){
					grf = in_graph[vtx_list[j]];
					if (coords_list[grf] != EMPTY_LEVEL){
					if ((coords_list[grf] > xyz[vtx_list[j]])
						&& (to_be_deleted_list[
							vtx_list[j]] ==0))
						new_graph_numbers[2*grf] +=1;
					if ((coords_list[grf] < xyz[vtx_list[j]])
						&& (to_be_deleted_list[
							vtx_list[j]] ==0))
						new_graph_numbers[2*grf+1] +=1;
					if(to_be_deleted_list[vtx_list[j]] ==1)
						to_be_deleted_list[vtx_list[j]]
							=0;
					}
				}	
			}
}/*end add_up */
int consolidate_sep(	graphs_seps_list_ce, max_graphs, field_size, 
			cross_list, index_cross_list,      count_cross_list,
			sepv_list, index_sepv_list, count_sepv_list,
			scratch_list, index_scratch_list,
			count_scratch_list,	matrix_type)

int              	*graphs_seps_list_ce, max_graphs, field_size, 
			*cross_list, *index_cross_list,     *count_cross_list,
			*sepv_list, *index_sepv_list, *count_sepv_list,
			*scratch_list, *index_scratch_list,
			*count_scratch_list,	matrix_type;
{

			
			int  a,b, count, dim, i, j, j_limit, k, k_limit, next;

			for (i=next=count=0; i <max_graphs; i++){
				index_scratch_list[i] = next;
				dim = graphs_seps_list_ce[i*field_size];
				count =0;
				for (j=index_cross_list[i], 
					j_limit= index_cross_list[i]+
						count_cross_list[i];
					j< j_limit; j++){
					
					if (matrix_type ==SYMM){
					a = row_col[2*cross_list[j]];
					b = row_col[2*cross_list[j]+1];
					if ((a <my_N) && ( b<my_N)){
					if( (*(xyz[dim] +a)) <=
						 (*(xyz[dim] +b)))
						scratch_list[next++] = a;
					else 
						scratch_list[next++] = b;
					}else if (a< my_N)
						scratch_list[next++] = a;
						else 
						scratch_list[next++] = b;
					count++;
					} else {
						for 
						(k=a_index[cross_list[j]]+1,
						k_limit = a_index
							[cross_list[j] +1];
							k < k_limit; ){
						scratch_list
							[next++] =row_col[k];
						count++;
						k+= 2;
						}
					}
				}
				for (j=index_sepv_list[i], 
					j_limit= index_sepv_list[i]+
						count_sepv_list[i];
					j< j_limit; j++){
						scratch_list[next++] = 
						sepv_list[j];
						count++;
				}
				count_scratch_list[i] = count;
					
			}/*for*/
return(next);
}/*end consolidate*/
					
l_tree_stuff(
		vtxs_list, index_vtxs_list,
		count_vtxs_list,
		new_graph_numbers,
		end_numbers, 
		total_sep_size)
int
		*vtxs_list, *index_vtxs_list,
		*count_vtxs_list,
		
		*new_graph_numbers,
		*end_numbers, 
		*total_sep_size;
{
		
                        int i,j,j2, new,  count,k;
			extern	int *global_column;

					/*the tree stuff*/
			for (i=0, new=tree_size+max_graphs; 
				i <max_graphs; i++){
				chain_index[tree_size] = 
					last_chain_index;
				for ( k= end_numbers[i] - total_sep_size[i]+1,
					j=last_chain_index, 
					count = total_sep_size[i]; count >0;
							count--,k++,j++){
					tree_chains[j] = k; 
				}
				for ( j -= 1, 
					j2= index_vtxs_list[i],
					count = count_vtxs_list[i]; count >0;
							count--,j2++){
					if (tree_chains[j] ==
						new_numbers[vtxs_list[j2]]){
					o_n_tree_chains[j] = 
					global_column[
					vtxs_list[j2]];
					j--;
					}
					
				}
				tree_size+=1;
				last_chain_index += total_sep_size[i];	
				if(new_graph_numbers[2*i]!=0){
					tree_parent[new] =parent_number+i;
					new++;
				}
				if(new_graph_numbers[2*i+1]!=0){
					tree_parent[new] =parent_number+i;
					new++;
				}
			}
			parent_number = tree_size;
			chain_index[tree_size] = last_chain_index;
			last_color +=1;
}/*end l_tree_stuff*/
seps_lists(N,	M)
int		N, M;
{

		int dim;
		extern	g_N;
		extern	double sqrt();
		float tmp;
		if ((sepv_list = ( int *)
				my_malloc ((N*int_size))) == NULL)
				exit_err("allocate_seps_list1", malloc_err);
		if ((count_sepv_list = ( int *)
				my_malloc ((N*int_size))) == NULL)
				exit_err("allocate_seps_list2", malloc_err);
		if ((index_sepv_list = ( int *)
				my_malloc ((N*int_size))) == NULL)
				exit_err("allocate_seps_list3", malloc_err);
		if ((cross_list = ( int *)
				my_malloc ((Asubs*int_size))) == NULL)
				exit_err("allocate_seps_list4", malloc_err);
		if ((count_cross_list = ( int *)
				my_malloc ((Asubs*int_size))) == NULL)
				exit_err("allocate_seps_list5", malloc_err);
		if ((index_cross_list = ( int *)
				my_malloc ((Asubs*int_size))) == NULL)
				exit_err("allocate_seps_list6", malloc_err);
		if ((chain_index = ( int *)
				my_malloc (((N+2)*int_size))) == NULL)
				exit_err("allocate_seps_list7", malloc_err);
		if ( P>1){
		tmp = g_N;
		tmp = sqrt(tmp);
		dim = 2*tmp*log_2_P;
		if ( N>dim) dim = N;
		
		if ((tree_chains = ( int *)
				my_malloc (((dim)*int_size))) == NULL)
				exit_err("allocate_seps_list8", malloc_err);
		if ((o_n_tree_chains = ( int *)
				my_malloc (((dim)*int_size))) == NULL)
				exit_err("allocate_seps_list8", malloc_err);
		} else {


		if ((tree_chains = ( int *)
				my_malloc (((N)*int_size))) == NULL)
				exit_err("allocate_seps_list8", malloc_err);
		if ((o_n_tree_chains = ( int *)
				my_malloc (((N)*int_size))) == NULL)
				exit_err("allocate_seps_list8", malloc_err);

		}
		if ((tree_parent = ( int *)
				my_malloc (((N+2)*int_size))) == NULL)
				exit_err("allocate_seps_list9", malloc_err);
		if ( P>1){
		if ((start_numbers = ( int *)
				my_malloc (((P+1)*int_size))) == NULL)
				exit_err("allocate_seps_list10",malloc_err);
		}
		else
		if ((start_numbers = ( int *)
				my_malloc (((N+1)*int_size))) == NULL)
				exit_err("allocate_seps_list10",malloc_err);
		if ( P>1) {	
		if ((end_numbers = ( int *)
				my_malloc (((P+1)*int_size))) == NULL)
				exit_err("allocate_seps_list11",malloc_err);
		}
		else
		if ((end_numbers = ( int *)
				my_malloc (((N+1)*int_size))) == NULL)
				exit_err("allocate_seps_list11",malloc_err);
		if ((new_numbers = ( int *)
				my_malloc ((N*int_size))) == NULL)
				exit_err("allocate_seps_list13",malloc_err);
		if ((color = ( int *)
				my_malloc ((N*int_size))) == NULL)
				exit_err("allocate_seps_list14",malloc_err);

		set_to(new_numbers,N,EMPTY);
		set_to(color,N,0);
		if ((a_index = ( int *)
				my_malloc (((N+1)*int_size))) == NULL)
				exit_err("allocate_seps_list15",malloc_err);
		make_a_index(row_col, a_index);
}	
set_to(vec,count, val)
int	*vec, count, val;
{
		for (; count>0; count--, vec++)
					*vec= val;	
}

