/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include		"o_d_ext.h"
split_accumulate(		vtx_list,	size_vtx_list,
			beta_list,	 size_beta_list,
                        max_size_beta_list,
			eps_list,	 size_eps_list,
                        max_size_eps_list,
			dim)

int                  	*vtx_list,	*size_vtx_list,
			*beta_list,	 *size_beta_list,
                        max_size_beta_list,
			*eps_list,	 *size_eps_list,
                        max_size_eps_list,
			dim;
			
{

			int 	count, size, save, size_tmp,
				*hooks, *hooks_size;
			int 	i,j, own_start, own_size;
			extern	int my_graph_number;
			extern	double clock0(), my_time;
			double last_clock;
			/*
			creates a new catenated list (out)
                		of the form level1 #of fields fields... 
					level2 #of	fields 
                	level2> level1
                	field: graph id, vtx count, beta count, eps count
			*/
			make_list_from_counts(
			vtx_list,	*size_vtx_list,
			beta_list,	*size_beta_list,
			r_vector, 	&size_tmp,
			CAT);

			make_list_from_counts(
			r_vector,	size_tmp,
			eps_list,	*size_eps_list,
			s_vector, 	&size,
			CAT2);

			/*
			construct header information for recursive distributed
			splitting
			*/
			save = last_used_in_d_scratch_list;
			hooks = d_scratch_list+ 
				last_used_in_d_scratch_list +2*max_blocks+2;
			last_used_in_d_scratch_list += 2*max_blocks+2;
			hooks_size = hooks+ max_blocks+1;
			last_used_in_d_scratch_list += max_blocks+2;
			make_hooks(
				d_scratch_list,
				s_vector,	
				4,         /*field_size*/
				size, 
				k_vector,
				&size_k_vector,
				hooks,
				hooks_size,
				max_blocks,
				block_labels[dim],
				global_levels[dim],
				VTX_KAPPA);

			if((size_k_vector)
				>max_size_k_vector)
			exit_err("split_gather2",size_err);

			rec_split_gather(
					arg_int,
					hooks,
					hooks_size,
					VTX_KAPPA);

			own_start = hooks[my_pid];
			own_size = hooks_size[my_pid];
			p_way_merge_counts(
                        	max_graphs,
                        	max_levels[dim],
				block_labels[dim],
				own_start,
				own_size,
                        	k_vector,
                        	4, 1,
                        	vtx_list,
                        	size_vtx_list,
                        	2, 1);
			p_way_merge_counts(
                        	max_graphs,
                        	max_levels[dim],
				block_labels[dim],
				own_start,
				own_size,
                        	k_vector,
                        	4, 2,
                        	beta_list,
                        	size_beta_list,
                        	2, 1);
			p_way_merge_counts(
                        	max_graphs,
                        	max_levels[dim],
				block_labels[dim],
				own_start,
				own_size,
                        	k_vector,
                        	4, 3,
                        	eps_list,
                        	size_eps_list,
                        	2, 1);

			last_used_in_d_scratch_list = save;
}/*end split_gather*/
		
rec_split_gather(arg_int,
		hooks,
		hooks_size,
		option)
int		**arg_int,
		*hooks,
		*hooks_size,
		option;
{

		
		extern	int my_graph_number;
		
		initialize_arg_int(	arg_int,
					hooks,
					hooks_size,
					r_vector,
					&size_r_vector,
					s_vector,
					&size_s_vector,
					k_vector,
					&size_k_vector);
					
					

								

		split_cat_copy(		r_vector,
					&size_r_vector,
					&max_size_r_vector,
		                        s_vector,
					&size_s_vector,
					arg_int,
					NULL);


		if (size_s_vector > max_size_s_vector)
			exit_err("rec_split_gather1",size_err);
		dimensional_exchange(
					r_vector,
					&size_r_vector,
					&max_size_r_vector,
		                        s_vector,
					&size_s_vector,
					log_2_P,
					MS,
					(MSG_TYPE),
					processor_list,
					(split_cat_copy),
					arg_int,
					NULL);
						
}/*split_gather*/
initialize_arg_int(	
			arg_int,
			hooks,
			hooks_size,
			r_vector,
			size_r_vector,
			s_vector,
			size_s_vector,
			k_vector,
			size_k_vector )
int
			**arg_int,
			*hooks,
			*hooks_size,
			*r_vector,
			*size_r_vector,
			*s_vector,
			*size_s_vector,
			*k_vector,
			*size_k_vector;
{
			arg_int[PARAM0] =k_vector;
			arg_int[PARAM1] =size_k_vector;
			arg_int[PARAM2] = &P_subset_size;
			P_subset_size = P;
			arg_int[PARAM3] = hooks;
			arg_int[PARAM4] = hooks_size;
			arg_int[PARAM9] = &send_proc_start;;
			send_proc_start =0;
			arg_int[PARAM10] = &send_proc_end;
			send_proc_end =0;
			arg_int[PARAM11] = &keep_proc_start;;
			keep_proc_start =0;
			arg_int[PARAM12] = &keep_proc_end;
			keep_proc_end =P-1;

			r_vector[0] =0;
			*size_r_vector = 0;
}
make_hooks(
			scratch_list,
			list,	
			field_size,
			size_list, 
			k_vector,
			size_k_vector,
			hooks,
			hooks_size,
			max_blocks,
			block_labels,
			global_levels,
			type)
int
			*scratch_list,
			*list,	
			field_size,
			size_list, 
			*k_vector,
			*size_k_vector,
			*hooks,
			*hooks_size,
			max_blocks,
			*block_labels,
			*global_levels,
			type;
{


		int i, lvl, blk, no_of_fields, k_size, size;
		extern	 int *my_neighbors;

		for(blk=0; blk <=max_blocks; blk++) scratch_list[blk] = EMPTY;


		for (i=blk=k_size=0; ((i <size_list) && ( blk <max_blocks)); ){
			lvl = list[i];
			no_of_fields =list[i+1];
			if ((lvl >= block_labels[blk]) &&
				(lvl <block_labels[blk+1])){
				scratch_list[blk] =i;
				blk++;
				i+= no_of_fields *field_size +2;

			} else if (lvl >=block_labels[blk+1]){
				scratch_list[blk] =i;
				blk++;
				} else 
					i+= no_of_fields *field_size +2;
		}
		scratch_list[blk] = size_list;
		for (k_size=blk=0; blk <max_blocks; blk++){
			i = scratch_list[my_neighbors[blk]];
			size = scratch_list[my_neighbors[blk]+1] - i;
			if (size>= 1){

				hooks[my_neighbors[blk]] = k_size;
				hooks_size[my_neighbors[blk]] = size;
				copy(size,1,list+i,1,k_vector+k_size);
				k_size += size;
			} else   {
				hooks[my_neighbors[blk]] = k_size;
				hooks_size[my_neighbors[blk]] = 0;
				}
		}
		*size_k_vector = k_size;
	
}
cascade(
				r_vector,
				size_r_vector,
				max_size_r_vector,
				s_vector,
				size_s_vector,
				arg_int,
				arg_real)
int
				*r_vector,
				*size_r_vector,
				*max_size_r_vector,
				*s_vector,
				*size_s_vector,
				**arg_int;
real_type
				**arg_real;
{
/*
field has the form: block_id v_count kappa_count pairs for each dim
field_size = 3 if D=2
field_size = 4 if D=3
*/

			int *k_vector, field_size,
				i, j, k, limit, max_blocks;

			k_vector = arg_int[PARAM1];
			field_size = *(arg_int[PARAM2]);
			max_blocks = *(arg_int[PARAM3]);
			
			for (i=0, limit = field_size*max_blocks;
				i <limit; ){
				if (r_vector[i] < k_vector[i]){
				for (j=i+1, k=field_size-1;k >0; j++, k--)
					k_vector[j]+= r_vector[j];
				}
				s_vector[i] = (s_vector[i]>= r_vector[i])?
						s_vector[i] : r_vector[i];
				for (j=i+1, k=field_size-1;k >0; j++, k--)
					s_vector[j]+= r_vector[j];
			i+= field_size;
			}
			
						
}/*end cascade*/
cascade_gather	(	vtx_counts,
		 	size_vtx_counts,
			kappa_counts,
			size_kappa_counts,
			max_graphs)

int                 	**vtx_counts,
		 	*size_vtx_counts,
			**kappa_counts,
			*size_kappa_counts,
			max_graphs;
{

		int dim, field_size, i, limit, opcode, tmp;

		field_size = 2*D+1;
		for (i=0, limit= max_graphs*field_size; i <limit; 
				i++)
			k_vector[i] =  0;	

		for (i=0, limit= max_graphs*field_size; i <limit; 
				i+= field_size)
			s_vector[i] =  k_vector[i] =my_pid;	
		for (dim=0; dim <D ; dim++){
		make_graph_count_lists(
				vtx_counts[dim],
                                size_vtx_counts[dim], max_graphs,
				s_vector,field_size, 2*dim+1,
				0.0,
				NULL,
                                0,
				0,
				0,
				ADD);

		tmp=
		make_graph_count_lists(
				kappa_counts[dim],
                                size_kappa_counts[dim], max_graphs,
				s_vector,field_size, 2*dim+2,
				0.0,
				NULL,
                                0,
				0,
				0,
				NOT_ADD);

		size_kappa_counts[dim] = tmp; 
		}	

		arg_int[PARAM1] = k_vector;
		arg_int[PARAM2] = &field_size;
		arg_int[PARAM3] = &max_graphs;
		size_s_vector = size_k_vector =
			size_r_vector = max_graphs*field_size;

		dimensional_exchange(
					r_vector,
					&size_r_vector,
					&max_size_r_vector,
		                        s_vector,
					&size_s_vector,
					log_2_P,
					LS,
					(MSG_TYPE),
					processor_list,
					(cascade),
					arg_int,
					NULL);
		for (dim=0; dim <D ; dim++){
                        augment_count_lists(
                                kappa_counts[dim],
                                size_kappa_counts[dim],
                                max_graphs,
                                k_vector, field_size, 2*dim+2);
		}

}/*end cascade_gather*/
min_on_list(
				r_vector,
				size_r_vector,
				max_size_r_vector,
				s_vector,
				size_s_vector,
				arg_int,
				arg_real)
int
				*r_vector,
				*size_r_vector,
				*max_size_r_vector,
				*s_vector,
				*size_s_vector,
				**arg_int;
real_type
				**arg_real;
{
/*
field has the form: dim level count
set field to coorespond to min count
*/

			int i, j, count,
			 limit, max_blocks, field_size, offset;

		
			offset = *(arg_int[PARAM1]);
			field_size = *(arg_int[PARAM2]);
			max_blocks = *(arg_int[PARAM3]);
			for(i=0, limit = max_blocks*field_size; i<limit; ){
				if (
				(r_vector[i+offset] < s_vector[i+offset]) 	
				|| ((r_vector[i+offset] == s_vector[i+offset])
				&&(r_vector[i+offset-1] < s_vector[i+offset-1]))
				) {
					for( count= field_size; 
					count>0; count--, i++)
					s_vector[i] = r_vector[i];
				} else if((r_vector[i+offset] 
						== s_vector[i+offset])
				&&(r_vector[i+offset-1] == 
						s_vector[i+offset-1]) &&
				(r_vector[i+offset-2] >= 
						s_vector[i+offset-2])){
					for( count= field_size; 
					count>0; count--, i++)
					s_vector[i] = r_vector[i];
					
				} else i+= field_size;
			}
}/*end min_on_list*/
min_gather	(s_vector, max_graphs)
int		*s_vector, max_graphs;
{
			int offset, field_size, max_blocks;


			offset =2;
			field_size =3;
			max_blocks = max_graphs;
			arg_int[PARAM1] = &offset;
			arg_int[PARAM2] = &field_size;
			arg_int[PARAM3] = &max_blocks;
			size_s_vector = size_r_vector = max_blocks*field_size;
			
			
			dimensional_exchange(
					r_vector,
					&size_r_vector,
					&max_size_r_vector,
		                        s_vector,
					&size_s_vector,
					log_2_P,
					LS,
					(MSG_TYPE),
					processor_list,
					(min_on_list),
					arg_int,
					NULL);
}/*end min_gather*/
augment_count_lists(		count_list,
				size_count_list, max_graphs,
				graph_list, field_size, offset)
int		*count_list, 
		size_count_list, max_graphs, *graph_list, 
		field_size, offset;
/*

adds to count value at any level of a given grf the value at grf*field_size +
offset in graph list.
Is useful in cumulative counts
*/
{

		int grf,i,  lvl,  pairs_per_level;
		for (i=0 ; i < size_count_list; ) {
				lvl= count_list[i++];
				pairs_per_level = count_list[i++];
				for(; pairs_per_level>0; pairs_per_level--){
					grf = count_list[i++];
					grf=grf*field_size+offset; 
					count_list[i++] += graph_list[grf];
				}/*for*/
		}/*for*/
			
}/*end augment count_lists*/
augment_and_set_levels(		
				scratch_list,
				count_list, 
				size_count_list, max_graphs,
				graph_bounds, graph_bounds_field_size,
				prev_graph_list, total_graph_list,
				alpha, 
				field_size, offset)
int		*scratch_list,
		*count_list, 
		size_count_list, max_graphs, *graph_bounds,
		graph_bounds_field_size,
		*prev_graph_list, 
		*total_graph_list, 
		field_size, offset;
real_type		alpha;
/*

total_graph list contains total graph counts at grf*field_size+offset;
prev_graph list contains total graph counts over earlier processors 
		(hence blocks) at grf*field_size+offset;
scratch_list[grf] is set to alpha*total_graph count
graph_bounds at graph_bounds_field_size*grf + graph_bounds_offset is 
set to smallest level so that 
previous levels have a total count of less than alpha*total_graph count
but with levels have a value that is >=
is set to MARKER instead if no such level is found
*/
{

		int grf,i,  j, lvl,  pairs_per_level;
		for (grf =0; grf <max_graphs ; grf++) {
				i = grf*field_size +offset;
				j = grf*graph_bounds_field_size;
				if (total_graph_list[i] >10){
				if ((prev_graph_list[i] >= 
					((int) ((1.0 - alpha) *
					total_graph_list[i])))){
					graph_bounds[j] =
						graph_bounds[j+1] = LARGE_LEVEL;
					scratch_list[j] =LARGE_BOUND; 
					}
				else {
					graph_bounds[j] = LARGE_LEVEL;
					graph_bounds[j+1] = LARGE_LEVEL;
					scratch_list[j] = 
						(alpha) *total_graph_list[i]; 
					}
				} else {
						graph_bounds[j] = SMALL_LEVEL;
						graph_bounds[j+1] = LARGE_LEVEL;
						scratch_list[j] =LARGE_BOUND; 
				}
				scratch_list[j+1] =prev_graph_list[i]; 
		}

		for (i=0 ; i < size_count_list; ) {
				lvl= count_list[i++];
				pairs_per_level = count_list[i++];
				for(; pairs_per_level>0; pairs_per_level--){
				grf = count_list[i++];
				j = grf*graph_bounds_field_size;
				scratch_list[j+1] += count_list[i];
				if(scratch_list[j] != LARGE_BOUND) {
					if ((scratch_list[j] < 
						(scratch_list[j+1]))
						&& (graph_bounds[j] ==
						LARGE_LEVEL)) {
						graph_bounds[j] = lvl;
					}	
					if ((scratch_list[j+1] >= 
						(total_graph_list[grf*field_size
						+offset]
						-scratch_list[j]))
						&& (graph_bounds[j+1] ==
						LARGE_LEVEL)) {
						graph_bounds[j+1] = lvl;
					}	
				}
				i++;
				}/*for*/
		}/*for*/
			
}/*end augment_and_set_levels*/
add_on_list(
				r_vector,
				size_r_vector,
				max_size_r_vector,
				s_vector,
				size_s_vector,
				arg_int,
				arg_real)
int
				*r_vector,
				*size_r_vector,
				*max_size_r_vector,
				*s_vector,
				*size_s_vector,
				**arg_int;
real_type
				**arg_real;
{

			int i, count, limit, max_blocks, field_size;
		
			field_size = *(arg_int[PARAM1]);
			max_blocks = *(arg_int[PARAM2]);
			field_size =2;
			max_blocks = P;
			for(i=0, limit = max_blocks*field_size; i<limit; ){
				s_vector[i] += r_vector[i];
				i++;
				if (((int) r_vector[i]) > 
					((int ) s_vector[i]))
						s_vector[i] = r_vector[i];
				i++;
			}
}/*end add_on_list*/
add_gather	(s_vector)
int		*s_vector;
{
			int  field_size, max_blocks;


			field_size =2;
			max_blocks = P;
			arg_int[PARAM1] = &field_size;
			arg_int[PARAM2] = &max_blocks;
			size_s_vector = size_r_vector=
				max_blocks*field_size;
			
			
			dimensional_exchange(
					r_vector,
					&size_r_vector,
					&max_size_r_vector,
		                        s_vector,
					&size_s_vector,
					log_2_P,
					LS,
					(MSG_TYPE),
					processor_list,
					(add_on_list),
					arg_int,
					NULL);
}/*end add_gather*/
split_cat_copy(
				r_vector, size_r_vector,
				max_size_r_vector, s_vector,
				size_s_vector, arg_int,
				arg_real)
 int
				*r_vector, *size_r_vector,
				*max_size_r_vector, *s_vector,
				*size_s_vector, **arg_int;
real_type			**arg_real;
{


			extern		int my_graph_number;
			int 	code, *hooks,  *hooks_size,
				*P_subset_size,
			    	*k_vector, *size_k_vector, 
			    	k_vector_used, s_vector_used, 
				next_proc_index,
				*send_proc_start,	 *send_proc_end,
				*keep_proc_start,	 *keep_proc_end,
				i, i_count, j, j_limit,
				k, next_index, next_proc, 
				next_size, next_proc_count,
				r_vector_used, total_send_size;
			extern	 int *my_neighbors;


			k_vector = arg_int[PARAM0];
			size_k_vector = arg_int[PARAM1];
			k_vector_used = *size_k_vector;
			P_subset_size = arg_int[PARAM2];
			hooks = arg_int[PARAM3];
			hooks_size = arg_int[PARAM4];

			send_proc_start = arg_int[PARAM9];
			send_proc_end = arg_int[PARAM10];
			keep_proc_start = arg_int[PARAM11];
			keep_proc_end = arg_int[PARAM12];

			/*change_dim_exchange_parameters */

			update_procs(
				P_subset_size, my_pid,
				keep_proc_start,
				keep_proc_end,
				send_proc_start,
				send_proc_end);

			if (*P_subset_size > 0)
				do_recv_keep_to_send( r_vector, 
						s_vector, k_vector,
						size_k_vector,
						size_s_vector, 
						max_size_s_vector,
						*P_subset_size, 
						*send_proc_start,	 
						*send_proc_end,
						hooks, hooks_size);

			
			if ( *P_subset_size >0) {
			i = *P_subset_size-1;
			i = my_neighbors[i];
			*size_k_vector = hooks[i]  +
						hooks_size[i];

			}
			if((*size_k_vector)
				>max_size_k_vector)
			exit_err("split_gather2",size_err);

			do_recv_to_keep(r_vector,
					k_vector,
					size_k_vector,
					*keep_proc_start,
					*keep_proc_end,
					*P_subset_size, 
                                        hooks, hooks_size);

			stats[o_d_o] += (*size_k_vector+
					*size_s_vector);
		
}/* rec_split_gather_count*/
update_procs(
		P_subset_size, my_pid,
		keep_proc_start,
		keep_proc_end,
		send_proc_start,
		send_proc_end)
int
		*P_subset_size, my_pid,
		*keep_proc_start,
		*keep_proc_end,
		*send_proc_start,
		*send_proc_end;
{
				/*change_dim_exchange_parameters */
			*P_subset_size /= 2;
			if (*P_subset_size >0) {
				if (( my_pid >= *keep_proc_start)
				&& ( my_pid < (*keep_proc_start +
					*P_subset_size))){
					*keep_proc_end = 
						*keep_proc_start +
						*P_subset_size -1;

					*send_proc_start = 
						*keep_proc_end+1;
					*send_proc_end = 
						*send_proc_start+
						*P_subset_size -1;
					
				} else {
					*send_proc_start = 
						*keep_proc_start;
					*send_proc_end = 
						*send_proc_start+
						*P_subset_size -1;
					*keep_proc_start = 
						*send_proc_end+1;
					*keep_proc_end = 
						*keep_proc_start +
						*P_subset_size -1;
					}
			}
}/*end update_proc*/
do_recv_keep_to_send( r_vector, 
		s_vector, k_vector,
		size_k_vector,
		size_s_vector, max_size_s_vector,
		P_subset_size, send_proc_start,	 send_proc_end,
		hooks, hooks_size)
		
int
		*r_vector, 
		*s_vector,
		*k_vector,
		*size_k_vector,
		*size_s_vector,
		max_size_s_vector,
		P_subset_size,
		send_proc_start,	 send_proc_end,
		*hooks,	 *hooks_size;
		
{
			int 	s_vector_used, next_proc_index,
				i, j, j_limit, k, next_index, next_proc, 
				next_size, next_proc_count,
				r_vector_used, total_send_size;

				for(j=1,j_limit = r_vector_used= 
				2*(r_vector[0])+1, s_vector_used=
				total_send_size = 2*(P_subset_size)+1,
				i= send_proc_start; i<= send_proc_end; i++){
				next_proc = processor_list[i];
				next_proc_count =0;
				if ( (next_proc >= send_proc_start )&&
					(next_proc <= send_proc_end ) &&
					((j<j_limit))){
					for (; (r_vector[j] < next_proc) ; j+=2)
					r_vector_used+= r_vector[j+1];
						if(( r_vector[j])  
							== next_proc){
							next_size =  
							 r_vector[j+1];
							copy (next_size, 1, 
							(r_vector+r_vector_used), 
							1,( (s_vector+
							s_vector_used)));
			        			s_vector_used += 
								next_size;
							r_vector_used += 
							r_vector[j+1];
							next_proc_count +=
								next_size;
							j+=2;
						}	
					}/*if*/	
				next_index = hooks[next_proc];	
				next_size = hooks_size[next_proc];
				if(next_size >0) {
				if ((s_vector_used + next_size) <
					max_size_s_vector)
					copy (next_size,  1, 
					(k_vector+next_index), 
					1,((s_vector+s_vector_used)));
				else
				exit_err("rec_split_gather_count_s",size_err);
				}
			       	s_vector_used += next_size;
				next_proc_count += next_size;
				next_proc_index = i - send_proc_start;
				s_vector[2*next_proc_index+1] = next_proc;
				s_vector[2*next_proc_index+2] =next_proc_count;
				total_send_size += next_proc_count;
				}	

			*size_s_vector = total_send_size;
			stats[o_d_c] += total_send_size/5;
			s_vector[0] = (int) P_subset_size;

}/*end do_recv_keep_to_send*/

do_recv_to_keep(r_vector,
		k_vector,
		size_k_vector,
		keep_proc_start,
		keep_proc_end,
		P_subset_size,
		hooks, hooks_size)
int
		*r_vector,
		*k_vector,
		*size_k_vector,
		keep_proc_start,
		keep_proc_end,
		P_subset_size,
		*hooks, *hooks_size;
{
					
			int 	k_vector_used, 
				r_vector_used,
				extra,
				i, i_count, 
				next_proc, 
				next_size;
			extern	int *more, my_pid, my_graph_number,
				*my_neighbors;

			k_vector_used = *size_k_vector;

			for (i=keep_proc_start; i<=keep_proc_end; i++)
					more[i] = 0;
			for (extra=0, i_count= r_vector_used=
					2*(r_vector[0])+1, i=1; i < i_count; ){
				next_proc =  r_vector[i++];
				next_size=  r_vector[i++];
				if ( (next_proc >= keep_proc_start )&&
					( next_proc <= keep_proc_end )){
				more[next_proc] = next_size;
				extra += next_size;
				}
				else more[next_proc] =0;
			}	

			if (i_count >1) {
			if ((2*k_vector_used+extra)  > max_size_k_vector)
			exit_err("rec_split_gather_count_k",size_err);
			make_space_in_k_vector(more,
						P_subset_size,
						keep_proc_start,
						keep_proc_end,
						k_vector_used,
						k_vector,
						k_vector+k_vector_used+extra+1,
						hooks,
						hooks_size);
				
			}

			
			for (i_count= r_vector_used=
					2*(r_vector[0])+1, i=1;
					i < i_count; ){
				next_proc =  r_vector[i++];
				next_size=  r_vector[i++];
				if ( (next_proc >= keep_proc_start )&&
					( next_proc <= keep_proc_end )){
					copy (next_size,  1, 
					((r_vector+r_vector_used)), 
					1,(k_vector+more[next_proc]));
				}
				r_vector_used += next_size;
			}	
			if ( P_subset_size >0){
			i = P_subset_size-1;
			*size_k_vector = hooks[my_neighbors[i]] +
					hooks_size[my_neighbors[i]];
			} else *size_k_vector = hooks[my_pid] +
						hooks_size[my_pid];
			if (*size_k_vector > max_size_k_vector)
			exit_err("rec_split_gather_count_k",size_err);
}/*end do_recv_to_keep*/
make_space_in_k_vector(
		more,
		procs,
		keep_proc_start,
		keep_proc_end,
		k_vector_used,
		k_vector,
		scr,
		hooks,
		hooks_size)
int
		*more,
		procs,
		keep_proc_start,
		keep_proc_end,
		k_vector_used,
		*k_vector,
		*scr,
		*hooks,
		*hooks_size;
{

		int i,j,k, next, size;
		extern	 int *my_neighbors;

		if (procs ==0 ) procs =1;
		for (i=j=0; i < procs; i++) {
				k = my_neighbors[i];
				copy (hooks_size[k],  1, 
					((k_vector+hooks[k])), 
					1,(scr+j));
				j+= hooks_size[k];
		}
		for (i=j=k=0; i <procs; i++) {
			next = my_neighbors[i];
			hooks[next] = k;
			
			copy (hooks_size[next],  1, 
				(scr+j),1,
				(k_vector+hooks[next])); 
			j+= hooks_size[next];
			size = more[next];
			more[next] = hooks[next]+ hooks_size[next];
			hooks_size[next] += size;
			k += hooks_size[next];
		}
		if (procs >1) {
		for (i=0; i <P; i++) {
			if ((i < keep_proc_start)
				|| (i >keep_proc_end))
				hooks_size[i] = hooks[i] =0;
		}
		}
}/*end_make_space_in_k_vector*/

fanin_accumulate(		vtx_list,	size_vtx_list,
			beta_list,	 size_beta_list,
                        max_size_beta_list,
			eps_list,	 size_eps_list,
                        max_size_eps_list,
			dim)

int                  	*vtx_list,	*size_vtx_list,
			*beta_list,	 *size_beta_list,
                        max_size_beta_list,
			*eps_list,	 *size_eps_list,
                        max_size_eps_list,
			dim;
			
{

			int 	count, size, save, size_tmp,
				*hooks, *hooks_size;
			int 	i,j, own_start, own_size;
			extern	int my_graph_number;
			extern	double clock0(), my_time;
			double last_clock;
			/*
			creates a new catenated list (out)
                		of the form level1 #of fields fields... 
					level2 #of	fields 
                	level2> level1
                	field: graph id, vtx count, beta count, eps count
			*/
			make_list_from_counts(
			vtx_list,	*size_vtx_list,
			beta_list,	*size_beta_list,
			r_vector, 	&size_tmp,
			CAT);

			make_list_from_counts(
			r_vector,	size_tmp,
			eps_list,	*size_eps_list,
			s_vector, 	&size,
			CAT2);

			/*
			construct header information for recursive distributed
			splitting
			*/
			save = last_used_in_d_scratch_list;
			hooks = d_scratch_list+ 
				last_used_in_d_scratch_list +2*max_blocks+2;
			last_used_in_d_scratch_list += 2*max_blocks+2;
			hooks_size = hooks+ max_blocks+1;
			last_used_in_d_scratch_list += max_blocks+2;
			make_hooks2(
				d_scratch_list,
				s_vector,	
				4,         /*field_size*/
				size, 
				hooks,
				hooks_size,
				max_blocks,
				block_labels[dim],
				global_levels[dim],
				VTX_KAPPA);


			fanin_gather(	hooks,
					hooks_size,
					s_vector,
					k_vector);

			own_start = hooks[my_pid];
			own_size = hooks_size[my_pid];
			p_way_merge_counts(
                        	max_graphs,
                        	max_levels[dim],
				block_labels[dim],
				own_start,
				own_size,
                        	k_vector,
                        	4, 1,
                        	vtx_list,
                        	size_vtx_list,
                        	2, 1);
			p_way_merge_counts(
                        	max_graphs,
                        	max_levels[dim],
				block_labels[dim],
				own_start,
				own_size,
                        	k_vector,
                        	4, 2,
                        	beta_list,
                        	size_beta_list,
                        	2, 1);
			p_way_merge_counts(
                        	max_graphs,
                        	max_levels[dim],
				block_labels[dim],
				own_start,
				own_size,
                        	k_vector,
                        	4, 3,
                        	eps_list,
                        	size_eps_list,
                        	2, 1);

			last_used_in_d_scratch_list = save;
}/*end split_gather*/
		
fanin_gather( hooks,
		hooks_size,
		s_vector,
		k_vector)
int		
		*hooks,
		*hooks_size,
		*s_vector,
		*k_vector;
{
		int 	 size, proc,  msg_type,j, left, 
			info_bytes, info_type, info_from;

		
		left = max_size_k_vector*int_size;
		for (proc =0, msg_type =MSG_TYPE;
				 proc <P; proc ++,msg_type++ ) {
			if (proc == my_pid) {

				if (hooks_size[my_pid] != -1) {
				copy(hooks_size[my_pid],
					1,s_vector+hooks[my_pid],
					1,k_vector);
				hooks[my_pid] =0;
				} else {
					hooks[my_pid] =0;
					hooks_size[my_pid] =0;
				}
				for (j=0; j <P-1; j++) {

					recv0((char *) (k_vector+
						hooks_size[my_pid]),
						left,
						msg_type);
					recvinfo0(&info_bytes,
						  &info_type,
						  &info_from);
					
					size = info_bytes/real_size;
					if (size >1){
					hooks_size[my_pid] += size;
					left -= info_bytes;
					if (left <0)
					exit_err("split_gather_count_k",
					size_err);
					
					}

				}
			}
			else {
				if (hooks_size[proc] == -1) 
				send0((char *)
					(s_vector+ hooks[proc]),
					((int_size) ),
					msg_type,
					proc);
				else {
				send0((char *)
					(s_vector+ hooks[proc]),
					((int_size) * hooks_size[proc]),
					msg_type,
					proc);
				stats[o_d_c] += (hooks_size[proc]/4);
				}
			
			}
		}
		
						
}/*fanin_gather*/
make_hooks2(
			scratch_list,
			list,	
			field_size,
			size_list, 
			hooks,
			hooks_size,
			max_blocks,
			block_labels,
			global_levels,
			type)
int
			*scratch_list,
			*list,	
			field_size,
			size_list, 
			*hooks,
			*hooks_size,
			max_blocks,
			*block_labels,
			*global_levels,
			type;
{


		int i, lvl, blk, no_of_fields, size;

		for(blk=0; blk <=max_blocks; blk++) scratch_list[blk] = EMPTY;


		for (i=blk=0; ((i <size_list) && ( blk <max_blocks)); ){
			lvl = list[i];
			no_of_fields =list[i+1];
			if ((lvl >= block_labels[blk]) &&
				(lvl <block_labels[blk+1])){
				scratch_list[blk] =i;
				blk++;
				i+= no_of_fields *field_size +2;

			} else if (lvl >=block_labels[blk+1]){
				scratch_list[blk] =i;
				blk++;
				} else 
					i+= no_of_fields *field_size +2;
		}
		scratch_list[blk] = size_list;
		for (blk=0; blk <max_blocks; blk++){
			i = scratch_list[blk];
			size = scratch_list[blk+1] - i;
			if (size>= 1){

				hooks[blk] = i;
				hooks_size[blk] = size;
			} else   {
				hooks[blk] = 0;
				hooks_size[blk] = -1;
				}
		}
	
}
