/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	<stdio.h>
#include	"n_defs.h"

rec_solve	(
			current, 
			tree_child, 	tree_sibling,
		 	tree_parent,	tree_chains,
		 	chain_index,
			done_solution_elements,
			index_list)

int               	current,
			*tree_child, 	
			*tree_sibling,
		 	*tree_parent,	
			*tree_chains,
		 	*chain_index,
			*index_list,
			*done_solution_elements;


{
	int	child, n, t;




	for (child = tree_child[current]; child != -1; ) {
		

		rec_solve
			(child, 
			tree_child, 	tree_sibling,
		 	tree_parent,	tree_chains,
		 	chain_index,
			done_solution_elements,
			index_list);

	child = tree_sibling[child];
	}
	
	merge_rhs_spd	
			(current,
			tree_child,
			tree_sibling,
			tree_chains,
			chain_index,
			index_list);
			

					
	numeric_solve_spd
		(current,
		tree_chains,
		chain_index,
		index_list);





		
}/*end rec_factor_solve*/
numeric_solve_spd	
	(current,
	chain,
	chain_index,
	index_list)

int	current, 
	*chain,
	*chain_index,
	*index_list;
{


		extern	int	*factor_struc_sizes,
				**factor_struc,
				*tree_chains,
				done_solution_elements,
				*factor_index_list;
		extern	float 	*stack_b, **factor_nonz;
		extern	double	clock0(), stats[];

		double	last_clock, n, t;
		

		


		n = factor_struc_sizes[current];
		t = chain_index[current+1] - chain_index[current];
		last_clock = clock0();
		local_fsolve (	
				(factor_struc_sizes[current]),
				(chain_index[current+1] - chain_index[current]),
				(stack_b+ index_list[current]),
				(factor_nonz + factor_index_list[current]));
		stats[so_l_t] += clock0() - last_clock;
		move_into_solution (
	      			current,
				(tree_chains +chain_index[current]),
				(chain_index[current+1] - 
				chain_index[current]), 
				index_list,
				&done_solution_elements);
					
		stats[so_l_o] += (2*n*t - t*t);
}
	
