/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	"l_s_fact.h"
l_s_fact		( current, 
			tree_child, 	tree_sibling,
		 	tree_parent,	tree_chains,
		 	chain_index,
			done_factor_columns,
			index_list)

int               	current,
			*tree_child, 	
			*tree_sibling,
		 	*tree_parent,	
			*tree_chains,
		 	*chain_index,
			*index_list,
			*done_factor_columns;


{
	int	child, i,	max_child_b_size;
	extern	double	stats[];



	for (max_child_b_size=0,child = tree_child[current]; child != -1; 
					child =tree_sibling[child]) {
		
		l_s_fact	
			(child, 
			tree_child, 	tree_sibling,
		 	tree_parent,	tree_chains,
		 	chain_index,
			done_factor_columns,
			index_list);
		max_child_b_size = ( factor_struc_sizes[child] > 
					max_child_b_size)
					? factor_struc_sizes[child]: 
						max_child_b_size;
	}
	
	matrix_structure_spd 
			(current,
			tree_child,
			tree_sibling,
			tree_chains,
			chain_index,
			index_list,
			tree_local_column);
	stats[s_l_o] += factor_struc_sizes[current];
			

	*done_factor_columns += chain_index[current+1] - chain_index[current];
	done_factor_floats +=  (int)  ( (double) (
			(chain_index[current+1] - chain_index[current])
			* (factor_struc_sizes[current] )));
	for(i=0; i < (chain_index[current+1] - chain_index[current]); i++)
		done_factor_nonz += factor_struc_sizes[current] -i;
		
	max_b_size += max_child_b_size;
}/*end l_s_fact*/
matrix_structure_spd
		( current,
		tree_child,
		tree_sibling,
		chain, 	
		chain_index,
		index_list,
		local_column)

				
int		current,
		*tree_child,
		*tree_sibling,

		*chain, 	
		*chain_index,
		*index_list,
		*local_column;



{

		
		extern		int	*a_index,	*a_struc, *a_size;
		int		current_size,	child;

	


			
		tmp_list_size =0;
		check_and_realloc(&tmp_list, &max_tmp_list_size,
				2*tmp_list_size,
				(2*(chain_index[ current+1]
				- chain_index[current])));

		merge_int_lists(	
				chain[chain_index[current]],	
				tmp_list,		&tmp_list_size,
				(chain +chain_index[current]),
				(chain_index[current+1] -
				chain_index[current]),
				LINK_and_NOT_LINK);

		for(child = tree_child[current]; child!= -1; )      {
			check_and_realloc
				(&tmp_list, &max_tmp_list_size,
				2*tmp_list_size,
				(2*(factor_struc_sizes[child])));

			merge_int_lists(
				chain[chain_index[current]],	

				tmp_list,		
				&tmp_list_size,

				factor_struc[child],		
				factor_struc_sizes[child],
				LINK_and_NOT_LINK);


			child = tree_sibling[child] ;

		}



		
		
		merge_subs_of_A_spd(
				(chain_index+ current),
				(chain +chain_index[current]),
				(chain_index[current+1] - chain_index[current]), 
				(local_column +chain_index[current]),	
				a_struc,
				a_index,
				a_size);

		remove_duplicates(tmp_list, &tmp_list_size);

		if (( factor_struc[current] =  (int *) 
				malloc((tmp_list_size*int_size))) == NULL) 
				exit_err("merge_matrix_structure_spd",
						malloc_err);


		
		convert_from_links_and_copy(	factor_struc[current],
						&current_size,
						tmp_list,	
						tmp_list_size);

		if ( MSGLVL == TRACE_2) {
			printf("current %d\n",current);
			print_vec(stdout,factor_struc[current],0, current_size,
				"\n front structure\n");
		}
		set_up_stack_sizes_spd(	current,
					current_size,
					index_list,
					tree_child);
			
}/*end merge_matrix_structure_spd*/	
set_up_stack_sizes_spd(	current,
			current_size,
			index_list,
			tree_child)
int			current,
			current_size,
			*index_list,
			*tree_child;
{
		int child;

		factor_struc_sizes[current] = current_size;
		index_list[current] =stack_ptr;
		stack_ptr += factor_struc_sizes[current];
		index_list[current+1] =stack_ptr;
		stack_floats_list[current] = stack_floats;
		stack_floats +=  (int ) ((double)
				((factor_struc_sizes[current] * 
				(factor_struc_sizes[current] +1) *(0.5))));
		stack_floats_list[current+1] =  stack_floats;
		max_stack_columns = (max_stack_columns < stack_ptr ) ?
					 stack_ptr :
					max_stack_columns;
		max_stack_floats = (max_stack_floats < stack_floats ) ?
					 stack_floats :
					max_stack_floats;
				
		if (( child = tree_child[current]) != -1)
		{
		stack_ptr = index_list[child] + factor_struc_sizes[current];
		stack_floats = stack_floats_list[child] +
				((int) ((double)
				((factor_struc_sizes[current] * 
				(factor_struc_sizes[current] +1) *(0.5)))));
		stack_floats_list[current] = stack_floats_list[child];
		stack_floats_list[current+1] =  stack_floats;
		index_list[current] = index_list[child];
		index_list[current+1] = stack_ptr;
		max_stack_columns = (max_stack_columns < stack_ptr ) ? 
					stack_ptr :
					max_stack_columns;
		max_stack_floats = (max_stack_floats < stack_floats ) ?
					 stack_floats :
					max_stack_floats;
		}

}/*end set_up_stack_sizes_spd*/

merge_subs_of_A_spd(
	chain_index,
	chain,
	chain_size,
	local_column,
	a_struc,
	a_index,
	a_size)

int
	*chain_index,
	*chain,
	chain_size,
	*local_column,
	*a_struc,
	*a_index,
	*a_size;

{




			int	col, local_column_of_A;
		
			
					
				
					
			for (
				subs_list_size =1, *subs_list = chain[0],
				*(subs_list +1) = -1, col=0;
					col < chain_size; col++) {
			if (( local_column_of_A=local_column[col] ) !=
					EMPTY){
                        	check_and_realloc
                               		 (&subs_list, &max_subs_list_size,
                                	(2*subs_list_size),
                                	(2*(a_size[local_column_of_A])));	


				merge_int_lists(
					chain[0],
					subs_list,		
					&subs_list_size,
				       (a_struc+a_index[local_column_of_A]),
					(a_size[local_column_of_A]),
					LINK_and_NOT_LINK);
				}
			}
                        check_and_realloc
                                (&tmp_list, &max_tmp_list_size,
                                (2*tmp_list_size),
                                (2*(subs_list_size)));


			merge_int_lists(chain[0],
					tmp_list,
					&tmp_list_size,
					subs_list, subs_list_size,
					LINK_and_LINK);

}/*end*/

