/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
/*    
a dimensional exchange to sum a vector
over processors in processor_list
*/
#include	"o_defs.h"

p_subset_sum (
			me,
			my_pos,
			r_vector,
			s_vector,
			size_s_vector,

			nprocs, 
			start_proc,
			msg_type_param	)


double			*r_vector,
			*s_vector;
int			me,
			my_pos,
			
			size_s_vector,
						/* that which is to be sent 
						in each pass 		
						size_s_vector : meaningful
						number of floats*/
								        

			nprocs,
			start_proc,


			msg_type_param;
			            		/* used to generate msg
						type (id)		*/
{


			unsigned	to_do,		no_more, count;
			int		info_bytes, 	info_type,
					info_from, i;

			count = size_s_vector * (sizeof(double));


			for (	to_do = 1,
				no_more = nprocs;

				 (to_do < no_more);
					to_do =   (to_do << 1))
							
			{
				send0 (
					((s_vector )),

					count,
					msg_type_param+to_do,

					((int)(start_proc+(my_pos ^ to_do))));

				recv0 (
					( (r_vector)),

					((int) (count+10)),
					msg_type_param+to_do);



				recvinfo0(
						&info_bytes,
						&info_type,
						&info_from);


				if ( (info_type != (msg_type_param+to_do))
					|| (info_from != 
					(start_proc+(my_pos ^ to_do))))
				{
		
					printf(
					"%d:Error: \n",
					me);
                                        printf(
                                        "%d:Error: from: %d-%d, type %d-%d\n",
                                        me, start_proc +(my_pos^to_do),
                                                info_from,
                                                 ( to_do+ msg_type_param),
                                                                info_type);

					exit_err("p_subset_sum",int_err3);
				}
						
				for (i=0; i <size_s_vector; i++)
					s_vector[i] += r_vector[i];

				/*replace by saxpy in asm version */


			} /*for*/
}/*end p_subset_sum */

