/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include		"o_defs.h"
extern	char		*malloc();
copy (count,	inc_from, from, inc_to, to)
int	count,	inc_from,	*from, 	inc_to,	*to;
{
		register int i, *my_to, *my_from;
		for (i=0, my_to=to, my_from=from; i < count; i++,
				my_to+= inc_to, my_from+= inc_from)
				*my_to = *my_from;
}/*end copy*/
copy_real (count,	inc_from, from, inc_to, to)
int	count,	inc_from,	inc_to;
real_type	*from,	*to;
{
		register int i;
		register real_type  *my_to, *my_from;
		for (i=0,my_to=to, my_from=from; i < count; i++,
				my_to+= inc_to, my_from+= inc_from)
				*my_to = *my_from;
}/*end copy*/
copy_and_permute (count,	inc_order, order_list, from, inc_to, to)
int	count,	inc_order, 	*order_list, 	*from, 	inc_to,	*to;
{
		register int i,  k;
		register int *my_to;
		for (i=k=0, my_to = to; i < count; 
					i++, k+=inc_order, my_to += inc_to)
				*my_to = from[order_list[k]] ;
}/*end copy_and_permute*/
copy_and_permute_real (count,	inc_order, order_list, from, inc_to, to)
int	count,	inc_order, 	*order_list, 	inc_to;
real_type	*from,	*to;
{
		register int i,  k;
		register real_type  *my_to;
		for (i=k=0, my_to=to; i < count; 
					i++, k+=inc_order, my_to += inc_to)
				*my_to = from[order_list[k]] ;
}/*end copy_and_permute*/


permute(	count,	field_size,
		new, key_list, real_key_list)
int		count,	*new,	*key_list,	
		field_size;
real_type	*real_key_list;
/*
permute fields in key list according to new
let new[i] =j 
then field j gets what was field i
*/
{
		int	  i, k, l, now, next, save[MAX_FIELD_SIZE], *s1, *k1;
		register 	int buf;
		real_type	real_save[MAX_FIELD_SIZE], *rs1, *rk1;
		register real_type rbuf;
		

		for (i=0; i <count; i++){
			now =i;
			if ((next= new[now]) >=0){
				k = now*field_size;
				if (key_list != NULL){
					for(s1= save,l=0,k1=key_list+k; 
						l <field_size; l++, s1++, k1++) 
						*s1 = *k1; 
					
					for (; next >=0; ){
						k = next*field_size;
						for(s1= save,l=0,k1=key_list+k; 
						l <field_size; l++,s1++, k1++) {
							buf = *s1;
							*s1 = *k1;
							*k1 = buf;
						} 
						new[now] = 0 - new[now] -1;
						now = next;
						next = new[now];
					}	
				
				}/*if key*/
				else {
					for(rs1= real_save,l=0,rk1=
						real_key_list+k; 
						l <field_size;
						l++, rs1++, rk1++) 
						*rs1 = *rk1; 

					for (; next >=0; ){
						k = next*field_size;
						for(rs1= real_save,l=0,
						rk1=real_key_list+k; 
						l <field_size;l++, 
							rs1++, rk1++) {
							rbuf = *rs1;
							*rs1 = *rk1;
							*rk1 = rbuf;
						} 
						new[now] = 0 - new[now] -1;
						now = next;
						next = new[now];
					}	
				}/*else*/
			}
		}
		for (i=0; i < count ; i++)
			new[i] = 0- new[i] -1;
}/*end permute*/

inverse_perm(	count,	inverse,	perm)
int		count, 	*inverse,	*perm;
{
			int i;
			for (i=0; i <count; i++)
				inverse[perm[i]] = i;
}

swap( a,	b)
int	*a, *b;
{
		int tmp;
		tmp = *a;
		*a = *b;
		*b = tmp;
}
swap_real( a,	b)
real_type	*a, *b;
{
		real_type	 tmp;
		tmp = *a;
		*a = *b;
		*b = tmp;
}

exit_err(str, code)
char *str;
int code;
{
	extern	int me, P;
	int	i;
			/* try sleeping a tad to avoid an ugly
				display of possibly many many messages 
			*/
	for (i= me*100000000; i >0; i--)
				; /*sleep */
	switch	(code) {

	case malloc_err: 
			printf("\n%3d: Error: Out of memory\n", me);
			break;
	case size_err: 
			printf("\n%3d: Error: Try increasing store factor\n", me);
			break;
	case fopen_err:
			printf("\n%3d: Error: In opening file \n", me);
			break;
	case count_err:
			printf("\n%3d: Error: In input data\n", me);
			break;
	case arg_err:
			printf("\n%3d: Error: In arguments:%s\n",me,str);
			break;
	case not_twice:
			printf("\n%3d: Error: A separator results in just one piece\n"
					,me);
			printf("\n%3d: Try a different alpha or decrease P\n"
					,me);
			break;
	case int_int:
			printf("\n%3d:Error: An exception occured! Oops!!",me);
			printf("\n    (1)Try increasing store factor\n", me);
			printf("\n    (2)Try alpha for better balance\n", me);
			printf("\n    (3)If the problem is not solved by  (1) and (2) send e-mail to Padma\n", me);
			break;
	default:
		printf("\n%3d:Internal Error: Please e-mail details to Padma\n",
				me);
		break;
	}
	exit ();
}
value_check(list, size, max_graphs, cut_off, string)
int	*list, size, max_graphs, cut_off;
char *string;
{

		int i;
		for (i=0; i <size; i++) {
			if (list[i] <cut_off){
				print_vec(stdout, list, 0, size, 
					"\nnegative check failed\n");
				printf("\n%s max_graphs %d cut_off %d \n", 
				string, max_graphs, cut_off);
			}
		}
}
char *my_malloc(x)
int x;
{
	char *y;
	y = malloc((x+200));
	return((char *) y);

	
}
exceptions(code)
long	code;
{
	exit_err("handler",int_int);

}
start_up(count)
int count;
{

		int	nprocs,  host;
		extern	int my_pid, MSGLVL,me;

	                open0(&nprocs, &my_pid, &host);
       		        who0(&nprocs, &my_pid, &host);
			/*
			handler(3,exceptions);
			handler(6,exceptions);
			handler(13,exceptions);
			handler(14,exceptions);
			*/
		me= my_pid;
		MSGLVL =0;
		if (count!= 5) {
			if (my_pid ==0) 
			exit_err(
"load command should specify in-file, out-file, alpha, and store factor",
				arg_err);
		}
		
}
clean_up()
{
		close0();
}
put_out_data(	string, pid_string,
		n, tree_size, a_index, a_struc, 
		tree_chain, tree_chain_index, tree_parent,
		tree_child, tree_sibling)
char		*string, 	*pid_string;
int		n, tree_size, *a_index, *a_struc, 
		*tree_chain, *tree_chain_index, *tree_parent,
		*tree_child, *tree_sibling;
{

			char out_file[80];
			extern 	int old_P, P, g_N, local_phase_root,
				*tree_local_column, *a_size;
			extern	int *tree_start_procs,
					*tree_end_procs,
					*tree_count_procs, d_tree_size;
			FILE	*fp;
			sprintf(out_file,"%s_s.%s",string,pid_string);
			if ((fp=fopen( out_file, "w")) == NULL)
				exit_err("put_out_data",fopen_err);
	
			fprintf(fp, "%d %d %d %d %d %d %d %d\n",
					g_N,n, tree_size,d_tree_size,
					tree_chain_index[tree_size],
					a_index[n],old_P, local_phase_root);
			if (old_P>1) {
			put_vec_decr(fp, tree_start_procs, 
					d_tree_size-1,d_tree_size,
						"tree_start_procs");
			put_vec_decr(fp, tree_end_procs, d_tree_size-1,
						d_tree_size,
						"tree_end_procs");
			put_vec_decr(fp, tree_count_procs, d_tree_size-1,
						d_tree_size,
						"tree_count_procs");
			}
			put_vec(fp, tree_parent, 0,tree_size,"tree_parent");
			put_vec(fp, tree_child, 0,tree_size,"tree_child");
			put_vec(fp, tree_sibling, 0,tree_size,"tree_sibling");
			put_vec(fp, tree_chain_index, 0,tree_size+1,
							"tree_chain_index");
			put_vec(fp, tree_chain, 0,tree_chain_index[tree_size],
						 "tree_chain");
			put_vec(fp, tree_local_column, 
					0,tree_chain_index[tree_size],
						 "tree_local_column");
			put_vec(fp, a_index, 0,n, "a_index");
			put_vec(fp, a_size, 0,n, "a_size");
			put_vec(fp, a_struc, 0,a_index[n], "a_struc");
printf("Leaving\n");
}/*end put_out_data*/
put_vec( pfp, vec,    begin,          count,          msg)
int     *vec,   begin,  count;
char    *msg;
FILE    *pfp;
{
                int     i;
                fprintf(pfp,"%s\n",msg);
                for (i = begin; count >0 ; count--, i++) {
                                fprintf(pfp, "%d ", *(vec+i));
                                if ((count % 20 ) == 0) fprintf(pfp,"\n");
                }
                fprintf(pfp,"\n");
}/*end put_vec*/
put_vec_decr( pfp, vec,    begin,          count,          msg)
int     *vec,   begin,  count;
char    *msg;
FILE    *pfp;
{
                int     i;
                fprintf(pfp,"%s\n",msg);
                for (i = begin; count >0 ; count--, i--) {
                                fprintf(pfp, "%d ", *(vec+i));
                                if ((count % 20 ) == 0) fprintf(pfp,"\n");
                }
                fprintf(pfp,"\n");
}/*end put_vec*/
gather_stats(fname, str)
char	 *fname, *str;
{
		extern	double	stats[];
		extern	int me, P;
		double	tmp[MAX_STATS],
			small_stat[MAX_STATS], big_stat[MAX_STATS],
			total_stat[MAX_STATS];
		
		int	i, count,size;
		if (me ==0) {
		for (i=0; i<MAX_STATS; i++)
			small_stat[i] = big_stat[i] = total_stat[i] = stats[i];
		}	
			/*flops: min, times: max*/
		size = sizeof(double) * MAX_STATS;
		if (me ==0){
			for (count=0; count <(P-1); count++){
				recv0(((char *) tmp),
					size,
					STAT_TYPE);
				process_stats(tmp,small_stat, big_stat,
						total_stat);
			}
			small_stat[A_nz] /=Thousand;
			big_stat[A_nz] /=Thousand;
			total_stat[A_nz] /=Thousand;
			small_stat[L_nz] /=Thousand;
			big_stat[L_nz] /=Thousand;
			total_stat[L_nz] /=Thousand;
			print_stats(small_stat, big_stat, total_stat, 
				fname,str);
		}else 
				send0(((char *) stats),
					size, STAT_TYPE, 0);
}
process_stats(tmp, min_stat, max_stat, total)
double	*min_stat, *max_stat, *total, *tmp;
{
			int i;

			for (i=0; i <MAX_STATS; i++){
				if (tmp[i] > max_stat[i]) 
					max_stat[i] = tmp[i];
				if (tmp[i] < min_stat[i]) 
					min_stat[i] = tmp[i];
					total[i] += tmp[i];
			}
}

char	*stat_labels(i)
int	i;
{
	
	static char  *labels[] ={
		"A-columns",
		"A-nonzeroes",
		"L-columns",
		"L-nonzeroes",
		"Number Sent",
		"Number of Ops",
		"Execution Rate",
		"Execution Time",
		"Initialization",
		"Redistribution",
		"Ordering",
		"Distributed Ordering",
		"Local Ordering",
		"S-Factorization",
		"Distributed S-Factorization",
		"Local S-Factorization",
		"N-Factorization",
		"Distributed N-Factorization",
		"Local N-Factorization",
		"Solve",
		"Distributed Solve",
		"Local Solve"
	};
	return((labels[i]));
}
print_stats(min_stat, max_stat, total_stat, fname,  str)
double	*min_stat, *max_stat, *total_stat;
char *fname, *str;
{

			int i,j,k;
			char	 x_file[80];
			FILE	 *fp;
			extern int g_N, g_Asubs,D;
			extern	 float alpha;
                	sprintf(x_file, "%s.stats",fname);
			if ((fp=fopen(x_file,"w")) == NULL)
                                      exit_err("print_stats",fopen_err);

                        fprintf(fp, "%-20s%50s\n",
                                "File Identification",
				str);
                        fprintf(fp, "%-50s%20d\n",
                                "Number of Processors",
                                	P);
                        fprintf(fp, "%-50s%20d\n",
                                "Number of Dimensions",
                                	D);
                        fprintf(fp, "%-50s%20.2f\n",
                                "Balance Factor (alpha)", alpha);
                        fprintf(fp, "%-50s%20d\n",
                                "Number of Equations ",
                                g_N);
                        fprintf(fp, "%-50s%20d\n\n",
                                "Number of Nonzeroes in A",
                                g_Asubs);
			fprintf(fp, "\n%15s %15s %15s %15s\n\n",
					"","Minimum", "Maximum", "Total");

                        for (i=0; i <4; i++)
                                fprintf(fp,"%-15s %15.2lf %15.2lf %15.2lf\n",
                                (stat_labels(i)),
                                min_stat[i], max_stat[i],total_stat[i]);
                        for (j=36,i=12; i <13; i++){
                                fprintf(fp,"\n%-15s\n",
                                        (stat_labels(i+4)));
                                for (k=0; k <4; k++, j++)
                                fprintf(fp,"%15s %15.2lf %15.2lf %15.2lf\n",
                                (stat_labels((j%4+4))),
                                min_stat[j], max_stat[j],total_stat[j]);
                        }


                                j=48;
                                i =15;
                                fprintf(fp,"\n%-15s\n",
                                        (stat_labels(i+4)));
                                for (k=0; k <4; k++, j++)
                                fprintf(fp,"%15s %15.2lf %15.2lf %15.2lf\n",
                                (stat_labels((j%4+4))),
                                min_stat[j], max_stat[j],total_stat[j]);


fprintf(fp,"\n A-nonzeroes, L-nonzeroes, and  Number Sent in thousands.");
fprintf(fp,"\n Number of Ops in millions and Execution Time in seconds.");
fprintf(fp,"\n Execution Rate in millions/second.\n");
fclose(fp);
			
}
set_up_neighbors(my_pid, procs, eddies_list, processor_list)
int	my_pid, procs, *eddies_list, *processor_list;
{

		int i, j, k, group, size, start, next;
		group = my_pid/2;
		
		for (eddies_list[0] = my_pid,
				next=1, size=2, group = my_pid/2; 
				size<=procs; size+=size) {
				start= size*group;

				for (j=start, k= start+size; j <k;  j++)
					if ((processor_list[j] != my_pid)
					&& (processor_list[j] >=0)) {
					eddies_list[next++] =
						 processor_list[j];
					processor_list[j] = 0- processor_list[j]
								-1;
					}
				group /=2;
		}
		for (i=0; i <procs; i++) {
			if (processor_list[i] <0)
			processor_list[i] = 0 - processor_list[i] -1;
		}
		
		
}
