/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	"o_defs.h"
#include	"o_ext.h"
extern		int	 *b_global_column;
static	FILE		*fp;
extern		int	
		*block_labels[],
		my_pid;
			
read_vec	(fp, vec,	begin,	count)
int		*vec,	begin,	count;
FILE	*fp;
{

	for (vec +=begin; count >0; count--,vec++)
			fscanf(fp, "%d", (vec));

}

read_vec_float	(fp,	vec,	begin,	count)
float		*vec;
int		begin,	count;
FILE	*fp;
{


	for (vec +=begin; count >0; count--,vec++)
			fscanf(fp, "%f", (vec));

}

print_vec( fp, vec,    begin,          count,          msg)
int     *vec,   begin,  count;
char    *msg;
FILE    *fp;
{
                int     i;
		extern	int my_pid;
                fprintf(fp,"%d:%s:",my_pid, msg);
                for (i = begin; count >0 ; count--, i++) {
                        fprintf(fp, "%d ", *(vec+i));
                        if ((count % 30 ) == 0)
                                        fprintf(fp,"\n");
                }
                fprintf(fp,"\n");
}

print_vec_float( fp,   vec,    begin,          count, msg)
int     begin,  count;
char    *msg;
float   *vec;
FILE    *fp;
{
                int     i;
                fprintf(fp,"%d:%s:",me, msg);
                for (i = begin; count >0 ; count--, i++) {
                        fprintf(fp, "%.4f ", *(vec+i));
                }
                fprintf(fp,"\n");
}
get_data	(file_stem,	data_type)
char		*file_stem;
int		data_type;
{



	get_block_labels(fp,	block_labels);	
	get_coords_int(fp,	global_column, 
			xyz_int[0],	xyz_int[1],	xyz_int[2]);
	get_local_row_col(fp, row_col);
	fclose (fp);
	sprintf(in_file, "%s.nonz.%s",file_stem, pid_string);
	if ((fp=fopen(in_file,"r")) == NULL) 
                        exit_err("get_data",fopen_err);

	if (data_type == FLOAT)
		get_nonz_float(fp,	global_row_col, a_nonz, b);
	else
		exit_err("Only float supported", case_err);
		
	fclose (fp);

}
get_local_row_col(fp,	e_list)
FILE	*fp;
int	*e_list;
{

	int	count;
	for(count=0; ((fscanf(fp, "%d %d", e_list, (e_list+1) ))
			!= EOF); count++, e_list+=2) ;
	if (count != Asubs) 
                        exit_err("get_local_row_col",count_err);
}
get_nonz_float(fp,	e_list,	 nonz, b)
FILE	*fp;
int	*e_list;
real_type	 *nonz,	*b;
{

	int	count;
	double foob;
	for(count=0; count < Asubs; count++, e_list+=2, nonz++){
		fscanf(fp, "%d %d  %f", e_list, (e_list+1), nonz);
		/*
		fscanf(fp, "%d %d  %lf", e_list, (e_list+1), &foob);
		if ((*e_list) != (*(e_list+1))) *nonz = -1.0;
		else *nonz = 100.0;
		*/
	}
	for(count=0; count < my_N; count++, b++)
		fscanf(fp, "%f",  b);
}
get_block_labels(fp,	labels)
FILE	*fp;
int	**labels;
{

	int	dim, count, limit, *l;
	limit = P+1;
	for (dim=0; dim <D; dim++) {
			l = labels[dim];
			for(count=0; count < limit; count++, l++) 
		 		fscanf(fp, "%d",  l);
	}
}
get_coords_int(fp,	g_col, 	x,	y,	z)
FILE	*fp;
int	*g_col, 	*x,	*y,	*z;
{

	int	count;
	if (D==3){
		for(count=0; count < N;
			 count++,g_col++,  x++,y++, z++) 
		 fscanf(fp, "%d %d %d %d", g_col,  x, y, z);
	}else  {
		for(count=0; count < N;
			 count++, g_col++, x++,y++)  {
			 fscanf(fp, "%d %d %d",g_col, x, y);
			}
		}
}
get_coords_float(fp,	x,	y,	z)
FILE	*fp;
real_type	*x,	*y,	*z;
{

	int	count;
	real_type	index;
	if (D==3){
		for(count=0; ((fscanf(fp, "%f %f %f", x, y, z))
			!= EOF); count++, x++,y++, z++) ;
	}else  {
		for(count=0; ((fscanf(fp, "%f %f",  x, y))
			!= EOF); count++, x++,y++) ;
		}
	if (count != N) 
                        exit_err("get_coords_float",count_err);
}

get_specs	(file_stem)
char		*file_stem;
{
	sprintf(in_file, "%s.xyz_int.%s",file_stem, pid_string);

	if ((fp=fopen(in_file,"r")) == NULL) {
                        exit_err("get_specs",fopen_err);
			return(fopen_err);
	}

	fscanf(fp, "%d %d %d %d %d %d %d %d %d %d",
						&g_N,
						&g_M,
						&g_Asubs,
						&N,
						&M,
						&Asubs,
						&P,
						&D,
						&T, 
						&my_N);	
	return(0);

}

allocate_nonz_coord_space()
{

		int dim;
		if ((row_col = (int *) my_malloc(((2*Asubs)
						*int_size))) == NULL)
                        exit_err("Error allocating row_col", malloc_err);
		if ((global_row_col = (int *) my_malloc(((2*Asubs)
						*int_size))) == NULL)
                        exit_err("Error allocating row_col", malloc_err);
		if ((a_nonz = (real_type *) my_malloc(((Asubs)
						*real_size))) == NULL)
                        exit_err("Error allocating a_nonz", malloc_err);
		if ((b = (real_type *) my_malloc(((my_N)
						*real_size))) == NULL)
                        exit_err("Error allocating b", malloc_err);
		
		if ((global_column = (int *) my_malloc(((N)
						*int_size))) == NULL)
                        exit_err("Error allocating global_column", malloc_err);
		if ((b_global_column = (int *) my_malloc(((N)
						*int_size))) == NULL)
                        exit_err("Error allocating b_global_column",malloc_err);
		if ((global_column_srted = (int *) my_malloc(((N)
						*int_size))) == NULL)
                        exit_err("Error allocating global_column_srt",
					malloc_err);

		for (dim=0; dim <D; dim++){
			if ((xyz_int[dim] = (int *) my_malloc(((N)
						*int_size))) == NULL)
                        	exit_err("Error xyz_int",malloc_err);
			if ((xyz[dim] = (int *) my_malloc(((N)
						*int_size))) == NULL)
                        	exit_err("Error xyz_int",malloc_err);
			if ((block_labels[dim] = (int *) my_malloc(((P+1)
						*int_size))) == NULL)
                        	exit_err("Error xyz_int",malloc_err);
			
		}

}/*end allocate nonz_coord_space*/
