/*---------------------------------------------------------------*/
/*     	CAPSS: A Cartesian Parallel Sparse Solver                */
/*     	Beta Release                                             */
/*      Author: Padma Raghavan                                   */
/*---------------------------------------------------------------*/
#include	"n_merges.h"
copy_expand (
		add_or_not,
		column,
		into_struc,
		into_nonz,
		into_struc_size,

		from_struc,
		from_nonz,
		from_struc_size)
int		
		add_or_not,
		column,
		*into_struc,
		into_struc_size,
		
		*from_struc,
		from_struc_size;

double		*into_nonz,	*from_nonz;
{
		

		int	*from_limit, *into_limit;
		

		from_limit = from_struc+ from_struc_size;
		into_limit = into_struc+ into_struc_size;

		for ( ;*into_struc < column; into_struc++, into_nonz++);
		for ( ;*from_struc < column; from_struc++, from_nonz++);

		for (; 	(from_struc < from_limit) ;) {
			
			if ( (*into_struc != *from_struc)) {
					into_struc++;
					if (add_or_not == NOT_ADD)
						*into_nonz++  = 0.0 ;
					else into_nonz++;
			} else	{
					into_struc++; from_struc++ ;
					if (add_or_not == NOT_ADD)
						*into_nonz++ = *from_nonz++;
					else
						*into_nonz++ += *from_nonz++;
			}
		}/*for*/
		if (add_or_not == NOT_ADD) {
			
			for (; into_struc < into_limit;into_struc++)
					*into_nonz++ = 0.0;
		}
						
}/*end copy_expand*/

copy_expand_flt (
		add_or_not,
		column,
		into_struc,
		into_nonz,
		into_struc_size,

		from_struc,
		from_nonz,
		from_struc_size)
int		
		add_or_not,
		column,
		*into_struc,
		into_struc_size,
		
		*from_struc,
		from_struc_size;

double 	*into_nonz;
float		*from_nonz;
{
		

		int	*from_limit, *into_limit;
		

		from_limit = from_struc+ from_struc_size;
		into_limit = into_struc+ into_struc_size;

		for ( ;*into_struc < column; into_struc++, into_nonz++);
		for ( ;*from_struc < column; from_struc++, from_nonz++);

		for (; 	(from_struc < from_limit) ;) {
			
			if ( (*into_struc != *from_struc)) {
					into_struc++;
					if (add_or_not == NOT_ADD)
						*into_nonz++  = 0.0 ;
					else into_nonz++;
			} else	{
					into_struc++; from_struc++ ;
					if (add_or_not == NOT_ADD)
						*into_nonz++ = *from_nonz++;
					else
						*into_nonz++ += *from_nonz++;
			}
		}/*for*/
		if (add_or_not == NOT_ADD) {
			
			for (; into_struc < into_limit;into_struc++)
					*into_nonz++ = 0.0;
		}
						
}/*end copy_expand_flt*/
print_local_phase_results( pfp,
	done_factor_cols,
	tree_chains,
	chain_index,
	index_list,
	tree_size)

FILE	*pfp;
int	
	*done_factor_cols, 
	*index_list, 
	*tree_chains, 
	*chain_index,
	tree_size;
{
			int i;
				

			for (i=0, index_list[tree_size] =
				*done_factor_cols; i < tree_size; i++) {
				fprintf(pfp,"Clique: %d\n",i);
				print_vec(pfp,factor_struc[i],
						0, factor_struc_sizes[i],"\nStructure");
				print_matrix(pfp,factor_index_list[i],
						factor_index_list[i+1], 
						factor_nonz, factor_nonz_sizes,
							"\nNonz\n");
			}
			print_vec_float(pfp,b,0,tree_size,"Vector b\n");
}/*end print_local_phase_results*/
zero_out(vec, size)
double	*vec;
int	size;
{
		for (; size >0; size--, vec++)
			*vec = 0.0 ;
}/*end zero_out*/
print_matrix(
		file_p,
		start,
		finish,	
		nonz, 
		nonz_sizes,
		msg)

FILE		*file_p;
int		start,	finish, *nonz_sizes;
double		**nonz;
char		*msg ;
{
		int j;

		fprintf(file_p, "%s\n",msg);
		
		for (j=start; j < finish; j++) {
			
			print_vec_float(file_p, 
					nonz[j], 0, nonz_sizes[j],
						"");
		}
}/*end print_matrix*/

		
move_into_factor (
	      	current,
		chain,
		chain_size,		
		index_list,
		done_factor_cols)

int	
	      	current,
		*chain,
		chain_size,		
		*index_list,
		*done_factor_cols;
{
		int	col,	this,	this_nonz,	*this_struc;
		double		 *tmp_store;
		int	tmp_store_size;
		extern	double stats[];


		if ((*done_factor_cols + chain_size) > max_factor_columns) {
		exit_err("done>maxfactor",int_err3);
		}
		tmp_store_size = (chain_size+1) *(chain_size);
		tmp_store_size = (int) tmp_store_size/2 + 1;
		tmp_store_size += (factor_struc_sizes[current] - chain_size)*
					chain_size;
		if (( tmp_store = (double *) malloc
			 ((tmp_store_size*double_size))) == NULL)
			exit_err( "allocate: in move_into_factor", malloc_err);
		
		stats[L_cols] += chain_size;
		for (col=0, this_struc= factor_struc[current],
			factor_index_list[current] = *done_factor_cols,
			this_nonz= index_list[current],
			this=0; col < chain_size; col++) {
			if ( this_struc[this] == chain[col]) {
			factor_nonz[(*done_factor_cols)] = tmp_store ;
			copy_to(factor_nonz[*done_factor_cols], 
					stack_nonz[this_nonz],
					stack_nonz_sizes[this_nonz]);
			tmp_store += stack_nonz_sizes[this_nonz];
			tmp_store_size -= stack_nonz_sizes[this_nonz];
			factor_nonz_sizes[*done_factor_cols] = 
					stack_nonz_sizes[this_nonz];	
			stats[L_nz] +=stack_nonz_sizes[this_nonz];
/*
			stack_nonz[this_nonz] = NULL;
*/
			stack_nonz_sizes[this_nonz]  =0;
			(*done_factor_cols)++ ;
			this++; 
			this_nonz++ ;
				
			}
			else {
				exit_err("structure_chain_mismatch",int_err3);
				}
		}
		factor_index_list[current+1] = *done_factor_cols;
		if ( tmp_store_size <= 0) {
			exit_err(" error in tmp_store - move_into_factor",
					int_err3);
		}
}/*end move_into_factor*/
set_up_b_in_stack( current, parent, index_list) 
int		current,	parent, *index_list;
{

		int	col,	in_parent, in_child, *ptr_to_parent;

		if ( parent != -1)
			in_parent = index_list[parent];
		else in_parent = -1;


		index_list[current] = stack_ptr;
		stack_ptr+= factor_struc_sizes[current];
		if (in_parent == -1) { 
					set_to_double(0.0,
					(stack_b+ index_list[current]),
					factor_struc_sizes[current]);
					return (0);
		}
			
		for (col=0, in_child = index_list[current],
			ptr_to_parent = ptr_to_parent_factorstruc[current]; 
				col < factor_struc_sizes[current]; col++) {
			if ( ptr_to_parent[col] != -1)
			stack_b[in_child+col] = stack_b[in_parent +
						ptr_to_parent[col]];
			else stack_b[in_child+col] = 0.0;
		}
			
}/*end set_up_in_stack*/

move_into_solution (
	      	current,
		chain,
		chain_size,		
		index_list,
		done_solution_elmts)

int	
	      	current,
		*chain,
		chain_size,		
		*index_list,
		*done_solution_elmts;
{
		int	col,	this,	this_nonz,	*this_struc;
		extern	double stats[];


		for (col=0, this_struc= factor_struc[current],
			this_nonz= index_list[current],
			this=0; col < chain_size; col++) {
			if ( this_struc[this] == chain[col]) {
			factor_b[*done_solution_elmts] = stack_b[this_nonz];
			stack_b[this_nonz] = 0.0;
			(*done_solution_elmts)++ ;
			this++; 
			this_nonz++ ;
				
			}
			else {
				exit_err("structure_chain_mismatch",int_err3);
				}
		}
}/*end move_into_factor*/
