      INTEGER FUNCTION INDXG2L( INDXGLOB, NB, IPROC, ISRCPROC, NPROCS )
*
*  -- ScaLAPACK tools routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      INTEGER            INDXGLOB, IPROC, ISRCPROC, NB, NPROCS
*     ..
*
*  Purpose
*  =======
*
*  INDXG2L computes the local index of a distributed matrix entry
*  pointed to by the global index INDXGLOB.
*
*  Arguments
*  =========
*
*  INDXGLOB  (global input) INTEGER
*            The global index of the distributed matrix entry.
*
*  NB        (global input) INTEGER
*            Block size, size of the blocks the distributed matrix is
*            split into.
*
*  IPROC     (local dummy) INTEGER
*            Dummy argument in this case in order to unify the calling
*            sequence of the tool-routines.
*
*  ISRCPROC  (local dummy) INTEGER
*            Dummy argument in this case in order to unify the calling
*            sequence of the tool-routines.
*
*  NPROCS    (global input) INTEGER
*            The total number processes over which the distributed
*            matrix is distributed.
*
*  =====================================================================
*
*     .. Intrinsic Functions ..
      INTRINSIC          MOD
*     ..
*     .. Executable Statements ..
*
      INDXG2L = NB*((INDXGLOB-1)/(NB*NPROCS))+MOD(INDXGLOB-1,NB)+1
*
      RETURN
*
*     End of INDXG2L
*
      END
