      SUBROUTINE CHK1MAT( MA, MAPOS0, NA, NAPOS0, IA, JA, DESCA,
     $                    DESCAPOS0, INFO )
*
*  -- ScaLAPACK tools routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      INTEGER            DESCAPOS0, IA, INFO, JA, MA, MAPOS0, NA, NAPOS0
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
*     ..
*
*  Purpose
*  =======
*
*  CHK1MAT checks that the values associated with one distributed matrix
*  make sense from a local viewpoint
*
*  Arguments
*  =========
*
*  MA      (global input) INTEGER
*          The number or matrix rows of A being operated on.
*
*  MAPOS0  (global input) INTEGER
*          Where in the calling routine's parameter list MA appears.
*
*  NA      (global input) INTEGER
*          The number of matrix columns of A being operated on.
*
*  NAPOS0  (global input) INTEGER
*          Where in the calling routine's parameter list NA appears.
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  DESCAPOS0 (global input) INTEGER
*          Where in the calling routine's parameter list DESCA
*          appears.  Note that we assume IA and JA are respectively 2
*          and 1 entries behind DESCA.
*
*  INFO    (local input/local output) INTEGER
*          = 0:  successful exit
*          < 0:  If the i-th argument is an array and the j-entry had
*                an illegal value, then INFO = -(i*100+j), if the i-th
*                argument is a scalar and had an illegal value, then
*                INFO = -i.
*
*  =====================================================================
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            DESCMULT, BIGNUM
      PARAMETER          ( DESCMULT = 100, BIGNUM = DESCMULT*DESCMULT )
*     ..
*     .. Local Scalars ..
      INTEGER            DESCAPOS, IAPOS, JAPOS, MAPOS, NAPOS, MYCOL,
     $                   MYROW, NPCOL, NPROW
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO
*     ..
*     .. External Functions ..
      INTEGER            NUMROC
      EXTERNAL           NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN, MAX
*     ..
*     .. Executable Statements ..
*
*     Want to find errors with MIN( ), so if no error, set it to a big
*     number.  If there already is an error, multiply by the the des-
*     criptor multiplier
*
      IF( INFO.GE.0 ) THEN
         INFO = BIGNUM
      ELSE IF( INFO.LT.-DESCMULT ) THEN
         INFO = -INFO
      ELSE
         INFO = -INFO * DESCMULT
      END IF
*
*     Figure where in parameter list each parameter was, factoring in
*     descriptor multiplier
*
      MAPOS = MAPOS0 * DESCMULT
      NAPOS = NAPOS0 * DESCMULT
      IAPOS = (DESCAPOS0-2) * DESCMULT
      JAPOS = (DESCAPOS0-1) * DESCMULT
      DESCAPOS = DESCAPOS0 * DESCMULT
*
*     Get grid parameters
*
      CALL BLACS_GRIDINFO( DESCA( 7 ), NPROW, NPCOL, MYROW, MYCOL )
*
*     Check that matrix values make sense from local viewpoint
*
      IF( MA.LT.0 ) THEN
         INFO = MIN( INFO, MAPOS )
      ELSE IF( NA.LT.0 ) THEN
         INFO = MIN( INFO, NAPOS )
      ELSE IF( IA.LT.1 ) THEN
         INFO = MIN( INFO, IAPOS )
      ELSE IF( JA.LT.1 ) THEN
         INFO = MIN( INFO, JAPOS )
      ELSE IF( DESCA( 3 ).LT.1 ) THEN
         INFO = MIN( INFO, DESCAPOS+3 )
      ELSE IF( DESCA( 4 ).LT.1 ) THEN
         INFO = MIN( INFO, DESCAPOS+4 )
      ELSE IF( DESCA( 5 ).LT.0 .OR. DESCA( 5 ).GE.NPROW ) THEN
         INFO = MIN( INFO, DESCAPOS+5 )
      ELSE IF( DESCA( 6 ).LT.0 .OR. DESCA( 6 ).GE.NPCOL ) THEN
         INFO = MIN( INFO, DESCAPOS+6 )
      ELSE IF( MAX( NUMROC( DESCA( 1 ), DESCA( 3 ), MYROW, DESCA( 5 ),
     $                      NPROW ), 1 ) .GT. DESCA( 8 ) ) THEN
         INFO = MIN( INFO, DESCAPOS+8 )
      END IF
*
      IF( MA.EQ.0 .OR. NA.EQ.0 ) THEN
*
*        NULL matrix, relax some checks
*
         IF( DESCA(1).LT.0 )
     $      INFO = MIN( INFO, DESCAPOS+1 )
         IF( DESCA(2).LT.0 )
     $      INFO = MIN( INFO, DESCAPOS+2 )
*
      ELSE
*
*        more rigorous checks for non-degenerate matrices
*
         IF( DESCA( 1 ).LT.1 ) THEN
            INFO = MIN( INFO, DESCAPOS+1 )
         ELSE IF( DESCA( 2 ).LT.1 ) THEN
            INFO = MIN( INFO, DESCAPOS+2 )
         ELSE
            IF( IA.GT.DESCA( 1 ) ) THEN
               INFO = MIN( INFO, IAPOS )
            ELSE IF( JA.GT.DESCA( 2 ) ) THEN
               INFO = MIN( INFO, JAPOS )
            ELSE
               IF( IA+MA-1.GT.DESCA( 1 ) )
     $            INFO = MIN( INFO, MAPOS )
               IF( JA+NA-1.GT.DESCA( 2 ) )
     $            INFO = MIN( INFO, NAPOS )
            END IF
         END IF
*
      END IF
*
*     Prepare output: set info = 0 if no error, and divide by
*     DESCMULT if error is not in a descriptor entry
*
      IF( INFO.EQ.BIGNUM ) THEN
         INFO = 0
      ELSE IF( MOD( INFO, DESCMULT ).EQ.0 ) THEN
         INFO = -INFO / DESCMULT
      ELSE
         INFO = -INFO
      END IF
*
      RETURN
*
*     End CHK1MAT
*
      END
