      SUBROUTINE PDSYTRD( UPLO, N, A, IA, JA, DESCA, D, E, TAU, WORK,
     $                    LWORK, INFO )
*
*  -- ScaLAPACK routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      CHARACTER           UPLO
      INTEGER             IA, INFO, JA, LWORK, N
*     ..
*     .. Array Arguments ..
      INTEGER             DESCA( * )
      DOUBLE PRECISION    A( * ), D( * ), E( * ), TAU( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDSYTRD reduces a real symmetric matrix sub( A ) to symmetric
*  tridiagonal form T by an orthogonal similarity transformation:
*  Q' * sub( A ) * Q = T, where sub( A ) = A(IA:IA+N-1,JA:JA+N-1).
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  UPLO    (global input) CHARACTER
*          Specifies whether the upper or lower triangular part of the
*          symmetric matrix sub( A ) is stored:
*          = 'U':  Upper triangular
*          = 'L':  Lower triangular
*
*  N       (global input) INTEGER
*          The number of rows and columns to be operated on, i.e. the
*          order of the distributed submatrix sub( A ). N >= 0.
*
*  A       (local input/local output) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (LLD_A,LOCq(JA+N-1)).
*          On entry, this array contains the local pieces of the
*          symmetric distributed matrix sub( A ).  If UPLO = 'U', the
*          leading N-by-N upper triangular part of sub( A ) contains
*          the upper triangular part of the matrix, and its strictly
*          lower triangular part is not referenced. If UPLO = 'L', the
*          leading N-by-N lower triangular part of sub( A ) contains the
*          lower triangular part of the matrix, and its strictly upper
*          triangular part is not referenced. On exit, if UPLO = 'U',
*          the diagonal and first superdiagonal of sub( A ) are over-
*          written by the corresponding elements of the tridiagonal
*          matrix T, and the elements above the first superdiagonal,
*          with the array TAU, represent the orthogonal matrix Q as a
*          product of elementary reflectors; if UPLO = 'L', the diagonal
*          and first subdiagonal of sub( A ) are overwritten by the
*          corresponding elements of the tridiagonal matrix T, and the
*          elements below the first subdiagonal, with the array TAU,
*          represent the orthogonal matrix Q as a product of elementary
*          reflectors. See Further Details.
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  D       (local output) DOUBLE PRECISION array, dimension LOCq(JA+N-1)
*          The diagonal elements of the tridiagonal matrix T:
*          D(i) = A(i,i). D is tied to the distributed matrix A.
*
*  E       (local output) DOUBLE PRECISION array, dimension LOCq(JA+N-2)
*          The off-diagonal elements of the tridiagonal matrix T:
*          E(i) = A(i,i+1) if UPLO = 'U', E(i) = A(i+1,i) if UPLO = 'L'.
*          E is tied to the distributed matrix A.
*
*  TAU     (local output) DOUBLE PRECISION, array, dimension LOCq(JA+N-1).
*          This array contains the scalar factors TAU of the elementary
*          reflectors. TAU is tied to the distributed matrix A.
*
*  WORK    (local workspace) DOUBLE PRECISION array, dimension (LWORK)
*          On exit, WORK( 1 ) returns the minimal LWORK.
*
*  LWORK   (local input) INTEGER
*          The dimension of the array WORK.
*          LWORK >= MAX( NB * ( NP +1 ), 3 * NB )
*
*          where NB = MB_A = NB_A,
*          NP = NUMROC( N, NB, MYROW, IAROW, NPROW ),
*          IAROW = INDXG2P( IA, NB, MYROW, RSRC_A, NPROW ).
*
*          INDXG2P and NUMROC are ScaLAPACK tool functions;
*          MYROW, MYCOL, NPROW and NPCOL can be determined by calling
*          the subroutine BLACS_GRIDINFO.
*
*  INFO    (global output) INTEGER
*          = 0:  successful exit
*          < 0:  If the i-th argument is an array and the j-entry had
*                an illegal value, then INFO = -(i*100+j), if the i-th
*                argument is a scalar and had an illegal value, then
*                INFO = -i.
*
*  =====================================================================
*
*  =====================================================================
*
*  Alignment requirements
*  ======================
*
*  The distributed submatrix sub( A ) must verify some alignment proper-
*  ties, namely the following expression should be true:
*  ( MB_A.EQ.NB_A .AND. IROFFA.EQ.ICOFFA .AND. IROFFA.EQ.0 ) with
*  IROFFA = MOD( IA-1, MB_A ) and ICOFFA = MOD( JA-1, NB_A ).
*
*  Further Details
*  ===============
*
*  If UPLO = 'U', the matrix Q is represented as a product of elementary
*  reflectors
*
*     Q = H(n-1) . . . H(2) H(1).
*
*  Each H(i) has the form
*
*     H(i) = I - tau * v * v'
*
*  where tau is a real scalar, and v is a real vector with
*  v(i+1:n) = 0 and v(i) = 1; v(1:i-1) is stored on exit in
*  A(ia:ia+i-2,ja+i-1), and tau in TAU(ja+i-1).
*
*  If UPLO = 'L', the matrix Q is represented as a product of elementary
*  reflectors
*
*     Q = H(1) H(2) . . . H(n-1).
*
*  Each H(i) has the form
*
*     H(i) = I - tau * v * v'
*
*  where tau is a real scalar, and v is a real vector with
*  v(1:i) = 0 and v(i+1) = 1; v(i+2:n) is stored on exit in
*  A(ia+i+1:ia+n-1,ja+i-1), and tau in TAU(ja+i-1).
*
*  The contents of sub( A ) on exit are illustrated by the following
*  examples with n = 5:
*
*  if UPLO = 'U':                       if UPLO = 'L':
*
*    (  d   e   v2  v3  v4 )              (  d                  )
*    (      d   e   v3  v4 )              (  e   d              )
*    (          d   e   v4 )              (  v1  e   d          )
*    (              d   e  )              (  v1  v2  e   d      )
*    (                  d  )              (  v1  v2  v3  e   d  )
*
*  where d and e denote diagonal and off-diagonal elements of T, and vi
*  denotes an element of the vector defining H(i).
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE
      PARAMETER          ( ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            UPPER
      INTEGER            I, IACOL, IAROW, ICOFFA, ICTXT, IINFO, IPW,
     $                   IROFFA, J, JB, JX, K, KK, LWMIN, MYCOL, MYROW,
     $                   NB, NP, NPCOL, NPROW, NQ
*     ..
*     .. Local Arrays ..
      INTEGER            DESCW( 8 ), IDUM1( 1 ), IDUM2( 1 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, CHK1MAT, DESCSET, PCHK1MAT,
     $                   PDLATRD, PDSYR2K, PDSYTD2, PXERBLA
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            INDXG2L, INDXG2P, NUMROC
      EXTERNAL           LSAME, INDXG2L, INDXG2P, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, ICHAR, MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      ICTXT = DESCA( 7 )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Test the input parameters
*
      INFO = 0
      IF( NPROW.EQ.-1 ) THEN
         INFO = -607
      ELSE
         CALL CHK1MAT( N, 2, N, 2, IA, JA, DESCA, 6, INFO )
         UPPER = LSAME( UPLO, 'U' )
         IF( INFO.EQ.0 ) THEN
            NB = DESCA( 4 )
            IROFFA = MOD( IA-1, DESCA( 3 ) )
            ICOFFA = MOD( JA-1, DESCA( 4 ) )
            IAROW = INDXG2P( IA, NB, MYROW, DESCA( 5 ), NPROW )
            IACOL = INDXG2P( JA, NB, MYCOL, DESCA( 6 ), NPCOL )
            NP = NUMROC( N, NB, MYROW, IAROW, NPROW )
            NQ = MAX( 1, NUMROC( N+JA-1, NB, MYCOL, DESCA( 6 ),
     $                NPCOL ) )
            LWMIN = MAX( (NP+1)*NB, 3*NB )
*
            WORK( 1 ) = DBLE( LWMIN )
            IF( .NOT.UPPER .AND. .NOT.LSAME( UPLO, 'L' ) ) THEN
               INFO = -1
            ELSE IF( IROFFA.NE.ICOFFA .OR. ICOFFA.NE.0 ) THEN
               INFO = -5
            ELSE IF( DESCA( 3 ).NE.DESCA( 4 ) ) THEN
               INFO = -604
            ELSE IF( LWORK.LT.LWMIN ) THEN
               INFO = -11
            END IF
         END IF
         IF( UPPER ) THEN
            IDUM1( 1 ) = ICHAR( 'U' )
         ELSE
            IDUM1( 1 ) = ICHAR( 'L' )
         END IF
         IDUM2( 1 ) = 1
         CALL PCHK1MAT( N, 2, N, 2, IA, JA, DESCA, 6, 1, IDUM1, IDUM2,
     $                  INFO )
      END IF
*
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICTXT, 'PDSYTRD', -INFO )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( N.EQ.0 )
     $   RETURN
*
      IPW = NP * NB + 1
*
      IF( UPPER ) THEN
*
*        Reduce the upper triangle of sub( A ).
*
         KK = MOD( JA+N-1, NB )
         IF( KK.EQ.0 )
     $      KK = NB
         CALL DESCSET( DESCW, N, NB, NB, NB, IAROW, INDXG2P( JA+N-KK,
     $                 NB, MYCOL, DESCA( 6 ), NPCOL ), ICTXT,
     $                 MAX( 1, NP ) )
*
         DO 10 K = N-KK+1, NB+1, -NB
            JB = MIN( N-K+1, NB )
            I = IA + K - 1
            J = JA + K - 1
*
*           Reduce columns I:I+NB-1 to tridiagonal form and form
*           the matrix W which is needed to update the unreduced part of
*           the matrix
*
            CALL PDLATRD( UPLO, K+JB-1, JB, A, IA, JA, DESCA, D, E, TAU,
     $                    WORK, 1, 1, DESCW, WORK( IPW ) )
*
*           Update the unreduced submatrix A(IA:I-1,JA:J-1), using an
*           update of the form:
*           A(IA:I-1,JA:J-1) := A(IA:I-1,JA:J-1) - V*W' - W*V'
*
            CALL PDSYR2K( UPLO, 'No transpose', K-1, JB, -ONE, A, IA, J,
     $                    DESCA, WORK, 1, 1, DESCW, ONE, A, IA, JA,
     $                    DESCA )
*
*           Copy last superdiagonal element back into sub( A )
*
            JX = MIN( INDXG2L( J, NB, 0, IACOL, NPCOL ), NQ )
            CALL PDELSET( A, I-1, J, DESCA, E( JX ) )
*
            DESCW( 6 ) = MOD( DESCW( 6 ) + NPCOL - 1, NPCOL )
*
   10    CONTINUE
*
*        Use unblocked code to reduce the last or only block
*
         CALL PDSYTD2( UPLO, MIN( N, NB ), A, IA, JA, DESCA, D, E,
     $                 TAU, WORK, LWORK, IINFO )
*
      ELSE
*
*        Reduce the lower triangle of sub( A )
*
         KK = MOD( JA+N-1, NB )
         IF( KK.EQ.0 )
     $      KK = NB
         CALL DESCSET( DESCW, N, NB, NB, NB, IAROW, IACOL, ICTXT,
     $                 MAX( 1, NP ) )
*
         DO 20 K = 1, N-NB, NB
            I = IA + K - 1
            J = JA + K - 1
*
*           Reduce columns I:I+NB-1 to tridiagonal form and form
*           the matrix W which is needed to update the unreduced part
*           of the matrix
*
            CALL PDLATRD( UPLO, N-K+1, NB, A, I, J, DESCA, D, E, TAU,
     $                    WORK, K, 1, DESCW, WORK( IPW ) )
*
*           Update the unreduced submatrix A(I+NB:IA+N-1,I+NB:IA+N-1),
*           using an update of the form: A(I+NB:IA+N-1,I+NB:IA+N-1) :=
*           A(I+NB:IA+N-1,I+NB:IA+N-1) - V*W' - W*V'
*
            CALL PDSYR2K( UPLO, 'No transpose', N-K-NB+1, NB, -ONE, A,
     $                    I+NB, J, DESCA, WORK, K+NB, 1, DESCW, ONE, A,
     $                    I+NB, J+NB, DESCA )
*
*           Copy last subdiagonal element back into sub( A )
*
            JX = MIN( INDXG2L( J+NB-1, NB, 0, IACOL, NPCOL ), NQ )
            CALL PDELSET( A, I+NB, J+NB-1, DESCA, E( JX ) )
*
            DESCW( 6 ) = MOD( DESCW( 6 ) + 1, NPCOL )
*
   20    CONTINUE
*
*        Use unblocked code to reduce the last or only block
*
         CALL PDSYTD2( UPLO, KK, A, IA+K-1, JA+K-1, DESCA, D, E,
     $                 TAU, WORK, LWORK, IINFO )
      END IF
*
      WORK( 1 ) = DBLE( LWMIN )
*
      RETURN
*
*     End of PDSYTRD
*
      END
