      SUBROUTINE PDORML2( SIDE, TRANS, M, N, K, A, IA, JA, DESCA, TAU,
     $                    C, IC, JC, DESCC, WORK, LWORK, INFO )
*
*  -- ScaLAPACK routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      CHARACTER          SIDE, TRANS
      INTEGER            IA, IC, INFO, JA, JC, K, LWORK, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCC( * )
      DOUBLE PRECISION   A( * ), C( * ), TAU( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDORML2 overwrites the general real M-by-N distributed matrix
*  sub( C ) = C(IC:IC+M-1,JC:JC+N-1) with
*
*                       SIDE = 'L'          SIDE = 'R'
*  TRANS = 'N':      Q * sub( C )         sub( C ) * Q
*  TRANS = 'T':      Q**T * sub( C )      sub( C ) * Q**T
*
*  where Q is a real orthogonal distributed matrix defined as the
*  product of K elementary reflectors
*
*        Q = H(k) . . . H(2) H(1)
*
*  as returned by PDGELQF. Q is of order M if SIDE = 'L' and of order N
*  if SIDE = 'R'.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  This routine requires square block decomposition ( MB_A = NB_A ).
*
*  Arguments
*  =========
*
*  SIDE    (global input) CHARACTER
*          = 'L': apply Q or Q**T from the Left;
*          = 'R': apply Q or Q**T from the Right.
*
*  TRANS   (global input) CHARACTER
*          = 'N':  No transpose, apply Q;
*          = 'T':  Transpose, apply Q**T.
*
*  M       (global input) INTEGER
*          The number of rows to be operated on i.e the number of rows
*          of the distributed submatrix sub( C ). M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns to be operated on i.e the number of
*          columns of the distributed submatrix sub( C ). N >= 0.
*
*  K       (global input) INTEGER
*          The number of elementary reflectors whose product defines the
*          matrix Q.  If SIDE = 'L', M >= K >= 0, if SIDE = 'R',
*          N >= K >= 0.
*
*  A       (local input) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension (LLD_A,LOCq(JA+M-1)) if SIDE='L',
*          and (LLD_A,LOCq(JA+N-1)) if SIDE='R', where
*          LLD_A >= max(1,LOCp(IA+K-1)); On entry, the i-th row must
*          contain the vector which defines the elementary reflector
*          H(i), IA <= i <= IA+K-1, as returned by PDGELQF in the
*          K rows of its distributed matrix argument A(IA:IA+K-1,JA:*).
*          A(IA:IA+K-1,JA:*) is modified by the routine but restored on
*          exit.
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  TAU     (local input) DOUBLE PRECISION, array, dimension LOCq(IA+K-1).
*          This array contains the scalar factors TAU(i) of the
*          elementary reflectors H(i) as returned by PDGELQF.
*          TAU is tied to the distributed matrix A.
*
*  C       (local input/local output) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (LLD_C,LOCq(JC+N-1)).
*          On entry, the local pieces of the distributed matrix sub( C ).
*          On exit, sub( C ) is overwritten by Q*sub( C ) or Q'*sub( C )
*          or sub( C )*Q' or sub( C )*Q.
*
*  IC      (global input) INTEGER
*          C's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JC      (global input) INTEGER
*          C's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCC   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix C.
*
*  WORK    (local workspace) DOUBLE PRECISION array, dimension (LWORK)
*          On exit, WORK(1) returns the minimal LWORK.
*
*  LWORK   (local input) INTEGER
*          The dimension of the array WORK.
*          If SIDE = 'L', LWORK >= MpC0 + MAX( MAX( 1, NqC0 ), NUMROC(
*                  NUMROC( M+IROFFC,MB_A,0,0,NPROW ),MB_A,0,0,LCMP ) );
*          if SIDE = 'R', LWORK >= NqC0 + MAX( 1, MpC0 );
*
*          where LCMP = LCM / NPROW with LCM = ICLM( NPROW, NPCOL ),
*
*          IROFFC = MOD( IC-1, MB_C ), ICOFFC = MOD( JC-1, NB_C ),
*          ICROW = INDXG2P( IC, MB_C, MYROW, RSRC_C, NPROW ),
*          ICCOL = INDXG2P( JC, NB_C, MYCOL, CSRC_C, NPCOL ),
*          MpC0 = NUMROC( M+IROFFC, MB_C, MYROW, ICROW, NPROW ),
*          NqC0 = NUMROC( N+ICOFFC, NB_C, MYCOL, ICCOL, NPCOL ),
*
*          ILCM, INDXG2P and NUMROC are ScaLAPACK tool functions;
*          MYROW, MYCOL, NPROW and NPCOL can be determined by calling
*          the subroutine BLACS_GRIDINFO.
*
*  INFO    (local output) INTEGER
*          = 0:  successful exit
*          < 0:  If the i-th argument is an array and the j-entry had
*                an illegal value, then INFO = -(i*100+j), if the i-th
*                argument is a scalar and had an illegal value, then
*                INFO = -i.
*
*  =====================================================================
*
*  =====================================================================
*
*  Alignment requirements
*  ======================
*
*  The distributed submatrices A(IA:*, JA:*) and C(IC:IC+M-1,JC:JC+N-1)
*  must verify some alignment properties, namely the following
*  expressions should be true:
*
*  If SIDE = 'L',
*    ( MB_A.EQ.NB_A .AND. MB_A.EQ.MB_C .AND. ICOFFA.EQ.IROFFC )
*  If SIDE = 'R',
*    ( NB_A.EQ.NB_C .AND. ICOFFA.EQ.ICOFFC .AND. IACOL.EQ.ICCOL )
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE
      PARAMETER          ( ONE = 1.0D+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            LEFT, NOTRAN
      CHARACTER          COLBTOP, ROWBTOP
      INTEGER            I, I1, I2, I3, IACOL, ICC, ICCOL, ICOFFA,
     $                   ICOFFC, ICROW, ICTXT, IROFFC, JCC, LCM, LCMP,
     $                   LWMIN, MI, MPC0, MYCOL, MYROW, NI, NPCOL,
     $                   NPROW, NQ, NQC0
      DOUBLE PRECISION   AII
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_ABORT, BLACS_GRIDINFO, CHK1MAT, PDELSET,
     $                   PDELSET2, PDLARF, PTOPGET, PTOPSET, PXERBLA
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ILCM, INDXG2L, INDXG2P, NUMROC
      EXTERNAL           ILCM, INDXG2L, INDXG2P, LSAME, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, MAX, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      ICTXT = DESCA( 7 )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Test the input parameters
*
      INFO = 0
      IF( NPROW.EQ.-1 ) THEN
         INFO = -907
      ELSE
         LEFT = LSAME( SIDE, 'L' )
         NOTRAN = LSAME( TRANS, 'N' )
*
*        NQ is the order of Q
*
         IF( LEFT ) THEN
            NQ = M
            CALL CHK1MAT( K, 5, M, 3, IA, JA, DESCA, 9, INFO )
         ELSE
            NQ = N
            CALL CHK1MAT( K, 5, N, 4, IA, JA, DESCA, 9, INFO )
         END IF
         CALL CHK1MAT( M, 3, N, 4, IC, JC, DESCC, 14, INFO )
         IF( INFO.EQ.0 ) THEN
            ICOFFA = MOD( JA-1, DESCA( 4 ) )
            IROFFC = MOD( IC-1, DESCC( 3 ) )
            ICOFFC = MOD( JC-1, DESCC( 4 ) )
            IACOL = INDXG2P( JA, DESCA( 4 ), MYCOL, DESCA( 6 ), NPCOL )
            ICROW = INDXG2P( IC, DESCC( 3 ), MYROW, DESCC( 5 ), NPROW )
            ICCOL = INDXG2P( JC, DESCC( 4 ), MYCOL, DESCC( 6 ), NPCOL )
            MPC0 = NUMROC( M+IROFFC, DESCC( 3 ), MYROW, ICROW, NPROW )
            NQC0 = NUMROC( N+ICOFFC, DESCC( 4 ), MYCOL, ICCOL, NPCOL )
*
            IF( LEFT ) THEN
               LCM = ILCM( NPROW, NPCOL )
               LCMP = LCM / NPROW
               LWMIN = MPC0 + MAX( MAX( 1, NQC0 ), NUMROC( NUMROC(
     $                 M+IROFFC, DESCA( 3 ), 0, 0, NPROW ), DESCA( 3 ),
     $                 0, 0, LCMP ) )
            ELSE
               NQC0 = NUMROC( N+ICOFFC, DESCC( 4 ), MYCOL, ICCOL,
     $                        NPCOL )
               MPC0 = NUMROC( M+IROFFC, DESCC( 3 ), MYROW, ICROW,
     $                        NPROW )
               LWMIN = NQC0 + MAX( 1, MPC0 )
            END IF
*
            WORK( 1 ) = DBLE( LWMIN )
            IF( .NOT.LEFT .AND. .NOT.LSAME( SIDE, 'R' ) ) THEN
               INFO = -1
            ELSE IF( .NOT.NOTRAN .AND. .NOT.LSAME( TRANS, 'T' ) ) THEN
               INFO = -2
            ELSE IF( K.LT.0 .OR. K.GT.NQ ) THEN
               INFO = -5
            ELSE IF( DESCA( 3 ).NE.DESCA( 4 ) ) THEN
               INFO = -904
            ELSE IF( LEFT .AND. ICOFFA.NE.IROFFC ) THEN
               INFO = -12
            ELSE IF( .NOT.LEFT .AND. ICOFFA.NE.ICOFFC ) THEN
               INFO = -13
            ELSE IF( .NOT.LEFT .AND. IACOL.NE.ICCOL ) THEN
               INFO = -13
            ELSE IF( LEFT .AND. DESCA( 3 ).NE.DESCC( 3 ) ) THEN
               INFO = -1403
            ELSE IF( .NOT.LEFT .AND. DESCA( 4 ).NE.DESCC( 4 ) ) THEN
               INFO = -1404
            ELSE IF( ICTXT.NE.DESCC( 7 ) ) THEN
               INFO = -1407
            ELSE IF( LWORK.LT.LWMIN ) THEN
               INFO = -16
            END IF
         END IF
      END IF
*
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICTXT, 'PDORML2', -INFO )
         CALL BLACS_ABORT( ICTXT, 1 )
         RETURN
      END IF
*
*     Quick return if possible
*
      IF( M.EQ.0 .OR. N.EQ.0 .OR. K.EQ.0 )
     $   RETURN
*
      CALL PTOPGET( 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPGET( 'Broadcast', 'Columnwise', COLBTOP )
*
      IF( ( LEFT .AND. NOTRAN .OR. .NOT.LEFT .AND. .NOT.NOTRAN ) ) THEN
         I1 = IA
         I2 = IA + K - 1
         I3 = 1
      ELSE
         I1 = IA + K -1
         I2 = IA
         I3 = -1
      END IF
*
      IF( LEFT ) THEN
         NI  = N
         JCC = JC
      ELSE
         MI  = M
         ICC = IC
         CALL PTOPSET( 'Broadcast', 'Rowwise', ' ' )
         IF( NOTRAN ) THEN
            CALL PTOPSET( 'Broadcast', 'Columnwise', 'D-ring' )
         ELSE
            CALL PTOPSET( 'Broadcast', 'Columnwise', 'I-ring' )
         END IF
      END IF
*
      DO 10 I = I1, I2, I3
         IF( LEFT ) THEN
*
*           H(i) or H(i)' is applied to C(i:ic+m-1,jc:jc+n-1)
*
            MI  = M - I + IA
            ICC = IC + I - IA
         ELSE
*
*           H(i) or H(i)' is applied to C(ic:ic+m-1,jc+i-ia:jc+n-1)
*
            NI  = N - I + IA
            JCC = JC + I - IA
         END IF
*
*        Apply H(i) or H(i)'
*
         CALL PDELSET2( AII, A, I, JA+I-IA, DESCA, ONE )
         CALL PDLARF( SIDE, MI, NI, A, I, JA+I-IA, DESCA, DESCA( 1 ),
     $                TAU, C, ICC, JCC, DESCC, WORK )
         CALL PDELSET( A, I, JA+I-IA, DESCA, AII )
*
   10 CONTINUE
*
      CALL PTOPGET( 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPGET( 'Broadcast', 'Columnwise', COLBTOP )
*
      WORK( 1 ) = DBLE( LWMIN )
*
      RETURN
*
*     End of PDORML2
*
      END
