      SUBROUTINE PDLATRD( UPLO, N, NB, A, IA, JA, DESCA, D, E, TAU, W,
     $                    IW, JW, DESCW, WORK )
*
*  -- ScaLAPACK auxilliary routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      CHARACTER           UPLO
      INTEGER             IA, IW, JA, JW, N, NB
*     ..
*     .. Array Arguments ..
      INTEGER             DESCA( * ), DESCW( * )
      DOUBLE PRECISION    A( * ), D( * ), E( * ), TAU( * ), W( * ),
     $                    WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDLATRD reduces NB rows and columns of a real symmetric distributed
*  matrix sub( A ) = A(IA:IA+N-1,JA:JA+N-1) to symmetric tridiagonal
*  form by an orthogonal similarity transformation Q' * sub( A ) * Q,
*  and returns the matrices V and W which are needed to apply the
*  transformation to the unreduced part of sub( A ).
*
*  If UPLO = 'U', PDLATRD reduces the last NB rows and columns of a
*  matrix, of which the upper triangle is supplied;
*  if UPLO = 'L', PDLATRD reduces the first NB rows and columns of a
*  matrix, of which the lower triangle is supplied.
*
*  This is an auxiliary routine called by PDSYTRD.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  UPLO    (global input) CHARACTER
*          Specifies whether the upper or lower triangular part of the
*          symmetric matrix sub( A ) is stored:
*          = 'U': Upper triangular
*          = 'L': Lower triangular
*
*  N       (global input) INTEGER
*          The number of rows and columns to be operated on, i.e. the
*          order of the distributed submatrix sub( A ). N >= 0.
*
*  NB      (global input) INTEGER
*          The number of rows and columns to be reduced.
*
*  A       (local input/local output) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (LLD_A,LOCq(JA+N-1)).
*          On entry, this array contains the local pieces of the
*          symmetric distributed matrix sub( A ).  If UPLO = 'U', the
*          leading N-by-N upper triangular part of sub( A ) contains
*          the upper triangular part of the matrix, and its strictly
*          lower triangular part is not referenced. If UPLO = 'L', the
*          leading N-by-N lower triangular part of sub( A ) contains the
*          lower triangular part of the matrix, and its strictly upper
*          triangular part is not referenced.
*          On exit, if UPLO = 'U', the last NB columns have been reduced
*          to tridiagonal form, with the diagonal elements overwriting
*          the diagonal elements of sub( A ); the elements above the
*          diagonal with the array TAU, represent the orthogonal matrix
*          Q as a product of elementary reflectors. If UPLO = 'L', the
*          first NB columns have been reduced to tridiagonal form, with
*          the diagonal elements overwriting the diagonal elements of
*          sub( A ); the elements below the diagonal with the array TAU,
*          represent the orthogonal matrix Q as a product of elementary
*          reflectors; See Further Details.
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  D       (local output) DOUBLE PRECISION array, dimension LOCq(JA+N-1)
*          The diagonal elements of the tridiagonal matrix T:
*          D(i) = A(i,i). D is tied to the distributed matrix A.
*
*  E       (local output) DOUBLE PRECISION array, dimension LOCq(JA+N-2)
*          The off-diagonal elements of the tridiagonal matrix T:
*          E(i) = A(i,i+1) if UPLO = 'U', E(i) = A(i+1,i) if UPLO = 'L'.
*          E is tied to the distributed matrix A.
*
*  TAU     (local output) DOUBLE PRECISION, array, dimension LOCq(JA+N-1).
*          This array contains the scalar factors TAU of the elementary
*          reflectors. TAU is tied to the distributed matrix A.
*
*  W       (local output) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension (LLD_W,NB_W), This array contains
*          the local pieces of the N-by-NB_W matrix W required to
*          update the unreduced part of sub( A ).
*
*  IW      (global input) INTEGER
*          W's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JW      (global input) INTEGER
*          W's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCW   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix W.
*
*  WORK    (local workspace) DOUBLE PRECISION array, dimension (NB_A)
*
*  Further Details
*  ===============
*
*  If UPLO = 'U', the matrix Q is represented as a product of elementary
*  reflectors
*
*     Q = H(n) H(n-1) . . . H(n-nb+1).
*
*  Each H(i) has the form
*
*     H(i) = I - tau * v * v'
*
*  where tau is a real scalar, and v is a real vector with
*  v(i:n) = 0 and v(i-1) = 1; v(1:i-1) is stored on exit in
*  A(ia:ia+i-2,ja+i-1), and tau in TAU(ja+i-1).
*
*  If UPLO = 'L', the matrix Q is represented as a product of elementary
*  reflectors
*
*     Q = H(1) H(2) . . . H(nb).
*
*  Each H(i) has the form
*
*     H(i) = I - tau * v * v'
*
*  where tau is a real scalar, and v is a real vector with
*  v(1:i) = 0 and v(i+1) = 1; v(i+2:n) is stored on exit in
*  A(ia+i+1:ia+n-1,ja+i-1), and tau in TAU(ja+i-1).
*
*  The elements of the vectors v together form the N-by-NB matrix V
*  which is needed, with W, to apply the transformation to the unreduced
*  part of the matrix, using a symmetric rank-2k update of the form:
*  sub( A ) := sub( A ) - V*W' - W*V'.
*
*  The contents of A on exit are illustrated by the following examples
*  with n = 5 and nb = 2:
*
*  if UPLO = 'U':                       if UPLO = 'L':
*
*    (  a   a   a   v4  v5 )              (  d                  )
*    (      a   a   v4  v5 )              (  1   d              )
*    (          a   1   v5 )              (  v1  1   a          )
*    (              d   1  )              (  v1  v2  a   a      )
*    (                  d  )              (  v1  v2  a   a   a  )
*
*  where d denotes a diagonal element of the reduced matrix, a denotes
*  an element of the original matrix that is unchanged, and vi denotes
*  an element of the vector defining H(i).
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   HALF, ONE, ZERO
      PARAMETER          ( HALF = 0.5D+0, ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, IACOL, IAROW, ICTXT, II, J, JJ, JP, JWK, K,
     $                   KW, MYCOL, MYROW, NPCOL, NPROW, NQ
      DOUBLE PRECISION   ALPHA
*     ..
*     .. Local Arrays ..
      INTEGER            DESCWK( 8 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DESCSET, DGEBR2D, DGEBS2D,
     $                   INFOG2L, PDAXPY, PDDOT, PDELGET,
     $                   PDELSET, PDGEMV, PDLARFG, PDSCAL,
     $                   PDSYMV
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            NUMROC
      EXTERNAL           LSAME, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN
*     ..
*     .. Executable Statements ..
*
*     Quick return if possible
*
      IF( N.LE.0 )
     $   RETURN
*
      ICTXT = DESCA( 7 )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
      NQ = MAX( 1, NUMROC( JA+N-1, DESCA( 4 ), MYCOL, DESCA( 6 ),
     $          NPCOL ) )
*
      IF( LSAME( UPLO, 'U' ) ) THEN
*
         CALL INFOG2L( N+IA-NB, N+JA-NB, DESCA, NPROW, NPCOL, MYROW,
     $                 MYCOL, II, JJ, IAROW, IACOL )
         CALL DESCSET( DESCWK, 1, DESCW( 4 ), 1, DESCW( 4 ), IAROW,
     $                 IACOL, ICTXT, 1 )
*
*        Reduce last NB columns of upper triangle
*
         DO 10 J = N+JA-1, N+JA-NB, -1
            I = IA + J - JA
            K = J - JA + 1
            KW = MOD( K-1, DESCA( 3 ) ) + 1
*
*           Update A(IA:I,I)
*
            CALL PDGEMV( 'No transpose', K, N-K, -ONE, A, IA, J+1,
     $                   DESCA, W, IW+K-1, JW+KW, DESCW, DESCW( 1 ),
     $                   ONE, A, IA, J, DESCA, 1 )
            CALL PDGEMV( 'No transpose', K, N-K, -ONE, W, IW, JW+KW,
     $                   DESCW, A, I, J+1, DESCA, DESCA( 1 ), ONE, A,
     $                   IA, J, DESCA, 1 )
            IF( N-K.GT.0 )
     $         CALL PDELSET( A, I, J+1, DESCA, E( JP ) )
*
*           Generate elementary reflector H(i) to annihilate
*           A(IA:I-2,I)
*
            JP = MIN( JJ+KW-1, NQ )
            CALL PDLARFG( K-1, E( JP ), I-1, J, A, IA, J, DESCA, 1,
     $                    TAU )
            CALL PDELSET( A, I-1, J, DESCA, ONE )
*
*           Compute W(IW:IW+K-2,JW+KW-1)
*
            CALL PDSYMV( 'Upper', K-1, ONE, A, IA, JA, DESCA, A, IA, J,
     $                   DESCA, 1, ZERO, W, IW, JW+KW-1, DESCW, 1 )
*
            JWK = MOD( K-1, DESCWK( 4 ) ) + 2
            CALL PDGEMV( 'Transpose', K-1, N-K, ONE, W, IW, JW+KW,
     $                   DESCW, A, IA, J, DESCA, 1, ZERO, WORK, 1, JWK,
     $                   DESCWK, DESCWK( 1 ) )
            CALL PDGEMV( 'No transpose', K-1, N-K, -ONE, A, IA, J+1,
     $                   DESCA, WORK, 1, JWK, DESCWK, DESCWK( 1 ), ONE,
     $                   W, IW, JW+KW-1, DESCW, 1 )
            CALL PDGEMV( 'Transpose', K-1, N-K, ONE, A, IA, J+1, DESCA,
     $                   A, IA, J, DESCA, 1, ZERO, WORK, 1, JWK, DESCWK,
     $                   DESCWK( 1 ) )
            CALL PDGEMV( 'No transpose', K-1, N-K, -ONE, W, IW, JW+KW,
     $                   DESCW, WORK, 1, JWK, DESCWK, DESCWK( 1 ), ONE,
     $                   W, IW, JW+KW-1, DESCW, 1 )
            CALL PDSCAL( K-1, TAU( JP ), W, IW, JW+KW-1, DESCW, 1 )
*
            CALL PDDOT( K-1, ALPHA, W, IW, JW+KW-1, DESCW, 1, A, IA, J,
     $                  DESCA, 1 )
            ALPHA = -HALF*TAU( JP )*ALPHA
            CALL PDAXPY( K-1, ALPHA, A, IA, J, DESCA, 1, W, IW, JW+KW-1,
     $                   DESCW, 1 )
            CALL PDELGET( 'E', ' ', D( JP ), A, I, J, DESCA )
*
   10    CONTINUE
*
      ELSE
*
         CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, II,
     $                 JJ, IAROW, IACOL )
         CALL DESCSET( DESCWK, 1, DESCW( 4 ), 1, DESCW( 4 ), IAROW,
     $                 IACOL, ICTXT, 1 )
*
*        Reduce first NB columns of lower triangle
*
         DO 20 J = JA, JA+NB-1
            I = IA + J - JA
            K = J - JA + 1
*
*           Update A(J:JA+N-1,J)
*
            CALL PDGEMV( 'No transpose', N-K+1, K-1, -ONE, A, I, JA,
     $                   DESCA, W, IW+K-1, JW, DESCW, DESCW( 1 ), ONE,
     $                   A, I, J, DESCA, 1 )
            CALL PDGEMV( 'No transpose', N-K+1, K-1, -ONE, W, IW+K-1,
     $                   JW, DESCW, A, I, JA, DESCA, DESCA( 1 ), ONE, A,
     $                   I, J, DESCA, 1 )
            IF( K.GT.1 )
     $         CALL PDELSET( A, I, J-1, DESCA, E( JP ) )
*
*           Generate elementary reflector H(i) to annihilate
*           A(I+2:IA+N-1,I)
*
            JP = MIN( JJ+K-1, NQ )
            CALL PDLARFG( N-K, E( JP ), I+1, J, A, I+2, J, DESCA, 1,
     $                    TAU )
            CALL PDELSET( A, I+1, J, DESCA, ONE )
*
*           Compute W(IW+K:IW+N-1,JW+K-1)
*
            CALL PDSYMV( 'Lower', N-K, ONE, A, I+1, J+1, DESCA, A, I+1,
     $                   J, DESCA, 1, ZERO, W, IW+K, JW+K-1, DESCW, 1 )
*
            CALL PDGEMV( 'Transpose', N-K, K-1, ONE, W, IW+K, JW, DESCW,
     $                   A, I+1, J, DESCA, 1, ZERO, WORK, 1, 1, DESCWK,
     $                   DESCWK( 1 ) )
            CALL PDGEMV( 'No transpose', N-K, K-1, -ONE, A, I+1, JA,
     $                  DESCA, WORK, 1, 1, DESCWK, DESCWK( 1 ), ONE, W,
     $                  IW+K, JW+K-1, DESCW, 1 )
            CALL PDGEMV( 'Transpose', N-K, K-1, ONE, A, I+1, JA, DESCA,
     $                  A, I+1, J, DESCA, 1, ZERO, WORK, 1, 1, DESCWK,
     $                  DESCWK( 1 ) )
            CALL PDGEMV( 'No transpose', N-K, K-1, -ONE, W, IW+K, JW,
     $                  DESCW, WORK, 1, 1, DESCWK, DESCWK( 1 ), ONE, W,
     $                  IW+K, JW+K-1, DESCW, 1 )
            CALL PDSCAL( N-K, TAU( JP ), W, IW+K, JW+K-1, DESCW, 1 )
            CALL PDDOT( N-K, ALPHA, W, IW+K, JW+K-1, DESCW, 1, A, I+1,
     $                  J, DESCA, 1 )
            ALPHA = -HALF*TAU( JP )*ALPHA
            CALL PDAXPY( N-K, ALPHA, A, I+1, J, DESCA, 1, W, IW+K,
     $                   JW+K-1, DESCW, 1 )
            CALL PDELGET( 'E', ' ', D( JP ), A, I, J, DESCA )
*
   20    CONTINUE
*
      END IF
*
*     Broadcast columnwise the diagonal elements into D.
*
      IF( MYCOL.EQ.IACOL ) THEN
         IF( MYROW.EQ.IAROW ) THEN
            CALL DGEBS2D( ICTXT, 'Columnwise', ' ', 1, NB, D( JJ ), 1 )
         ELSE
            CALL DGEBR2D( ICTXT, 'Columnwise', ' ', 1, NB, D( JJ ), 1,
     $                    IAROW, MYCOL )
         END IF
      END IF
*
      RETURN
*
*     End of PDLATRD
*
      END
