      SUBROUTINE PDLASE2( UPLO, M, N, ALPHA, BETA, A, IA, JA, DESCA )
*
*  -- ScaLAPACK auxilliary routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            IA, JA, M, N
      DOUBLE PRECISION   ALPHA, BETA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * )
*     ..
*
*  Purpose
*  =======
*
*  PDLASE2 initializes an M-by-N distributed matrix sub( A ) denoting
*  A(IA:IA+M-1,JA:JA+N-1) to BETA on the diagonal and ALPHA on the
*  offdiagonals.  PDLASE2 requires that only dimension of the matrix
*  operand is distributed.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  UPLO    (global input) CHARACTER
*          Specifies the part of the distributed matrix sub( A ) to be
*          set:
*          = 'U':      Upper triangular part is set; the strictly lower
*                      triangular part of sub( A ) is not changed;
*          = 'L':      Lower triangular part is set; the strictly upper
*                      triangular part of sub( A ) is not changed;
*          Otherwise:  All of the matrix sub( A ) is set.
*
*  M       (global input) INTEGER
*          The number of rows to be operated on i.e the number of rows
*          of the distributed submatrix sub( A ). M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns to be operated on i.e the number of
*          columns of the distributed submatrix sub( A ). N >= 0.
*
*  ALPHA   (global input) DOUBLE PRECISION
*          The constant to which the offdiagonal elements are to be
*          set.
*
*  BETA    (global input) DOUBLE PRECISION
*          The constant to which the diagonal elements are to be set.
*
*  A       (local output) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension (LLD_A,LOCq(JA+N-1)).  This array
*          contains the local pieces of the distributed matrix sub( A )
*          to be set.  On exit, the leading M-by-N submatrix sub( A )
*          is set as follows:
*
*          if UPLO = 'U', A(IA+i-1,JA+j-1) = ALPHA, 1<=i<=j-1, 1<=j<=N,
*          if UPLO = 'L', A(IA+i-1,JA+j-1) = ALPHA, j+1<=i<=M, 1<=j<=N,
*          otherwise,     A(IA+i-1,JA+j-1) = ALPHA, 1<=i<=M, 1<=j<=N,
*                                                   IA+i.NE.JA+j,
*          and, for all UPLO, A(IA+i-1,JA+i-1) = BETA, 1<=i<=min(M,N).
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            IBLCK, ICURCOL, ICURROW, II, ICOFF, IOFFA,
     $                   IROFF, ITMP, JBLCK, JJ, JTMP, LDA, MP, NQ,
     $                   MYCOL, MYROW, NPCOL, NPROW
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DLASET, INFOG2L
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            NUMROC
      EXTERNAL           LSAME, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN, MOD
*     ..
*     .. Executable Statements ..
*
      IF( M.EQ.0 .OR. N.EQ.0 )
     $   RETURN
*
*     Get grid parameters
*
      CALL BLACS_GRIDINFO( DESCA( 7 ), NPROW, NPCOL, MYROW, MYCOL )
*
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, II, JJ,
     $              ICURROW, ICURCOL )
      LDA = DESCA( 8 )
      IOFFA = II + ( JJ - 1 ) * LDA
*
      IF( N.LE.( DESCA( 4 )-MOD( JA-1, DESCA( 4 ) ) ) ) THEN
*
*        It is assumed that the local columns JJ:JJ+N-1 of the matrix A
*        are in the same process column (ICURCOL).
*
*                            JJ+MIN( N, DESCA(3)-IROFF )
*                        JJ            |   JJ+N-1
*         /  IBLK-MB+1   ---------------------    \
*   IROFF |              |             |     |    |
*         \         II   |.............|.....|    |         (ICURROW)
*         /              |\            |     |    |
*         |              | \           |     |    |
*         |              |  \          |     |    |
*         |              |   \         |     |    |
*         |              |    \        |     |    |     MB = DESCA(3)
*   ITMP  |              |     \       |     |    |
*         |              |      \      |     |    |
*         |              |       \     |     |    |
*         |              |        \    |     |    |
*         |              |         \   |     |    |
*         |              |          \  |     |    |
*         \      IBLCK   |           \ v     |    /
*                        |------------\------|
*                        |             \     |
*                        |              \    | (MOD(ICURROW+1,NPROW))
*                        |               \   |
*                        |                \  |
*                        |                 \ |
*                        |                  \|
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |-------------------|
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        ---------------------
*                              (ICURCOL)
*
         IF( MYCOL.EQ.ICURCOL ) THEN
*
            IROFF = MOD( IA-1, DESCA( 3 ) )
            MP = NUMROC( M+IROFF, DESCA( 3 ), MYROW, ICURROW, NPROW )
            IF( MP.LE.0 )
     $         RETURN
*
            IF( LSAME( UPLO, 'U' ) ) THEN
*
               ITMP = MIN( DESCA( 3 )-IROFF, N )
               IF( MYROW.EQ.ICURROW ) THEN
                  MP = MP - IROFF
                  IF( NPROW.GT.1 ) THEN
                     IBLCK = MIN( ITMP, MP )
                     CALL DLASET( UPLO, IBLCK, N, ALPHA, BETA,
     $                            A( IOFFA ), LDA )
                  ELSE
                     CALL DLASET( UPLO, MP, N, ALPHA, BETA, A( IOFFA ),
     $                            LDA )
                  END IF
               ELSE IF( MYROW.EQ.MOD( ICURROW+1, NPROW ) .AND.
     $                  NPROW.GT.1 .AND. ITMP.LE.N ) THEN
                  CALL DLASET( UPLO, MP, N-ITMP, ALPHA, BETA,
     $                         A( IOFFA+ITMP*LDA ), LDA )
               END IF
*
            ELSE
*
               IF( LSAME( UPLO, 'L' ) ) THEN
                  ITMP = MIN( DESCA( 3 )-IROFF, N )
               ELSE
                  ITMP = N
               END IF
               IF( MYROW.EQ.ICURROW ) THEN
                  MP = MP - IROFF
                  IF( NPROW.GT.1 .AND. ITMP.LE.N ) THEN
                     IBLCK = MIN( ITMP, MP )
                     CALL DLASET( UPLO, IBLCK, ITMP, ALPHA, BETA,
     $                            A( IOFFA ), LDA )
                     CALL DLASET( 'All', MP-IBLCK, N, ALPHA, ALPHA,
     $                            A( IOFFA+IBLCK ), LDA )
                  ELSE
                     CALL DLASET( UPLO, MP, N, ALPHA, BETA, A( IOFFA ),
     $                            LDA )
                  END IF
               ELSE IF( MYROW.EQ.MOD( ICURROW+1, NPROW ) .AND.
     $                  NPROW.GT.1 .AND. ITMP.LE.N ) THEN
                  CALL DLASET( 'All', MP, ITMP, ALPHA, ALPHA,
     $                         A( IOFFA ), LDA )
                  CALL DLASET( UPLO, MP, N-ITMP, ALPHA, BETA,
     $                         A( IOFFA+ITMP*LDA ), LDA )
               ELSE
                  CALL DLASET( 'All', MP, N, ALPHA, ALPHA, A( IOFFA ),
     $                         LDA )
               END IF
*
            END IF
*
         END IF
*
      ELSE IF( M.LE.( DESCA( 3 )-MOD( IA-1, DESCA( 3 ) ) ) ) THEN
*
*        It is assumed that the local rows II:II+M-1 of the matrix A
*        are in the same process row (ICURROW).
*
*                ICOFF    JTMP
*                _____  ________
*               /     \/        \
*          JBLCK-NB+1 JJ    JBLCK
*           II  ------------------------------------- .... ---------
*               |      .\       |               |                  |
*               |      . \      |               |                  |
*               |      .  \     |               |                  |
*               |      .   \    |               |                  |
*               |      .    \   |               |                  |
*               |      .     \  |               |                  |
*    (ICURROW)  |      .      \ |               |                  |
*               |      .       \|               |                  |
*               |      .        \               |                  |
* II+MIN(M,   --|-------------->|\              |                  |
*    NB-ICOFF)  |      .        | \             |                  |
*               |      .        |  \            |                  |
*               |      .        |   \           |                  |
*      II+M-1   ------------------------------------- .... ---------
*                 NB = DESCA(4)
*                  (ICURCOL)  (MOD(ICURCOL+1,NPCOL))
*
         IF( MYROW.EQ.ICURROW ) THEN
*
            ICOFF = MOD( JA-1, DESCA( 4 ) )
            NQ = NUMROC( N+ICOFF, DESCA( 4 ), MYCOL, ICURCOL, NPCOL )
            IF( NQ.LE.0 ) THEN
               RETURN
            END IF
*
            IF( LSAME( UPLO, 'L' ) ) THEN
*
               JTMP = MIN( DESCA( 4 )-ICOFF, M )
               IF( MYCOL.EQ.ICURCOL ) THEN
                  NQ = NQ - ICOFF
                  IF( NPCOL.GT.1 ) THEN
                     JBLCK = MIN( JTMP, NQ )
                     CALL DLASET( UPLO, M, JBLCK, ALPHA, BETA,
     $                            A( IOFFA ), LDA )
                  ELSE
                     CALL DLASET( UPLO, M, NQ, ALPHA, BETA, A( IOFFA ),
     $                            LDA )
                  END IF
               ELSE IF( MYCOL.EQ.MOD( ICURCOL+1,NPCOL ) .AND.
     $                  NPCOL.GT.1 .AND. JTMP.LE.M ) THEN
                  CALL DLASET( UPLO, M-JTMP, NQ, ALPHA, BETA,
     $                         A( IOFFA+JTMP ), LDA )
               END IF
*
            ELSE
*
               IF( LSAME( UPLO, 'U' ) ) THEN
                  JTMP = MIN( DESCA( 4 )-ICOFF, M )
               ELSE
                  JTMP = M
               END IF
               IF( MYCOL.EQ.ICURCOL ) THEN
                  NQ = NQ - ICOFF
                  IF( NPCOL.GT.1 .AND. JTMP.LE.M ) THEN
                     JBLCK = MIN( JTMP, NQ )
                     CALL DLASET( UPLO, JTMP, JBLCK, ALPHA, BETA,
     $                            A( IOFFA ), LDA )
                     CALL DLASET( 'All', M, NQ-JBLCK, ALPHA, ALPHA,
     $                            A( IOFFA+JBLCK*LDA ), LDA )
                  ELSE
                     CALL DLASET( UPLO, M, NQ, ALPHA, BETA, A( IOFFA ),
     $                            LDA )
                  END IF
               ELSE IF( MYCOL.EQ.MOD( ICURCOL+1, NPCOL ) .AND.
     $                  NPCOL.GT.1 .AND. JTMP.LE.M ) THEN
                  CALL DLASET( 'All', JTMP, NQ, ALPHA, ALPHA,
     $                         A( IOFFA ), LDA )
                  CALL DLASET( UPLO, M-JTMP, NQ, ALPHA, BETA,
     $                         A( IOFFA+JTMP ), LDA )
               ELSE
                  CALL DLASET( 'All', M, NQ, ALPHA, ALPHA, A( IOFFA ),
     $                         LDA )
               END IF
*
            END IF
*
         END IF
*
      END IF
*
      RETURN
*
*     End of PBDLASET
*
      END
