      DOUBLE PRECISION   FUNCTION PDLANGE( NORM, M, N, A, IA, JA, DESCA,
     $                                     WORK )
*
*  -- ScaLAPACK auxilliary routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      CHARACTER          NORM
      INTEGER            IA, JA, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDLANGE returns the value of the one norm, or the Frobenius norm,
*  or the infinity norm, or the element of largest absolute value of a
*  distributed matrix sub( A ) = A(IA:IA+M-1, JA:JA+N-1).
*
*  PDLANGE returns the value
*
*     ( max(abs(A(i,j))),  NORM = 'M' or 'm' with IA <= i <= IA+M-1,
*     (                                      and  JA <= j <= JA+N-1,
*     (
*     ( norm1( sub( A ) ), NORM = '1', 'O' or 'o'
*     (
*     ( normI( sub( A ) ), NORM = 'I' or 'i'
*     (
*     ( normF( sub( A ) ), NORM = 'F', 'f', 'E' or 'e'
*
*  where norm1 denotes the  one norm of a matrix (maximum column sum),
*  normI denotes the  infinity norm  of a matrix  (maximum row sum) and
*  normF denotes the  Frobenius norm of a matrix (square root of sum of
*  squares).  Note that  max(abs(A(i,j)))  is not a  matrix norm.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  NORM    (global input) CHARACTER
*          Specifies the value to be returned in PDLANGE as described
*          above.
*
*  M       (global input) INTEGER
*          The number of rows to be operated on i.e the number of rows
*          of the distributed submatrix sub( A ). When M = 0, PDLANGE
*          is set to zero. M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns to be operated on i.e the number of
*          columns of the distributed submatrix sub( A ). When N = 0,
*          PDLANGE is set to zero. N >= 0.
*
*  A       (local input) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension (LLD_A, LOCq(JA+N-1)) containing the
*          local pieces of the distributed matrix sub( A ).
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  WORK    (local workspace) DOUBLE PRECISION array, dimension of at
*          least Mp0 when NORM='I'; and MAX( 2, Nq0 ) otherwise, where
*
*          IROFFA = MOD( IA-1, MB_A ), ICOFFA = MOD( JA-1, NB_A ),
*          IAROW = INDXG2P( IA, MB_A, MYROW, RSRC_A, NPROW ),
*          IACOL = INDXG2P( JA, NB_A, MYCOL, CSRC_A, NPCOL ),
*          Mp0 = NUMROC( M+IROFFA, MB_A, MYROW, IAROW, NPROW ),
*          Nq0 = NUMROC( N+ICOFFA, NB_A, MYCOL, IACOL, NPCOL ),
*
*          INDXG2P and NUMROC are ScaLAPACK tool functions; MYROW,
*          MYCOL, NPROW and NPCOL can be determined by calling the
*          subroutine BLACS_GRIDINFO.
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            I, IACOL, IAROW, ICTXT, II, ICOFF, IOFFA,
     $                   IROFF, J, JJ, LDA, MP, MYCOL, MYROW, NPCOL,
     $                   NPROW, NQ
      DOUBLE PRECISION   SCALE, SUM, VALUE
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DCOMBSSQ, DGEBR2D,
     $                   DGEBS2D, DGAMX2D, DGSUM2D, DLASSQ,
     $                   INFOG2L, PDTREECOMB
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            IDAMAX, NUMROC
      EXTERNAL           LSAME, IDAMAX, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX, MIN, MOD, SQRT
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters.
*
      ICTXT = DESCA( 7 )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, II, JJ,
     $              IAROW, IACOL )
      IROFF = MOD( IA-1, DESCA( 3 ) )
      ICOFF = MOD( JA-1, DESCA( 4 ) )
      MP = NUMROC( M+IROFF, DESCA( 3 ), MYROW, IAROW, NPROW )
      NQ = NUMROC( N+ICOFF, DESCA( 4 ), MYCOL, IACOL, NPCOL )
      IF( MYROW.EQ.IAROW )
     $   MP = MP - IROFF
      IF( MYCOL.EQ.IACOL )
     $   NQ = NQ - ICOFF
      LDA = DESCA( 8 )
*
      IF( MIN( M, N ).EQ.0 ) THEN
*
         VALUE = ZERO
*
      ELSE IF( LSAME( NORM, 'M' ) ) THEN
*
*        Find max(abs(A(i,j))).
*
         VALUE = ZERO
         IF( NQ.GT.0 .AND. MP.GT.0 ) THEN
            IOFFA = (JJ-1)*LDA
            DO 20 J = JJ, JJ+NQ-1
               DO 10 I = II, MP+II-1
                  VALUE = MAX( VALUE, ABS( A( IOFFA+I ) ) )
   10          CONTINUE
               IOFFA = IOFFA + LDA
   20       CONTINUE
         END IF
         CALL DGAMX2D( ICTXT, 'All', ' ', 1, 1, VALUE, 1, I, J, -1,
     $                 0, 0 )
*
      ELSE IF( LSAME( NORM, 'O' ) .OR. NORM.EQ.'1' ) THEN
*
*        Find norm1( sub( A ) ).
*
         IF( NQ.GT.0 ) THEN
            IOFFA = ( JJ - 1 ) * LDA
            DO 40 J = JJ, JJ+NQ-1
               SUM = ZERO
               IF( MP.GT.0 ) THEN
                  DO 30 I = II, MP+II-1
                     SUM = SUM + ABS( A( IOFFA+I ) )
   30             CONTINUE
               END IF
               IOFFA = IOFFA + LDA
               WORK( J-JJ+1 ) = SUM
   40       CONTINUE
         END IF
*
*        Find sum of global matrix columns and store on row 0 of
*        process grid
*
         CALL DGSUM2D( ICTXT, 'Columnwise', ' ', 1, NQ, WORK, 1, 0,
     $                 MYCOL )
*
*        Find maximum sum of columns for 1-norm
*
         IF( MYROW.EQ.0 ) THEN
            IF( NQ.GT.0 ) THEN
               VALUE = WORK( IDAMAX( NQ, WORK, 1 ) )
            ELSE
               VALUE = ZERO
            END IF
            CALL DGAMX2D( ICTXT, 'Rowwise', ' ', 1, 1, VALUE, 1, I, J,
     $                    -1, 0, 0 )
         END IF
*
      ELSE IF( LSAME( NORM, 'I' ) ) THEN
*
*        Find normI( sub( A ) ).
*
         IF( MP.GT.0 ) THEN
            IOFFA = II + ( JJ - 1 ) * LDA
            DO 60 I = II, II+MP-1
               SUM = ZERO
               IF( NQ.GT.0 ) THEN
                  DO 50 J = IOFFA, IOFFA + NQ*LDA - 1, LDA
                     SUM = SUM + ABS( A( J ) )
   50             CONTINUE
               END IF
               WORK( I-II+1 ) = SUM
               IOFFA = IOFFA + 1
   60       CONTINUE
         END IF
*
*        Find sum of global matrix rows and store on column 0 of
*        process grid
*
         CALL DGSUM2D( ICTXT, 'Rowwise', ' ', 1, MP, WORK, 1, MYROW, 0 )
*
*        Find maximum sum of rows for supnorm
*
         IF( MYCOL.EQ.0 ) THEN
            IF( MP.GT.0 ) THEN
               VALUE = WORK( IDAMAX( MP, WORK, 1 ) )
            ELSE
               VALUE = ZERO
            END IF
            CALL DGAMX2D( ICTXT, 'Columnwise', ' ', 1, 1, VALUE, 1, I,
     $                    J, -1, 0, 0 )
         END IF
*
      ELSE IF( ( LSAME( NORM, 'F' ) ) .OR. ( LSAME( NORM, 'E' ) ) ) THEN
*
*        Find normF( sub( A ) ).
*
         SCALE = ZERO
         SUM = ONE
         IOFFA = II + ( JJ - 1 ) * LDA
         IF( NQ.GT.0 ) THEN
             DO 70 J = IOFFA, IOFFA + NQ*LDA - 1, LDA
                CALL DLASSQ( MP, A( J ), 1, SCALE, SUM )
   70        CONTINUE
         END IF
*
*        Perform the global scaled sum
*
         WORK( 1 ) = SUM
         WORK( 2 ) = SCALE
         CALL PDTREECOMB( ICTXT, 'All', 2, WORK, 0, 0, DCOMBSSQ )
         VALUE = WORK( 2 ) * SQRT( WORK( 1 ) )
*
      END IF
*
      IF( MYROW.EQ.0 .AND. MYCOL.EQ.0 ) THEN
         CALL DGEBS2D( ICTXT, 'All', ' ', 1, 1, VALUE, 1 )
      ELSE
         CALL DGEBR2D( ICTXT, 'All', ' ', 1, 1, VALUE, 1, 0, 0 )
      END IF
*
      PDLANGE = VALUE
*
      RETURN
*
*     End of PDLANGE
*
      END
