      SUBROUTINE PDLACP2( UPLO, M, N, A, IA, JA, DESCA, B, IB, JB,
     $                     DESCB )
*
*  -- ScaLAPACK auxilliary routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            IA, IB, JA, JB, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCB( * )
      DOUBLE PRECISION   A( * ), B( * )
*     ..
*
*  Purpose
*  =======
*
*  PDLACP2 copies all or part of a distributed matrix A to another
*  distributed matrix B.  No communication is performed, PDLACPY
*  performs a local copy sub( A ) := sub( B ), where sub( A ) denotes
*  A(IA:IA+M-1,JA:JA+N-1) and sub( B ) denotes B(IB:IB+M-1,JB:JB+N-1).
*  PDLACP2 requires that only dimension of the matrix operands is
*  distributed.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  UPLO    (global input) CHARACTER
*          Specifies the part of the distributed matrix sub( A ) to be
*          copied:
*          = 'U':   Upper triangular part is copied; the strictly
*                   lower triangular part of sub( A ) is not referenced;
*          = 'L':   Lower triangular part is copied; the strictly
*                   upper triangular part of sub( A ) is not referenced;
*          Otherwise:  All of the matrix sub( A ) is copied.
*
*  M       (global input) INTEGER
*          The number of rows to be operated on i.e the number of rows
*          of the distributed submatrix sub( A ). M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns to be operated on i.e the number of
*          columns of the distributed submatrix sub( A ). N >= 0.
*
*  A       (local input) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension (LLD_A, LOCq(JA+N-1) ). This array
*          contains the local pieces of the distributed matrix sub( A )
*          to be copied from.
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  B       (local output) DOUBLE PRECISION pointer into the local memory
*          to an array of dimension (LLD_B, LOCq(JB+N-1) ). This array
*          contains on exit the local pieces of the distributed matrix
*          sub( B ) set as follows:
*
*          if UPLO = 'U', B(IB+i-1,JB+j-1) = A(IA+i-1,JA+j-1),
*                         1<=i<=j, 1<=j<=N;
*          if UPLO = 'L', B(IB+i-1,JB+j-1) = A(IA+i-1,JA+j-1),
*                         j<=i<=M, 1<=j<=N;
*          otherwise,     B(IB+i-1,JB+j-1) = A(IA+i-1,JA+j-1),
*                         1<=i<=M, 1<=j<=N.
*
*  IB      (global input) INTEGER
*          B's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JB      (global input) INTEGER
*          B's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCB   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix B.
*
*  =====================================================================
*
*     .. Local Scalars ..
      INTEGER            IBCOL, IBLCK, IBROW, ICURCOL, ICURROW, IIA,
     $                   IIB, ICOFF, IOFFA, IOFFB, IROFF, ITMP, JBLCK,
     $                   JJA, JJB, JTMP, LDA, LDB, MP, NQ, MYCOL,
     $                   MYROW, NPCOL, NPROW
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DLACPY, INFOG2L
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            NUMROC
      EXTERNAL           LSAME, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN
*     ..
*     .. Executable Statements ..
*
      IF( M.EQ.0 .OR. N.EQ.0 )
     $   RETURN
*
*     Get grid parameters
*
      CALL BLACS_GRIDINFO( DESCA( 7 ), NPROW, NPCOL, MYROW, MYCOL )
*
      CALL INFOG2L( IB, JB, DESCB, NPROW, NPCOL, MYROW, MYCOL, IIB, JJB,
     $              IBROW, IBCOL )
      CALL INFOG2L( IA, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, IIA, JJA,
     $              ICURROW, ICURCOL )
      LDA = DESCA( 8 )
      LDB = DESCB( 8 )
      IOFFA = IIA + ( JJA - 1 ) * LDA
      IOFFB = IIB + ( JJB - 1 ) * LDB
*
      IF( N.LE.( DESCA( 4 )-MOD( JA-1, DESCA( 4 ) ) ) ) THEN
*
*        It is assumed that the local columns JJ:JJ+N-1 of the matrix A
*        are in the same process column (ICURCOL).
*
*                            JJ+MIN( N, DESCA(3)-IROFF )
*                        JJ            |   JJ+N-1
*         /  IBLK-MB+1   ---------------------    \
*   IROFF |              |             |     |    |
*         \         II   |.............|.....|    |         (ICURROW)
*         /              |\            |     |    |
*         |              | \           |     |    |
*         |              |  \          |     |    |
*         |              |   \         |     |    |
*         |              |    \        |     |    |     MB = DESCA(3)
*   ITMP  |              |     \       |     |    |
*         |              |      \      |     |    |
*         |              |       \     |     |    |
*         |              |        \    |     |    |
*         |              |         \   |     |    |
*         |              |          \  |     |    |
*         \      IBLCK   |           \ v     |    /
*                        |------------\------|
*                        |             \     |
*                        |              \    | (MOD(ICURROW+1,NPROW))
*                        |               \   |
*                        |                \  |
*                        |                 \ |
*                        |                  \|
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |-------------------|
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        |                   |
*                        ---------------------
*                              (ICURCOL)
*
         IF( MYCOL.EQ.ICURCOL ) THEN
*
            IROFF = MOD( IA-1, DESCA( 3 ) )
            MP = NUMROC( M+IROFF, DESCA( 3 ), MYROW, ICURROW, NPROW )
            IF( MP.LE.0 )
     $         RETURN
*
            IF( LSAME( UPLO, 'U' ) ) THEN
*
               ITMP = MIN( DESCA( 3 )-IROFF, N )
               IF( MYROW.EQ.ICURROW ) THEN
                  MP = MP - IROFF
                  IF( NPROW.GT.1 ) THEN
                     IBLCK = MIN( ITMP, MP )
                     CALL DLACPY( UPLO, IBLCK, N, A( IOFFA ), LDA,
     $                            B( IOFFB ), LDB )
                  ELSE
                     CALL DLACPY( UPLO, MP, N, A( IOFFA ), LDA,
     $                            B( IOFFB ), LDB )
                  END IF
               ELSE IF( MYROW.EQ.MOD( ICURROW+1, NPROW ) .AND.
     $                  NPROW.GT.1 .AND. ITMP.LE.N ) THEN
                  CALL DLACPY( UPLO, MP, N-ITMP, A( IOFFA+ITMP*LDA ),
     $                         LDA, B( IOFFB+ITMP*LDB ), LDB )
               END IF
*
            ELSE
*
               IF( LSAME( UPLO, 'L' ) ) THEN
                  ITMP = MIN( DESCA( 3 )-IROFF, N )
               ELSE
                  ITMP = N
               END IF
               IF( MYROW.EQ.ICURROW ) THEN
                  MP = MP - IROFF
                  IF( NPROW.GT.1 .AND. ITMP.LE.N ) THEN
                     IBLCK = MIN( ITMP, MP )
                     CALL DLACPY( UPLO, IBLCK, ITMP, A( IOFFA ), LDA,
     $                            B( IOFFB ), LDB )
                     CALL DLACPY( 'All', MP-IBLCK, N, A( IOFFA+IBLCK ),
     $                            LDA, B( IOFFB+IBLCK ), LDB )
                  ELSE
                     CALL DLACPY( UPLO, MP, N, A( IOFFA ), LDA,
     $                            B( IOFFB ), LDB )
                  END IF
               ELSE IF( MYROW.EQ.MOD( ICURROW+1, NPROW ) .AND.
     $                  NPROW.GT.1 .AND. ITMP.LE.N ) THEN
                  CALL DLACPY( 'All', MP, ITMP, A( IOFFA ), LDA,
     $                         B( IOFFB ), LDB )
                  CALL DLACPY( UPLO, MP, N-ITMP, A( IOFFA+ITMP*LDA ),
     $                         LDA, B( IOFFB+ITMP*LDB ), LDB )
               ELSE
                  CALL DLACPY( 'All', MP, N, A( IOFFA ), LDA,
     $                         B( IOFFB ), LDB )
               END IF
*
            END IF
*
         END IF
*
      ELSE IF( M.LE.( DESCA( 3 )-MOD( IA-1, DESCA( 3 ) ) ) ) THEN
*
*        It is assumed that the local rows II:II+M-1 of the matrix A
*        are in the same process row (ICURROW).
*
*                ICOFF    JTMP
*                _____  ________
*               /     \/        \
*          JBLCK-NB+1 JJ    JBLCK
*           II  ------------------------------------- .... ---------
*               |      .\       |               |                  |
*               |      . \      |               |                  |
*               |      .  \     |               |                  |
*               |      .   \    |               |                  |
*               |      .    \   |               |                  |
*               |      .     \  |               |                  |
*    (ICURROW)  |      .      \ |               |                  |
*               |      .       \|               |                  |
*               |      .        \               |                  |
* II+MIN(M,   --|-------------->|\              |                  |
*    NB-ICOFF)  |      .        | \             |                  |
*               |      .        |  \            |                  |
*               |      .        |   \           |                  |
*      II+M-1   ------------------------------------- .... ---------
*                 NB = DESCA(4)
*                  (ICURCOL)  (MOD(ICURCOL+1,NPCOL))
*
         IF( MYROW.EQ.ICURROW ) THEN
*
            ICOFF = MOD( JA-1, DESCA( 4 ) )
            NQ = NUMROC( N+ICOFF, DESCA( 4 ), MYCOL, ICURCOL, NPCOL )
            IF( NQ.LE.0 ) THEN
               RETURN
            END IF
*
            IF( LSAME( UPLO, 'L' ) ) THEN
*
               JTMP = MIN( DESCA( 4 )-ICOFF, M )
               IF( MYCOL.EQ.ICURCOL ) THEN
                  NQ = NQ - ICOFF
                  IF( NPCOL.GT.1 ) THEN
                     JBLCK = MIN( JTMP, NQ )
                     CALL DLACPY( UPLO, M, JBLCK, A( IOFFA ), LDA,
     $                            B( IOFFB ), LDB )
                  ELSE
                     CALL DLACPY( UPLO, M, NQ, A( IOFFA ), LDA,
     $                            B( IOFFB ), LDB )
                  END IF
               ELSE IF( MYCOL.EQ.MOD( ICURCOL+1, NPCOL ) .AND.
     $                  NPCOL.GT.1 .AND. JTMP.LE.M ) THEN
                  CALL DLACPY( UPLO, M-JTMP, NQ, A( IOFFA+JTMP ), LDA,
     $                         B( IOFFB+JTMP ), LDB )
               END IF
*
            ELSE
*
               IF( LSAME( UPLO, 'U' ) ) THEN
                  JTMP = MIN( DESCA( 4 )-ICOFF, M )
               ELSE
                  JTMP = M
               END IF
               IF( MYCOL.EQ.ICURCOL ) THEN
                  NQ = NQ - ICOFF
                  IF( NPCOL.GT.1 .AND. JTMP.LE.N ) THEN
                     JBLCK = MIN( JTMP, NQ )
                     CALL DLACPY( UPLO, JTMP, JBLCK, A( IOFFA ), LDA,
     $                            B( IOFFB ), LDB )
                     CALL DLACPY( 'All', M, NQ-JBLCK,
     $                            A( IOFFA+JBLCK*LDA ), LDA,
     $                            B( IOFFB+JBLCK*LDB ), LDB )
                  ELSE
                     CALL DLACPY( UPLO, M, NQ, A( IOFFA ), LDA,
     $                            B( IOFFB ), LDB )
                  END IF
               ELSE IF( MYCOL.EQ.MOD( ICURCOL+1, NPCOL ) .AND.
     $                  NPCOL.GT.1 .AND. JTMP.LE.M ) THEN
                  CALL DLACPY( 'All', JTMP, NQ, A( IOFFA ), LDA,
     $                         B( IOFFB ), LDB )
                  CALL DLACPY( UPLO, M-JTMP, NQ, A( IOFFA+JTMP ), LDA,
     $                         B( IOFFB+JTMP ), LDB )
               ELSE
                  CALL DLACPY( 'All', M, NQ, A( IOFFA ), LDA,
     $                         B( IOFFB ), LDB )
               END IF
*
            END IF
*
         END IF
*
      END IF
*
      RETURN
*
*     End of PDLACP2
*
      END
