      SUBROUTINE PBDTRST1( ICONTXT, XDIST, N, NB, NZ, X, INCX, BETA, Y,
     $                     INCY, LCMP, LCMQ, NINT )
*
*  -- PB-BLAS auxiliary routine (version 2.0) --
*     Oak Ridge National Laboratory and University of Tennessee
*     February 28, 1995
*
*     ..
*     .. Scalar Arguments ..
      CHARACTER*1          XDIST
      INTEGER              ICONTXT, N, NB, NZ, INCX, INCY
      INTEGER              LCMP, LCMQ, NINT
      DOUBLE PRECISION     BETA
*     ..
*     .. Array Arguments ..
      DOUBLE PRECISION     X( * ), Y( * )
*     ..
*
*  Purpose
*  =======
*
*     y <== x + beta * y
*     y is a sorted condensed row (or column) vector
*     from a column (or row) vector of x.
*
*     ..
*     .. Parameters ..
      DOUBLE PRECISION    ONE
      PARAMETER         ( ONE = 1.0D+0 )
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC           MIN, MAX, MOD
*     ..
*     .. External Functions ..
      LOGICAL             LSAME
      INTEGER             ICEIL
      EXTERNAL            LSAME, ICEIL
*     ..
*     .. External Subroutines ..
      EXTERNAL            PBDVECADD
*     ..
*     .. Local Variables ..
      INTEGER             IX, IY, K, KK, KZ, ITER, NJUMP
*
      ITER = ICEIL( NINT,  NB )
      KZ   = NZ
*
      IF( LSAME( XDIST, 'R' ) ) THEN
         NJUMP = NB * LCMQ
*
         DO 20 KK = 0, LCMQ-1
            IX = NINT * MOD( KK*LCMP, LCMQ )
            IY = MAX( 0, NB*KK-NZ )
            IF( N.LT.IY ) GO TO 50
*
            IF( ITER.GT.1 ) THEN
               CALL PBDVECADD( ICONTXT, 'G', NB-KZ, ONE, X(IX*INCX+1),
     $                         INCX, BETA, Y(IY*INCY+1), INCY )
               IX = IX + NB - KZ
               IY = IY + NJUMP - KZ
               KZ = 0
*
               DO 10 K = 2, ITER-1
                  CALL PBDVECADD( ICONTXT, 'G', NB, ONE, X(IX*INCX+1),
     $                            INCX, BETA, Y(IY*INCY+1), INCY )
                  IX = IX + NB
                  IY = IY + NJUMP
   10          CONTINUE
            END IF
*
            CALL PBDVECADD( ICONTXT, 'G', MIN(NB-KZ,N-IY), ONE,
     $                      X(IX*INCX+1), INCX, BETA, Y(IY*INCY+1),
     $                      INCY )
            KZ = 0
   20    CONTINUE
*
*     if( LSAME( XDIST, 'C' ) ) then
*
      ELSE
         NJUMP = NB * LCMP
*
         DO 40 KK = 0, LCMP-1
            IX = NINT * MOD( KK*LCMQ, LCMP )
            IY = MAX( 0, NB*KK-NZ )
            IF( N.LT.IY ) GO TO 50
*
            IF( ITER.GT.1 ) THEN
               CALL PBDVECADD( ICONTXT, 'G', NB-KZ, ONE, X(IX*INCX+1),
     $                         INCX, BETA, Y(IY*INCY+1), INCY )
               IX = IX + NB - KZ
               IY = IY + NJUMP - KZ
               KZ = 0
*
               DO 30 K = 2, ITER-1
                  CALL PBDVECADD( ICONTXT, 'G', NB, ONE, X(IX*INCX+1),
     $                            INCX, BETA, Y(IY*INCY+1), INCY )
                  IX = IX + NB
                  IY = IY + NJUMP
   30          CONTINUE
            END IF
*
            CALL PBDVECADD( ICONTXT, 'G', MIN(NB-KZ,N-IY), ONE,
     $                      X(IX*INCX+1), INCX, BETA, Y(IY*INCY+1),
     $                      INCY )
            KZ = 0
   40    CONTINUE
      END IF
*
   50 CONTINUE
*
      RETURN
*
*     End of PBDTRST1
*
      END
