#include "Bdef.h"

#if (INTFACE == C_CALL)
void Cigebr2d(ConTxt, scope, top, m, n, A, lda, rsrc, csrc)
int  ConTxt;
char  *scope;
char  *top;
int  m;
int  n;
int  *A;
int  lda;
int  rsrc;
int  csrc;
#else
void igebr2d_(ConTxt, scope, top, m, n, A, lda, rsrc, csrc)
int  *ConTxt;
char  *scope;
char  *top;
int  *m;
int  *n;
int  *A;
int  *lda;
int  *rsrc;
int  *csrc;
#endif
/*
 *  -- V1.0 BLACS routine --
 *  University of Tennessee, February 28, 1995
 *  Written by Clint Whaley.
 *
 *  Purpose
 *  =======
 *  Broadcast/receive for general integer arrays.
 *
 *  Arguments
 *  =========
 *
 *  ConTxt  (input) Ptr to int
 *          Index into MyConTxts00 (my contexts array).
 *
 *  SCOPE   (input) Ptr to char
 *          Limit the scope of the operation.
 *          = 'R' :   Operation is performed by a process row.
 *          = 'C' :   Operation is performed by a process column.
 *          = 'A' :   Operation is performed by all processes in grid.
 *
 *  TOP     (input) Ptr to char
 *          Controls fashion in which messages flow within the operation.
 *
 *  M       (input) Ptr to int
 *          The number of rows of the matrix A.  M >= 0.
 *
 *  N       (input) Ptr to int
 *          The number of columns of the matrix A.  N >= 0.
 *
 *  A       (output) Ptr to integer two dimensional array
 *          The m by n matrix A.  Fortran77 (column-major) storage
 *          assumed.
 *
 *  LDA     (input) Ptr to int
 *          The leading dimension of the array A.  LDA >= M.
 *
 *
 *  RSRC    (input) Ptr to int
 *          The process row of the source of the matrix.
 *
 *  CSRC    (input) Ptr to int
 *          The process column of the source of the matrix.
 *
 *
 * ------------------------------------------------------------------------
 */
{
#if (BlacsDebugLvl > 0)
   void ArgCheck00();
#endif
   void ipack00();
   void iunpack00();
   int Shyp_br();
   int Sidring_br();
   int Ssring_br();
   int Smpath_br();
   int Stree_br();
   char *getbuff();
   BLACSCONTEXT *ctxt;
   char ttop, tscope;
   int tlda, error;

   MGetConTxt(Mpval(ConTxt), ctxt);
   ttop = Mlowcase(*top);
   tscope = Mlowcase(*scope);
#if (BlacsDebugLvl > 0)
   ArgCheck00(Mpval(ConTxt), RT_BR, __FILE__, tscope, 'u', 'u', Mpval(m),
              Mpval(n), Mpval(lda), 1, Mpaddress(rsrc), Mpaddress(csrc));
#endif
   if (Mpval(m) <= Mpval(lda)) tlda = Mpval(lda);
   else tlda = Mpval(m);


   switch(ttop)
   {
   case ' ':
      error = Stree_br(ctxt, tscope, 2, Mpval(rsrc), Mpval(csrc));
      break;
   case 'h':
      error = Shyp_br(ctxt, tscope, Mpval(rsrc), Mpval(csrc));
      if (error == NPOW2)
         error = Stree_br(ctxt, tscope, 2,
                          Mpval(rsrc), Mpval(csrc));
      break;
   case '1':
   case '2':
   case '3':
   case '4':
   case '5':
   case '6':
   case '7':
   case '8':
   case '9':
      error = Stree_br(ctxt, tscope, ttop-47,
                       Mpval(rsrc), Mpval(csrc));
      break;
   case 't':
      error = Stree_br(ctxt, tscope, ctxt->nbranches,
                       Mpval(rsrc), Mpval(csrc));
      break;
   case 'i':
      error = Sidring_br(ctxt, tscope, Mpval(rsrc),
                         Mpval(csrc), 1);
      break;
   case 'd':
      error = Sidring_br(ctxt, tscope, Mpval(rsrc),
                         Mpval(csrc), -1);
      break;
   case 's':
      error = Ssring_br(ctxt, tscope,
                        Mpval(rsrc), Mpval(csrc));
      break;
   case 'm':
      error = Smpath_br(ctxt, tscope, ctxt->nrings,
                        Mpval(rsrc), Mpval(csrc));
      break;
   case 'f':
      error = Smpath_br(ctxt, tscope, FULLCON,
                        Mpval(rsrc), Mpval(csrc));
      break;
   default :
      BlacsErr(Mpval(ConTxt), __LINE__, __FILE__, "Unknown topology '%c'",*top);
   }

#if (BlacsDebugLvl > 0)
   if (error == BADSCP)
      BlacsErr(Mpval(ConTxt), __LINE__, __FILE__, "Unknown scope '%c'", *scope);
#endif
   iunpack00(Mpval(m), Mpval(n), (int *) A, tlda);
}
