#include "Bdef.h"

#if (INTFACE == C_CALL)
void Cblacs_set(ConTxt, what, val)
int  ConTxt;
int  what;
int  *val;
#else
void blacs_set_(ConTxt, what, val)
int  *ConTxt;
int  *what;
int  *val;
#endif
{
   BLACSCONTEXT *ctxt;
   extern int availID00, minID00, maxID00;

   switch( Mpval(what) )
   {
   case SGET_SYSCONTXT:
      BlacsWarn(Mpval(ConTxt), __LINE__, __FILE__,
                "Cannot set BLACS system context, can only BLACS_GET");
      break;
   case SGET_MSGIDS:
      if (availID00 != -1)
      {
         BlacsWarn(-1, __LINE__, __FILE__,
                   "Trying to change ID range after context definition");
         return;
      }

      if (val[0] >= val[1])  /* val[0] = minID, val[1] = maxID */
         BlacsErr(-1, __LINE__, __FILE__,
                  "minID(%d) must be less than maxID(%d)!!", val[0], val[1]);

      minID00 = val[0];
      maxID00 = val[1];
      break;
   case SGET_DEBUGLVL:
      BlacsWarn(Mpval(ConTxt), __LINE__, __FILE__,
                "Cannot set BLACS debug level; must recompile to change");
      break;
   case SGET_BLACSCONTXT:
      BlacsWarn(Mpval(ConTxt), __LINE__, __FILE__,
                "Cannot set BLACS context, can only BLACS_GET");
      break;
   case SGET_NRING:
      MGetConTxt(Mpval(ConTxt), ctxt);
      if (*val != 0) ctxt->nrings = *val;
      else BlacsWarn(Mpval(ConTxt), __LINE__, __FILE__,
                     "nrings cannot be set to zero");
      break;
   case SGET_NBRANCHES:
      MGetConTxt(Mpval(ConTxt), ctxt);
      if (*val > 0) ctxt->nbranches = *val + 1;
      else BlacsWarn(Mpval(ConTxt), __LINE__, __FILE__,
                     "Illegal nbranches (%d); must be strictly positive", *val);
      break;
   default:
      BlacsWarn(Mpval(ConTxt), __LINE__, __FILE__, "Unknown WHAT (%d)",
                Mpval(what));
   }
}
