#include "Bdef.h"
BLACBUFF *BI_Pack(BLACSCONTEXT *ctxt, BVOID *A, BLACBUFF *bp,
                  BI_MPI_Datatype Dtype)
{
   BLACBUFF *BI_GetBuff(int);
   int i, info, one=1;
   BI_MPI_Aint eltsiz;
   extern BLACBUFF BI_AuxBuff;

/*
 * Some versions of mpich and its derivitives cannot handle 0 byte typedefs,
 * so we have set MPI_BYTE as a flag for a 0 byte message
 */
#ifdef ZeroByteTypeBug
   if (Dtype == BI_MPI_BYTE)
   {
      bp = &BI_AuxBuff;
      bp->Buff = (char *) &BI_AuxBuff.Len;
      bp->N = 0;
      bp->dtype = BI_MPI_BYTE;
      return(bp);
   }
#endif
   if (bp == NULL)
   {
      BI_MPI_Pack_size(one, Dtype, ctxt->scp->comm, &i, info);
      bp = BI_GetBuff(i);
   }

   i = 0;
   BI_MPI_Pack(A, one, Dtype, bp->Buff, bp->Len, &i, ctxt->scp->comm, info);
   bp->dtype = BI_MPI_PACKED;
   bp->N = i;

   return(bp);
}
