      INCLUDE 'mpif.h'          
      INCLUDE 'fpvm3.h'       

C   ==================================================================
C   ===                                                            ===
C   ===          Definitions of basic data types for PVM           ===
C   ===                                                            ===
C   ===   ITYPE = PVM label for INTEGER data type                  ===
C   ===   DTYPE = PVM label for DOUBLE PRECISION data type         ===
C   ===   RTYPE = PVM label for REAL data type                     ===
C   ===                                                            ===
C   ===   These are passed as argument "what" to pvmfpack          ===
C   ===                                                            ===
C   ==================================================================
      INTEGER ITYPE, DTYPE, RTYPE
      INTEGER IDPLEN
      PARAMETER(IDPLEN = 8)
      PARAMETER(ITYPE = INTEGER4,
     &          DTYPE = REAL8,
     &          RTYPE = REAL4)

C 
C   ==================================================================
C   ===                                                            ===
C   ===          Definitions of two flags which are used           ===
C   ===          at runtime to determine:                          ===
C   ===                                                            ===
C   ===   MASTER  = Extra master process will be used              ===
C   ===   SPAWNIT = The program should spawn the processes         ===
C   ===                                                            ===
C   ===       There actual values are system dependent             ===
C   ===       They will be attached by  "make include"             ===
C   ===                                                            ===
C   ==================================================================
      INTEGER MASTER, SPAWNIT
      parameter ( MASTER  =  1)
      parameter ( SPAWNIT =  1)
C

      INTEGER  MAXNOD, maxcom, maxreq
      PARAMETER (MAXNOD=2048, maxcom=8, maxreq=6)

C     Groupname for each Communicator
      CHARACTER*6  GROUP(0:maxcom-1) 

      INTEGER  NNODES, MYTID, NUMCOM,
     f         GSIZE(0:maxcom-1), ME(0:maxcom-1), MASTID(0:maxcom-1), 
     f         TIDS(-1:MAXNOD,0:maxcom-1), req_buf(6,maxreq)
      common /pvmstuff/ nnodes, MYTID, numcom, gsize, me, 
     f         MASTID, TIDS, req_buf
      common /groupnames/ group

