      PROGRAM TICK2

C     =================================================
C     ===                                           ===
C     ===   Program:  Check Absolute Value of Clock ===
C     ===   Version:  Standard Fortran 77           ===
C     ===   Author:   Roger Hockney                 ===
C     ===                                           ===
C     =================================================

C     /* Program name */
      CHARACTER*10  NAME /'TICK2'/


C     /* Timer and result file placement routines */
      EXTERNAL DWALLTIME00
      DOUBLE PRECISION DWALLTIME00
C
      INTEGER IOUT
      CHARACTER CHAR,QUIT
      DOUBLE PRECISION DT(10),PCTERR,TIMWAL,TK(10)
C
      PARAMETER(IOUT=11)
C
      DATA QUIT/'q'/


      OPEN(IOUT,FILE='tick2.res')
C
      CALL HEADER(IOUT,NAME)
C
      WRITE(6,*)
      WRITE(6,*)'The calculation is in progress.  Please wait...'
      WRITE(6,*)
C
C     /* INITIALISE TIMER */
C
      TK(1) = DWALLTIME00()
C
100   CONTINUE
C
      PRINT*,'         MEASURING THE CLOCK MULTIPLIER'
      PRINT*,'         ------------------------------'
      PRINT*
      WRITE(IOUT,*)'         MEASURING THE CLOCK MULTIPLIER'
      WRITE(IOUT,*)'         ------------------------------'
      WRITE(IOUT,*)
      PRINT*,'Most computers measure time by counting the number'
      PRINT*,'of clock ticks, then use a multiplier to convert this'
      PRINT*,'number to seconds. This benchmark tests the validity'
      PRINT*,'of this multiplier, by measuring the same time interval'
      PRINT*,'with both the computer TIMER subroutine, and an external'
      PRINT*,'wall-clock, which can be your own wrist-watch.'
      PRINT*
      PRINT*,'The time interval is started and ended by a keyboard'
      PRINT*,'input. We suggest you time in interval of 2 minutes,'
      PRINT*,'which is timeable to about 0.1% with a wrist-watch.'
      PRINT*
C
        PRINT *,'Hit q <CR> to finish'
        PRINT *,'Hit s <CR> to start timing interval'
C
        READ (*,200) CHAR
200     FORMAT(A1)
        TK(1) = DWALLTIME00()
        IF(CHAR.EQ.QUIT) GOTO 1
C
C      /* WE WAIT SAY approx 5 minutes */
C
        PRINT *,'Hit s <CR> to end timing interval'
        READ(*,200)
        TK(2) = DWALLTIME00()
101     CONTINUE
        PRINT *,'Type number of minutes which elapsed by your'
        PRINT *,'external wall clock or wrist watch'
        PRINT *,'ENTER AS REAL NUMBER WITH DECIMAL POINT'
        READ(*,201) TIMWAL
201     FORMAT(E10.3)
        IF(TIMWAL.LE.0.0) THEN
      PRINT *,' *******  WALL-CLOCK TIME <= 0 : INVALID  *******'
      PRINT *,'                  Input Again'
      PRINT*
        GOTO 101
        ENDIF
C
        DT(1)=TK(2)-TK(1)
        DT(2)=60.0*TIMWAL
        PCTERR=100.0*ABS(DT(2)-DT(1))/DT(2)
C
        IF(DT(1).EQ.0.0) THEN
      PRINT *,' *******  TIME INTERVAL TOO SHORT TO MEASURE  *******'
      PRINT *,'                    Start Again'
      PRINT*
        GOTO 100
        ENDIF
C
      PRINT *,'Your computer TIMER routine measured ',DT(1),' second'
      PRINT *,'Your wall clock  measured            ',DT(2),' second'
      PRINT *
      PRINT *,'Percentage error =',PCTERR
      PRINT *
      PRINT *,'Multiply value from TIMER by ',DT(2)/DT(1)
      PRINT *,'  to make TIMER correct'
      PRINT *
      WRITE(IOUT,*)'Your computer TIMER routine measured ',DT(1),
     1             ' second'
      WRITE(IOUT,*)'Your wall clock  measured            ',DT(2),
     1             ' second'
      WRITE(IOUT,*)
      WRITE(IOUT,*)'Percentage error =',PCTERR
      WRITE(IOUT,*)
      WRITE(IOUT,*)'Multiply value from TIMER by ',DT(2)/DT(1)
      WRITE(IOUT,*)'  to make TIMER correct'
      WRITE(IOUT,*)
      PRINT *,'If this multiplier is very variable or badly in error,'
      PRINT *,'it probably means that you are using a'
      PRINT *,'CPU-for-this-job-only timer'
      PRINT *,'not a wall-clock timer. You must use a'
      PRINT *,'wall-clock timer for parallel benchmarking.'
      PRINT *
      PRINT *,'*** BEWARE *** : The returned value of the popular'
      PRINT *,' Sun Unix timer ETIME is not a wall-clock timer,'
      PRINT *,' even though it is called the elapsed time.'
      PRINT *
C    
      IF(PCTERR.GT.10.0) THEN
      PRINT *,' ***************************************************'
      PRINT *,'             TIMER GROSSLY IN ERROR'
      PRINT *,'             ----------------------'
      PRINT *,' Change Multiplier and/or change to wall-clock timer'
      PRINT *,' ***************************************************'
      PRINT *
      WRITE(IOUT,*)' **********************************************'
      WRITE(IOUT,*)'          TIMER GROSSLY IN ERROR'
      WRITE(IOUT,*)'          ----------------------'
      WRITE(IOUT,*)' Change Multiplier and/or '
      WRITE(IOUT,*)' change to wall-clock timer'
      WRITE(IOUT,*)' **********************************************'
      WRITE(IOUT,*)
      ENDIF
C
      IF(PCTERR.LT.0.5) THEN
      PRINT *,' ***************************************************'
      PRINT *,'                TIMER ERROR < 0.5 %'
      PRINT *,'                -------------------'
      PRINT *,'          Your timer is good enough to use'
      PRINT *,' ***************************************************'
      PRINT *
      WRITE(IOUT,*)' ***********************************************'
      WRITE(IOUT,*)'              TIMER ERROR < 0.5 %'
      WRITE(IOUT,*)'              -------------------'
      WRITE(IOUT,*)'        Your timer is good enough to use'
      WRITE(IOUT,*)' ***********************************************'
      WRITE(IOUT,*)
      ENDIF
C
      PRINT *,'Repeat test at least four times, using a busy system in'
      PRINT *,'order to distinguish between CPU and wall-clock timers'
      PRINT *
C
        GOTO 100

 1     CONTINUE
C
       CLOSE(IOUT)
C
       PRINT *, 'Benchmark complete.'
C
       STOP
       END
