      PROGRAM TICK1

C     =================================================
C     ===                                           ===
C     ===   Program:  Measure clock tick interval   ===
C     ===   Version:  Standard Fortran 77           ===
C     ===   Author:   Roger Hockney                 ===
C     ===   Modified: Ian Glendinning               ===
C     ===                                           ===
C     =================================================

C     /* Program name */
      CHARACTER*10  NAME /'TICK1'/


C     /* Timer and result file placement routines */
      EXTERNAL DWALLTIME00
      DOUBLE PRECISION DWALLTIME00
C
      INTEGER IOUT, NSAMPL, I, J, K
      PARAMETER(IOUT=11, NSAMPL=7)
      DOUBLE PRECISION DT(NSAMPL),TICK,TK(NSAMPL),TSTART


      OPEN(IOUT,FILE='tick1.res')
      CALL HEADER(IOUT,NAME)
C
      WRITE(6,*)
      WRITE(6,*)'The calculation is in progress.  Please wait...'
      WRITE(6,*)
C
C     /* Initialise timer */
C      
      TSTART = DWALLTIME00()
C
      WRITE(IOUT,4)
 4    FORMAT(2X,'TIME CHANGES BETWEEN SUCCESSIVE SAMPLES OF', 
     >' TIME BY SUBROUTINE TIMER',/)
C
C     /* Initialise TICK to a large value */
C
      TICK= 1.0E6
C
C     /* Measure the time between clock ticks */
C
      DO 1 I=1,10000
C
C       /* There are two cases.  Either the tick is shorter than the time    */
C       /* between successive calls to TIMER, in which case all of the DT    */
C       /* values will be multiples of it, or it is longer, in which case    */
C       /* the loop may have to execute a number of times before successive  */
C       /* calls register different times, but this should happen eventually */
C
        DO 15, K = 1, 7
           TK(K) = DWALLTIME00()
15      CONTINUE
C
        DO 6 J=2,NSAMPL
          DT(J)=TK(J)-TK(J-1)
          IF(DT(J) .NE. 0) TICK=MIN(TICK,DT(J))
6       CONTINUE
C
        IF(I .LE. 50) WRITE(IOUT,3) (DT(J),J=2,NSAMPL)
3         FORMAT(2X,'TIME CHANGE=',1P,6E15.6)
C
1     CONTINUE
C
      WRITE(IOUT,2) TICK
2     FORMAT(/,4X,'CLOCK TICK is less than or equal to ',1PE15.6,' sec')
C
      CLOSE(IOUT)
C
      PRINT *, 'Benchmark complete.'
C
      STOP
      END
