      SUBROUTINE ESTCOM(ERINF,ESTART,EOVER,MTIME,
     &                  MY_ID,MASTER_ID,SLAVE_ID,A)
C
      INCLUDE 'mpif.h'
      INCLUDE 'dattyp.inc'
      INCLUDE 'comms2.inc'
C
C     /* Timer routine */
C
      EXTERNAL DWALLTIME00
      DOUBLE PRECISION DWALLTIME00
C
      INTEGER NMAX
      PARAMETER(NMAX=MAXLEN/IDPLEN)
C
C     /* Estimated R-infinity, startup time and loop overhead */
C
      DOUBLE PRECISION ERINF, ESTART, EOVER
C
C     /* Desired measurement time for each test case */
C
      DOUBLE PRECISION MTIME
C
C     /* Process IDs */
C
      INTEGER MY_ID, MASTER_ID, SLAVE_ID

C     /* MPI status variables */
      INTEGER ierr, status(MPI_STATUS_SIZE)
C
C     /* The array to send/receive */
C
      DOUBLE PRECISION A(NMAX)
      INTEGER CASE, NREPT, MSGNUM, LENGTH
      DOUBLE PRECISION TIME(4),T1,T2, ELAPSED
C
C     Master code.
C
      IF( MY_ID.EQ.MASTER_ID )THEN
        DO 50, CASE=1, 4
          LENGTH = MAXLEN/CASE
C      
C         /* Note there will be 2 repeats on first iteration */
C
          NREPT = 1
          ELAPSED = 0
 10       IF( ELAPSED.LT.MTIME )THEN
            NREPT = NREPT * 2
            CALL MPI_SEND(NREPT,1,MPI_INTEGER,SLAVE_ID,30,
     &                    MPI_COMM_WORLD,ierr)
C
C           /* Synchronize to make sure the slave is ready */
C
            CALL MPI_SSEND(LENGTH,1,MPI_INTEGER,SLAVE_ID,31,
     &                    MPI_COMM_WORLD,ierr)
            T1 = DWALLTIME00()
            DO 20 MSGNUM = 1,NREPT
              CALL DUMMY(MSGNUM)
              CALL MPI_SEND(A,LENGTH,MPI_BYTE,SLAVE_ID,10,
     &                      MPI_COMM_WORLD,ierr)
              CALL MPI_RECV(A,LENGTH,MPI_BYTE,SLAVE_ID,20,
     &                      MPI_COMM_WORLD,status,ierr)
 20         CONTINUE
            T2 = DWALLTIME00()
            ELAPSED = T2-T1
            TIME(CASE) = (ELAPSED-EOVER*NREPT)/(NREPT*2)
            GOTO 10
          ENDIF
 50     CONTINUE
C
C       /* Inform the slave we've finished making timings for estimates */
C
        NREPT = 0
        CALL MPI_SEND(NREPT,1,MPI_INTEGER,SLAVE_ID,30,
     &                MPI_COMM_WORLD,ierr)

C       /* Calculate the actual estimates from the timings */
C       /* Note that the calculation of ESTART relies on the fact that */
C       /* the first set of messages are twice the length of the second */
C
        ERINF = MAXLEN/(TIME(1)-TIME(4))
        ESTART = (4*TIME(4))-TIME(1)
C
C       /* Send the estimates to the slave */
C
        CALL MPI_SEND(ERINF,1,MPI_DOUBLE_PRECISION,SLAVE_ID,32,
     &                MPI_COMM_WORLD,ierr)
        CALL MPI_SEND(ESTART,1,MPI_DOUBLE_PRECISION,SLAVE_ID,33,
     &                MPI_COMM_WORLD,ierr)
c
c	Slave code...
c
      ELSEIF( MY_ID.EQ.SLAVE_ID )THEN
        CALL MPI_RECV(NREPT,1,MPI_INTEGER,0,30,
     &                MPI_COMM_WORLD,status,ierr)
 30     IF( NREPT.NE.0 )THEN
          CALL MPI_RECV(LENGTH,1,MPI_INTEGER,0,31,
     &                  MPI_COMM_WORLD,status,ierr)
          DO 40 MSGNUM = 1,NREPT
            CALL MPI_RECV(A,LENGTH,MPI_BYTE,MASTER_ID,10,
     &                    MPI_COMM_WORLD,status,ierr)
            CALL MPI_SEND(A,LENGTH,MPI_BYTE,MASTER_ID,20,
     &                    MPI_COMM_WORLD,ierr)

 40       CONTINUE
          CALL MPI_RECV(NREPT,1,MPI_INTEGER,MASTER_ID,30,
     &                  MPI_COMM_WORLD,status,ierr)
        GOTO 30
        ENDIF
C
C       /* Receive the estimates from the master */
C
        CALL MPI_RECV(ERINF,1,MPI_DOUBLE_PRECISION,MASTER_ID,32,
     &                MPI_COMM_WORLD,status,ierr)
        CALL MPI_RECV(ESTART,1,MPI_DOUBLE_PRECISION,MASTER_ID,33,
     &                MPI_COMM_WORLD,status,ierr)
      ENDIF
      RETURN
      END
