      SUBROUTINE PDMATCMP( ICTXT, M, N, A, LDA, B, LDB, ERROR )

*  -- PUMMA Package auxiliary routine (version 2.1) --
*     Jaeyoung Choi, Oak Ridge National Laboratory.
*     Jack Dongarra, Univ. of Tennessee, Oak Ridge National Laboratory.
*     David Walker,  Oak Ridge National Laboratory.
*     March 26, 1995.
*
*     .. Scalar Arguments ..
      INTEGER              ICTXT, LDA, LDB, M, N, I1, I2
      DOUBLE PRECISION     ERROR
*     ..
*     .. Array Arguments ..
      DOUBLE PRECISION     A( LDA, * ), B( LDB, * )
*     ..
*
*  Purpose
*  =======
*
*  PDMATCMP : Parallel Real Double precision MATrix CoMPare.
*             Finds ERROR = MAX(||A(i,j) - B(i,j)||) locally.  Then,
*             returns the global maximum from the local values.
*
*  Arguments
*  =========
*
*  M         (input) INTEGER
*            Number of rows of the local matrices A and B. M  >= 0.
*
*  N         (input) INTEGER
*            Number of columns of the local matrices A and B. N >= 0.
*
*  A         (input/output) DOUBLE PRECISION, dimension ( LDA, N )
*            The pointer to the local matrix A.
*
*  LDA       (input) INTEGER
*            Leading Dimension of A.  LDA >= M
*
*  B         (output) DOUBLE PRECISION, dimension ( LDB, N )
*            The pointer to the local matrix B.
*
*  LDB       (input) INTEGER
*            Leading Dimension of B.  LDB >= M.
*
*  ERROR     (output) DOUBLE PRECISION
*            ERROR = MAX(||A(i,j) - B(i,j)||)
*
*  =====================================================================
*
*     ..
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER        ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      INTEGER            INFO, IX, J
*     ..
*     .. External Functions ..
      INTEGER            IDAMAX
      EXTERNAL           IDAMAX
*     ..
*     .. External Subroutines ..
      EXTERNAL           DAXPY, PXERBLA, DGAMX2D
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ABS, MAX
*
*     .. Check input parameters ..
*
      INFO = 0
      IF(      M    .LT.0                     ) THEN
         INFO = 1
      ELSE IF( N    .LT.0                     ) THEN
         INFO = 2
      ELSE IF( LDA  .LT.M                     ) THEN
         INFO = 4
      ELSE IF( LDB  .LT.M                     ) THEN
         INFO = 6
      END IF
*
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICTXT, 'PDMATCMP ', INFO )
         RETURN
      END IF
*     ..
*     .. Executable Statements ..
*
      ERROR = ZERO
*
      DO 10 J = 1, N
         CALL DAXPY( M, -ONE, A( 1, J ), 1, B( 1, J ), 1 ) 
         IX = IDAMAX( M, B( 1, J ), 1 )
         ERROR = MAX( ERROR, ABS( B( IX, J ) ) )
   10 CONTINUE
*
      CALL DGAMX2D( ICTXT, 'All', '1-Tree', 1, 1, ERROR, 1, I1, I2, 1,
     $              -1, -1 )
*
      RETURN
*
*     END of PDMATCMP
*
      END
*
