      SUBROUTINE PDGELQRV( M, N, A, IA, JA, DESCA, TAU, WORK )
*
*  -- ScaLAPACK routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      INTEGER            IA, JA, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * )
      DOUBLE PRECISION   A( * ), TAU( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDGELQRV computes sub( A ) = A(IA:IA+M-1,JA:JA+N-1) from L, Q
*  computed by PDGELQF.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  M       (global input) INTEGER
*          The number of rows to be operated on, i.e. the number of rows
*          of the distributed submatrix sub( A ). M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns to be operated on, i.e. the number of
*          columns of the distributed submatrix sub( A ). N >= 0.
*
*  A       (local input/local output) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (LLD_A, LOCq(JA+N-1)).
*          On entry, sub( A ) contains the the factors L and Q computed
*          by PDGELQF. On exit, the original matrix is restored.
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  TAU     (local input) DOUBLE PRECISION, array, dimension
*          LOCp(IA+MIN(M,N)-1). This array contains the scalar factors
*          TAU of the elementary reflectors computed by PDGELQF. TAU
*          is tied to the distributed matrix A.
*
*  WORK    (local workspace) DOUBLE PRECISION array, dimension
*          LWORK = MB_A * ( Mp0 + 2*Nq0 + MB_A ), where
*          Mp0   = NUMROC( M+IROFF, MB_A, MYROW, IAROW, NPROW ) * NB_A,
*          Nq0   = NUMROC( N+ICOFF, NB_A, MYCOL, IACOL, NPCOL ) * MB_A,
*          IROFF = MOD( IA-1, MB_A ), ICOFF = MOD( JA-1, NB_A ),
*          IAROW = INDXG2P( IA, DESCA( 3 ), MYROW, DESCA( 5 ), NPROW ),
*          IACOL = INDXG2P( JA, DESCA( 4 ), MYCOL, DESCA( 6 ), NPCOL ),
*          and NUMROC, INDXG2P are ScaLAPACK tool functions.
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      CHARACTER          COLBTOP, ROWBTOP
      INTEGER            I, IACOL, IAROW, IB, ICOFF, ICTXT, IIA, IL, IN,
     $                   IPT, IPV, IPW, J, JJA, JV, K, MYCOL, MYROW,
     $                   NPCOL, NPROW, NQ
*     ..
*     .. Local Arrays ..
      INTEGER            DESCV( 8 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DESCSET, INFOG2L, PDLACPY,
     $                   PDLARFB, PDLARFT, PDLASET
*     ..
*     .. External Functions ..
      INTEGER            ICEIL, NUMROC
      EXTERNAL           ICEIL, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters
*
      ICTXT = DESCA( 7 )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      K = MIN( M, N )
      IN = MIN( ICEIL( IA, DESCA( 3 ) ) * DESCA( 3 ), IA+K-1 )
      IL = MAX( ( (IA+K-2) / DESCA( 3 ) ) * DESCA( 3 ) + 1, IA )
*
      ICOFF = MOD( JA-1, DESCA( 4 ) )
      CALL INFOG2L( IL, JA, DESCA, NPROW, NPCOL, MYROW, MYCOL, IIA, JJA,
     $              IAROW, IACOL )
      NQ = NUMROC( N+ICOFF, DESCA( 4 ), MYCOL, IACOL, NPCOL )
      IPV = 1
      IPT = IPV + NQ * DESCA( 3 )
      IPW = IPT + DESCA( 3 ) * DESCA( 3 )
      CALL PTOPGET( 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPGET( 'Broadcast', 'Columnwise', COLBTOP )
      CALL PTOPSET( 'Broadcast', 'Rowwise', ' ' )
      CALL PTOPSET( 'Broadcast', 'Columnwise', 'D-ring' )
*
      CALL DESCSET( DESCV, DESCA( 3 ), N + ICOFF, DESCA( 3 ),
     $              DESCA( 4 ), IAROW, IACOL, ICTXT, DESCA( 3 ) )
*
      DO 10 I = IL, IN+1, -DESCA( 3 )
         IB = MIN( IA+K-I, DESCA( 3 ) )
         J  = JA + I - IA
         JV = 1  + I - IA
*
*        Compute upper triangular matrix T
*
         CALL PDLARFT( 'Forward', 'Rowwise', N-J+JA, IB, A, I, J, DESCA,
     $                 TAU, WORK( IPT ), WORK( IPW ) )
*
*        Copy Householder vectors into workspace
*
         CALL PDLACPY( 'Upper', IB, N-J+JA, A, I, J, DESCA, WORK( IPV ),
     $                 1, JV, DESCV )
         CALL PDLASET( 'Lower', IB, N-J+JA, ZERO, ONE, WORK( IPV ), 1,
     $                 JV, DESCV )
*
*        Zeroes the strict upper triangular part of sub( A ) to get
*        block column of L
*
         CALL PDLASET( 'Upper', IB, N-J+JA-1, ZERO, ZERO, A, I, J+1,
     $                 DESCA )
*
*        Apply block Householder transformation
*
         CALL PDLARFB( 'Right', 'Transpose', 'Forward', 'Rowwise',
     $                 M-I+IA, N-J+JA, IB, WORK( IPV ), 1, JV, DESCV,
     $                 WORK( IPT ), A, I, J, DESCA, WORK( IPW ) )
*
         DESCV( 5 ) = MOD( DESCV( 5 ) + NPROW - 1, NPROW )
*
   10 CONTINUE
*
*     Handle first block separately
*
      IB = IN - IA + 1
*
*     Compute upper triangular matrix T
*
      CALL PDLARFT( 'Forward', 'Rowwise', N, IB, A, IA, JA, DESCA, TAU,
     $              WORK( IPT ), WORK( IPW ) )
*
*     Copy Householder vectors into workspace
*
      CALL PDLACPY( 'Upper', IB, N, A, IA, JA, DESCA, WORK( IPV ), 1, 1,
     $              DESCV )
      CALL PDLASET( 'Lower', IB, N, ZERO, ONE, WORK, 1, 1, DESCV )
*
*     Zeroes the strict upper triangular part of sub( A ) to get
*     block column of L
*
      CALL PDLASET( 'Upper', IB, N-1, ZERO, ZERO, A, IA, JA+1, DESCA )
*
*     Apply block Householder transformation
*
      CALL PDLARFB( 'Right', 'Transpose', 'Forward', 'Rowwise', M, N,
     $              IB, WORK( IPV ), 1, 1, DESCV, WORK( IPT ), A, IA,
     $              JA, DESCA, WORK( IPW ) )
*
      CALL PTOPSET( 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPSET( 'Broadcast', 'Columnwise', COLBTOP )
*
      RETURN
*
*     End of PDGELQRV
*
      END
