      SUBROUTINE PDGETRRV( M, N, A, IA, JA, DESCA, IPIV, WORK )
*
*  -- ScaLAPACK routine (version 1.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     February 28, 1995
*
*     .. Scalar Arguments ..
      INTEGER            IA, JA, M, N
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), IPIV( * )
      DOUBLE PRECISION   A( * ), WORK( * )
*     ..
*
*  Purpose
*  =======
*
*  PDGETRRV reforms sub( A ) = A(IA:IA+M-1,JA:JA+N-1) from the
*  triangular matrices L and U returned by PDGETRF.  It multiplies
*  an upper triangular matrix stored in the upper triangle of sub( A )
*  times the unit lower triangular matrix stored in the lower triangle.
*  To accomplish this, the routine basically performs the PDGETRF
*  routine in reverse.
*
*  It computes L*U first, and then apply P: P*L*U => sub( A ). In the
*  J-th loop, the block column (or column panel), which has the lower
*  triangular unit matrix L is multiplied with the block row (or row
*  panel), which contains the upper triangular matrix U.
*
*                     ( L1 )             ( 0  0 )   ( L1*U1   L1*U2   )
*   A` = L * U + A` = (    ) * (U1 U2) + (      ) = (                 )
*                     ( L2 )             ( 0  A`)   ( L2*U1  L2*U2+A` )
*
*  where L1 is a lower unit triangular matrix and U1 is an upper
*  triangular matrix.
*
*  Notes
*  =====
*
*  A description vector is associated with each 2D block-cyclicly dis-
*  tributed matrix.  This vector stores the information required to
*  establish the mapping between a matrix entry and its corresponding
*  process and memory location.
*
*  In the following comments, the character _ should be read as
*  "of the distributed matrix".  Let A be a generic term for any 2D
*  block cyclicly distributed matrix.  Its description vector is DESCA:
*
*  NOTATION        STORED IN  EXPLANATION
*  --------------- ---------- ------------------------------------------
*  M_A    (global) DESCA( 1 ) The number of rows in the distributed
*                             matrix.
*  N_A    (global) DESCA( 2 ) The number of columns in the distributed
*                             matrix.
*  MB_A   (global) DESCA( 3 ) The blocking factor used to distribute
*                             the rows of the matrix.
*  NB_A   (global) DESCA( 4 ) The blocking factor used to distribute
*                             the columns of the matrix.
*  RSRC_A (global) DESCA( 5 ) The process row over which the first row
*                             of the matrix is distributed.
*  CSRC_A (global) DESCA( 6 ) The process column over which the first
*                             column of the matrix is distributed.
*  CTXT_A (global) DESCA( 7 ) The BLACS context handle, indicating the
*                             BLACS process grid A is distributed over.
*                             The context itself is global, but the handle
*                             (the integer value) may vary.
*  LLD_A  (local)  DESCA( 8 ) The leading dimension of the local array
*                             storing the local blocks of the distri-
*                             buted matrix A. LLD_A >= MAX(1,LOCp(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCp( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCq( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCp() and LOCq() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCp( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCq( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*
*  Arguments
*  =========
*
*  M       (global input) INTEGER
*          The number of rows to be operated on, i.e. the number of rows
*          of the distributed submatrix sub( A ). M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns to be operated on, i.e. the number of
*          columns of the distributed submatrix sub( A ). N >= 0.
*
*  A       (local input/local output) DOUBLE PRECISION pointer into the
*          local memory to an array of dimension (LLD_A, LOCq(JA+N-1)).
*          On entry, the local pieces of the distributed matrix sub( A )
*          contains the the factors L and U from the factorization
*          sub( A ) = P*L*U; the unit diagonal elements of L are not
*          stored. On exit, the original distributed matrix sub( A )
*          is restored.
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension 8
*          The array descriptor for the distributed matrix A.
*
*  IPIV    (local input) INTEGER array, dimension ( LOCp(M_A)+MB_A )
*          This array contains the pivoting information.
*          IPIV(i) -> The global row local row i was swapped with.
*          This array is tied to the distributed matrix A.
*
*  WORK    (local workspace) DOUBLE PRECISION array of dimension (LWORK)
*          LWORK >= MpA0 * NB_A + NqA0 * MB_A, where
*
*          IROFFA = MOD( IA-1, MB_A ), ICOFFA = MOD( JA-1, NB_A ),
*          IAROW = INDXG2P( IA, MB_A, MYROW, RSRC_A, NPROW ),
*          IACOL = INDXG2P( JA, NB_A, MYCOL, CSRC_A, NPCOL ),
*          MpA0 = NUMROC( M+IROFFA, MB_A, MYROW, IAROW, NPROW ),
*          NqA0 = NUMROC( N+ICOFFA, NB_A, MYCOL, IACOL, NPCOL ),
*
*          WORK is used to store a block of columns of L, and a block of
*          rows of U. INDXG2P and NUMROC are ScaLAPACK tool functions;
*          MYROW, MYCOL, NPROW and NPCOL can be determined by calling
*          the subroutine BLACS_GRIDINFO.
*
*  =====================================================================
*
*     .. Parameters ..
      DOUBLE PRECISION   ONE, ZERO
      PARAMETER          ( ONE = 1.0D+0, ZERO = 0.0D+0 )
*     ..
*     .. Local Scalars ..
      CHARACTER          COLBTOP, ROWBTOP
      INTEGER            IACOL, IAROW, ICTXT, IL, IPL, IPU, IROFF, J,
     $                   JB, JL, JN, MN, MP, MYCOL, MYROW, NPCOL, NPROW
*     .. Local Arrays ..
      INTEGER            DESCIP( 8 ), DESCL( 8 ), DESCU( 8 ), IDUM( 1 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DESCSET, PDGEMM, PDLACPY,
     $                   PDLAPIV, PDLASET, PTOPGET, PTOPSET
*     ..
*     .. External Functions ..
      INTEGER            ICEIL, INDXG2P, NUMROC
      EXTERNAL           ICEIL, INDXG2P, NUMROC
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
*
*     Get grid parameters.
*
      ICTXT = DESCA( 7 )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
      IROFF = MOD( IA-1, DESCA( 3 ) )
      IAROW = INDXG2P( IA, DESCA( 3 ), MYROW, DESCA( 5 ), NPROW )
      MP = NUMROC( M+IROFF, DESCA( 3 ), MYROW, IAROW, NPROW )
      IPL = 1
      IPU = IPL + MP * DESCA( 4 )
      CALL PTOPGET( 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPGET( 'Broadcast', 'Columnwise', COLBTOP )
      CALL PTOPSET( 'Broadcast', 'Rowwise', 'S-ring' )
      CALL PTOPSET( 'Broadcast', 'Columnwise', ' ' )
*
*     Define array descriptors for L and U
*
      MN = MIN( M, N )
      IL = MAX( ( ( IA+MN-2 ) / DESCA( 3 ) ) * DESCA( 3 ) + 1, IA )
      JL = MAX( ( ( JA+MN-2 ) / DESCA( 4 ) ) * DESCA( 4 ) + 1, JA )
      JN = MIN( ICEIL( JA, DESCA( 4 ) )*DESCA( 4 ), JA+MN-1 )
      IAROW = INDXG2P( IL, DESCA( 3 ), MYROW, DESCA( 5 ), NPROW )
      IACOL = INDXG2P( JL, DESCA( 4 ), MYCOL, DESCA( 6 ), NPCOL )
*
      CALL DESCSET( DESCL, IA+M-IL, DESCA( 4 ), DESCA( 3 ), DESCA( 4 ),
     $              IAROW, IACOL, ICTXT, MAX( 1, MP ) )
*
      CALL DESCSET( DESCU, DESCA( 3 ), JA+N-JL, DESCA( 3 ), DESCA( 4 ),
     $              IAROW, IACOL, ICTXT, DESCA( 3 ) )
*
      CALL DESCSET( DESCIP, DESCA( 1 ) + DESCA( 3 )*NPROW, 1,
     $              DESCA( 3 ), 1, DESCA( 5 ), MYCOL, ICTXT,
     $              NUMROC( DESCA( 1 ), DESCA( 3 ), MYROW, DESCA( 5 ),
     $                      NPROW ) + DESCA( 3 ) )
*
*
      DO 10 J = JL, JN+1, -DESCA( 4 )
*
         JB = MIN( JA+MN-J, DESCA( 4 ) )
*
*        Copy unit lower triangular part of sub( A ) into WORK
*
         CALL PDLACPY( 'Lower', M-IL+IA, JB, A, IL, J, DESCA,
     $                 WORK( IPL ), 1, 1, DESCL )
         CALL PDLASET( 'Upper', M-IL+IA, JB, ZERO, ONE, WORK( IPL ),
     $                 1, 1, DESCL )
*
*        Copy upper triangular part of sub( A ) into WORK(IPU)
*
         CALL PDLACPY( 'Upper', JB, JA+N-J, A, IL, J, DESCA,
     $                 WORK( IPU ), 1, 1, DESCU )
         CALL PDLASET( 'Lower', JB-1, JA+N-J, ZERO, ZERO,
     $                 WORK( IPU ), 2, 1, DESCU )
*
*        Zero the strict lower triangular piece of the current block.
*
         CALL PDLASET( 'Lower', IA+M-IL-1, JB, ZERO, ZERO, A, IL+1, J,
     $                 DESCA )
*
*        Zero the upper triangular piece of the current block.
*
         CALL PDLASET( 'Upper', JB, JA+N-J, ZERO, ZERO, A, IL, J,
     $                 DESCA )
*
*        Update the matrix sub( A ).
*
         CALL PDGEMM( 'No transpose', 'No transpose', IA+M-IL,
     $                JA+N-J, JB, ONE, WORK( IPL ), 1, 1, DESCL,
     $                WORK( IPU ), 1, 1, DESCU, ONE, A, IL, J, DESCA )
*
         IL = IL - DESCA( 3 )
         DESCL( 1 ) = DESCL( 1 ) + DESCL( 3 )
         DESCL( 5 ) = MOD( DESCL( 5 ) + NPROW - 1, NPROW )
         DESCL( 6 ) = MOD( DESCL( 6 ) + NPCOL - 1, NPCOL )
         DESCU( 2 ) = DESCU( 2 ) + DESCU( 4 )
         DESCU( 5 ) = DESCL( 5 )
         DESCU( 6 ) = DESCL( 6 )
*
   10 CONTINUE
*
*     Handle first block separately
*
      JB = MIN( JN-JA+1, DESCA( 4 ) )
*
*     Copy unit lower triangular part of sub( A ) into WORK
*
      CALL PDLACPY( 'Lower', M, JB, A, IA, JA, DESCA, WORK( IPL ),
     $              1, 1, DESCL )
      CALL PDLASET( 'Upper', M, JB, ZERO, ONE, WORK( IPL ), 1, 1,
     $              DESCL )
*
*     Copy upper triangular part of sub( A ) into WORK(IPU)
*
      CALL PDLACPY( 'Upper', JB, N, A, IA, JA, DESCA, WORK( IPU ), 1,
     $              1, DESCU )
      CALL PDLASET( 'Lower', JB-1, N, ZERO, ZERO, WORK( IPU ), 2, 1,
     $              DESCU )
*
*     Zero the strict lower triangular piece of the current block.
*
      CALL PDLASET( 'Lower', M-1, JB, ZERO, ZERO, A, IA+1, JA, DESCA )
*
*     Zero the upper triangular piece of the current block.
*
      CALL PDLASET( 'Upper', JB, N, ZERO, ZERO, A, IA, JA, DESCA )
*
*     Update the matrix sub( A ).
*
      CALL PDGEMM( 'No transpose', 'No transpose', M, N, JB, ONE,
     $             WORK( IPL ), 1, 1, DESCL, WORK( IPU ), 1, 1,
     $             DESCU, ONE, A, IA, JA, DESCA )
*
*     Apply pivots so that sub( A ) = P*L*U
*
      CALL PDLAPIV( 'Backward', 'Row', 'Col', MIN( M, N ), N, A, IA, JA,
     $              DESCA, IPIV, IA, 1, DESCIP, IDUM )
*
      CALL PTOPSET( 'Broadcast', 'Rowwise', ROWBTOP )
      CALL PTOPSET( 'Broadcast', 'Columnwise', COLBTOP )
*
      RETURN
*
*     End of PDGETRRV
*
      END
