C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  (Stripped down PVM-only version (4/13/95), for use in ParkBench     #
C   benchmark suite)                                                   #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
      SUBROUTINE ILTCAST(STAGE, MAXSTAGE, DECLSZ, LOCVEC, EXTVEC, PTER)
C
C If ((LTOPT .EQ. 0) .AND. (COMMILT .LT. 10)), then this subroutine 
C executes one stage of a ring-shift algorithm for broadcasting a 
C distributed complex vector (allowing data to be used between stages). 
C Otherwise, it does nothing.
C
C called by: DZPUV, ILTRNS, ITRNPE
C calls: RING_MAP, SHIFTCAST
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C parallel algorithm information
#     include "algorithm.i"
C domain decomposition information
#     include "spectral.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input 
C
C current stage of the broadcast (an increasing sequence)
      INTEGER STAGE
C maximum (final) stage in the broadcast
      INTEGER MAXSTAGE
C declared length of the segments of the distributed data vector
      INTEGER DECLSZ
C local segment of the data vector
      COMPLEX LOCVEC(DECLSZ)
C
C     Input/Output
C
C communication buffers for receiving external segments of the complex 
C data vector
      COMPLEX EXTVEC(DECLSZ,BUFSILT)
C pointer to beginning of segment to be used next
      INTEGER PTER
C
C---- Local Variables --------------------------------------------------
C
C base for message types used in this broadcast algorithm
C (It is used to prevent sends and receives in this operation from
C being erroneously "consumed" by sends and receives in other 
C phases of the program.)
      INTEGER BASE
      SAVE BASE
C neighbors in logical ring
      INTEGER LEFT, RIGHT
      SAVE LEFT, RIGHT
C
C---- External Functions -----------------------------------------------
C
C offset for message types
      EXTERNAL MSGBASE
      INTEGER MSGBASE
C processor ids for ring neighbors
      EXTERNAL RING_MAP
      INTEGER RING_MAP
C
C---- Executable Statements --------------------------------------------
C
      CALL TRACEEVENTF('entry', 9, 0, 0)
        CALL SETDATA0F(DATAREAL)
        IF (NPSPEC_S .GT. 1) THEN
C         Something to do.
C
          IF (LTOPT .EQ. 0) THEN
C
            IF (COMMILT .LT. 10) THEN
C
C             Using a ring-shift algorithm for broadcasting a 
C             distributed vector, allowing the utilization of the 
C             current segment of the vector to overlap the communication
C             involved in procuring the next segment (pipelining).
C
C             If first time, update message type base and calculate
C             neighbors. 
              IF (STAGE .EQ. 1) THEN
                BASE = MSGBASE()
                LEFT = RING_MAP(SPECDEX_S-1, NPSPEC_S, MAPSPEC_S)
                RIGHT= RING_MAP(SPECDEX_S+1, NPSPEC_S, MAPSPEC_S)
              ENDIF                
C
C             Calculate a stage of the ring-shift broadcast algorithm
C             (doubling the length since a complex vector, and SHIFTCAST 
C              expects real vectors).
              CALL SHIFTCAST(COMMILT, BUFSILT, PROTILT,
     &                       MAPSPEC_S(SPECDEX_S), LEFT, RIGHT,
     &                       SPECDEX_S, BASE, STAGE, MAXSTAGE, 2*DECLSZ,
     &                       LOCVEC, EXTVEC, PTER) 
C
            ELSEIF (COMMILT .LT. 40) THEN
C
C             Nothing to do: used a column-wise vector sum and broadcast
C             algorithm in forward transform, so all data needed to 
C             calculate inverse transform resides locally.
C
            ELSE
C
C             illegal communication option specified
              WRITE(0,100) MAPSPEC_S(SPECDEX_S), LTOPT, COMMILT
  100         FORMAT (/,' PSTSWM: FATAL ERROR IN SUBROUTINE ILTCAST ',/,
     &                ' ILLEGAL PARALLEL ALGORITHM OPTION SPECIFIED ',/,
     &                ' FOR INVERSE LEGENDRE TRANSFORM',/,
     &                ' PROCID = ',I4,' LTOPT = ',I4,' COMMILT = ',I4)
              STOP
C
            ENDIF
C
          ELSEIF (LTOPT .EQ. 1) THEN
C
C           Using a transpose algorithm, so nothing to do.
C           (NPSPEC_S .EQ. 1)
C
          ELSE
C
C           illegal Legendre transform option specified
            WRITE(0,100) MAPSPEC_S(SPECDEX_S), LTOPT, COMMILT
            STOP
C
          ENDIF
C
        ENDIF
      CALL TRACEEVENTF('exit', 9, 0, 0)
C
      RETURN
      END

