C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
      SUBROUTINE SPCANL(A2NNP1, DIVSC, ZETASC, PHISC, WSA, WSB) 
C                                                                              
C This routine computes the spectrum for various quantities. Currently
C the code does spectral analysis for the height and  kinetic energy.
C                                                                              
C called by: PSTSWM
C calls: SGRIDSUM
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C machine architecture information
#     include "machine.i"
C problem resolution information
#     include "problem.i"
C domain decomposition definition variables
#     include "spectral.i"
C constants
#     include "consts.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C (N*(N+1))/A**2
      REAL A2NNP1(0:KK)
C computed divergence spectral coefficients
      COMPLEX DIVSC(MXLSPEC_S)
C computed vorticity spectral coefficients
      COMPLEX ZETASC(MXLSPEC_S)
C computed height spectral coefficients
      COMPLEX PHISC(MXLSPEC_S)
C
C     Work Space
C
C work arrays
      REAL WSA(KK,2,NLFC_S+1)
      REAL WSB(KK,2,NLFC_S+1)
C
C---- Local Variables --------------------------------------------------
C
C loop index
      INTEGER K
C polynomial degree, polynomial degree index, and polynomial degree 
C transition index
      INTEGER N, JN, JNTRNS
C wavenumber and untruncated and truncated wavenumber indices
      INTEGER M, IM, JM
C spectral coefficient index
      INTEGER L
C precalculated coefficient
      REAL FAC
C relative vorticity
      COMPLEX ETASC
C     special value for spectrum plots
      REAL SPVAL
C
C---- Executable Statements --------------------------------------------
C
C     Initialize arrays and constants.
      SPVAL = 10.0**36
C     (storage arrays for spectrum - 
C      PHIG: WSA(1:KK,1,1)
C      KEG:  WSA(1:KK,2,1) )
      DO IM=1,NLFC_S
        DO K=1,KK
          WSA(K,1,IM) = 0.0
          WSA(K,2,IM) = 0.0
        ENDDO
      ENDDO
C
      IF ((NLMM_S .GT. 0) .AND. (NLVER_S .GT. 0)) THEN
C
C       Add meridional waves along diagonals.
        JNTRNS = 0
        L = 0
        IM = 0
        DO JM=JMB_S(1),JME_S(1)
          M = MTRUE_S(JM)
          IM = IM + 1
C
          JNTRNS = JNTRNS + 1
          DO JN=JNB_S(JNTRNS),JNE_S(JNTRNS)
            L = L+1
C
C           Use symmetry of M.
            IF (M .EQ. 0) THEN
              FAC = 1.0 
            ELSE
              FAC = 2.0 
            ENDIF
C
C           Compute spectral index.
            N = M + JN - 1
C
C           Compute relative vorticity by subtracting spectral coriolis
C           term.
            IF ((N .EQ. 1) .AND. (M .EQ. 0)) THEN
              ETASC = ZETASC(L) - CORSC1
            ELSEIF ((N .EQ. 1) .AND. (M .EQ. 1)) THEN
              ETASC = ZETASC(L) - CORSC2
            ELSE
              ETASC = ZETASC(L)
            ENDIF
C
C           Ignore global mean!
            IF (N .NE. 0) THEN
              WSA(N,2,IM) = FAC*(DIVSC(L)*CONJG(DIVSC(L)) + 
     &                   ETASC*CONJG(ETASC))/(4.0*A2NNP1(N))
              WSA(N,1,IM) = FAC*PHISC(L)*CONJG(PHISC(L))*0.5
            ENDIF
          ENDDO
C
        ENDDO
C
      ENDIF
C
C     Finish calculation with global vector sum of length 2*KK
C     (using "approximate" reproducibility ordering).
      CALL SGRIDSUM(2*KK, 2*KK, NLFC_S, 1, WSA, WSB, WSA)
C
C     Print results.
      IF (ME .EQ. 0) THEN
C
        WRITE (6,987) NSTEP, TAU
  987   FORMAT (/, ' SPCANL: SPECTRAL ANALYSIS FOR NSTEP = ', I4,
     &          ', TAU = ', 0PF6.2, ' HRS')
C
        DO K=1,KK
          WRITE (6,124) K, WSA(K,1,1), WSA(K,2,1)
  124     FORMAT (' WAVE K = ',I4,' PHI/KE AMPLITUDE = ',1PE16.9,
     &            '/',1PE16.9)
C
C         Check for zero values (causes problems with logarithmic
C         plots). 
          IF (WSA(K,1,1) .EQ. 0.0) THEN
            WSA(K,1,1) = SPVAL       
          ENDIF
          IF (WSA(K,2,1) .EQ. 0.0) THEN
            WSA(K,2,1) = SPVAL
          ENDIF
        ENDDO
C
      ENDIF
C
      RETURN
      END
