C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
      SUBROUTINE PSC(PHIBAR, ALP, WTS, TRIGS, MOUNT, HIC, WS1, WS2, WS3,
     &               PHISC)
C                                                                              
C This subroutine obtains geopotential spectral coefficients 
C from the gridpoint heights. PSC is used only during initialization. 
C To save space, only a single vertical layer is assumed in the physical
C data, and only a single vertical level of spectral coefficients is 
C generated. 
C
C called by: STSWM
C calls: GEOP, SHTRNS
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C problem resolution information
#     include "problem.i"
C domain decomposition definition variables
#     include "physical.i"
#     include "spectral.i"
C transform arrays
#     include "trnsfm.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C global mean geopotential
      REAL PHIBAR
C assoc. Legendre polynomials
      REAL ALP(NFSPEC_S,NLLATH_S)
C Gaussian weights
      REAL WTS(NLAT)
C trigonometric function values used by RFTLON 
      COMPLEX TRIGS(NTRIGS)
C mountain height
      REAL MOUNT(NLLON_P,NLLAT_P)
C height field
      REAL HIC(NLLON_P,NLLAT_P)
C
C     Work Space
C
C work array 1
C (big enough for REAL (MXLLON_P,NLVER_P,NLLAT_P)
C             and COMPLEX (MXLFC_S,NLVER_S,NLLAT_S))
      REAL WS1(1)
C work array 2
C (big enough for REAL (MXLLON_P,MXLVER_P,MXLLAT_P,BUFSWS2)
C             and REAL (MXLLON_F,MXLVER_F,MXLLAT_F,BUFSWS2)
C             and COMPLEX (MXLFC_S,MXLVER_S,MXLLAT_S,BUFSWS2)
C             and COMPLEX (2,NLFC_S,NLLATH_S))
      REAL WS2(1)
C work array 3
C (big enough for COMPLEX (MXLSPEC_S,BUFSWS3))
      REAL WS3(1)
C
C     Output
C
C computed geopotential spectral coefficients
      COMPLEX PHISC(MXLSPEC_S)
C
C---- Executable Statements --------------------------------------------
C
C     Compute geopotential field.
C     (results in WS1)
      CALL GEOP(PHIBAR, NLLON_P, NLLAT_P, MOUNT, HIC, WS1)
C                                                                        
C     Transform geopotential field to spectral coefficients (FFT
C     followed by forward Gauss-Legendre transform).
C     (data in WS1)
      CALL SHTRNS(-1, ALP, WTS, TRIGS, WS1, WS2, WS3, WS1, PHISC)
C
      RETURN
C
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      SUBROUTINE GEOP(PHIBAR, ISIZE, JSIZE, MOUNT, HIC, PHI)
C                                                                              
C This subroutine computes the geopotential field from the height field,
C and adds the vertical levels expected by RFTLON
C
C called by: PSC
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Parameters -------------------------------------------------------
C
#     include "params.i"
C
C---- Common Blocks ----------------------------------------------------
C
C constants & timesteps
#     include "consts.i"
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C global mean geopotential
      REAL PHIBAR
C size of arrays
      INTEGER ISIZE, JSIZE
C mountain height
      REAL MOUNT(ISIZE,JSIZE)
C height field
      REAL HIC(ISIZE,JSIZE)
C
C     Output
C
C scaled wind fields
      REAL PHI(ISIZE,JSIZE)
C
C---- Local Variables --------------------------------------------------
C
C loop indices
      INTEGER I, J
C
C---- Executable Statements --------------------------------------------
C
C     Compute geopotential.
      IF (FTOPO) THEN
        DO J=1,JSIZE
          DO I=1,ISIZE
            PHI(I,J) = GRAV*(HIC(I,J) - MOUNT(I,J)) - PHIBAR
          ENDDO
        ENDDO
      ELSE
        DO J=1,JSIZE
          DO I=1,ISIZE
            PHI(I,J) = GRAV*HIC(I,J) - PHIBAR
          ENDDO
        ENDDO
      ENDIF
C
      RETURN
      END
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
