C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* Include file 'mpi.i'                                                *
C***********************************************************************
C* Common Block /MPI/ contains the data structures needed when using   *
C* nonblocking MPI communication commands in swap.F and sendrecv.F.    *
C*                                                                     *
C*    FIRSTRCV - pointer to oldest outstanding nonblocking receive     *
C*               request                                               *
C*    NXTRCV   - pointer to location following last nonblocking receive*
C*               request                                               *
C*    FIRSTSND - pointer to oldest outstanding nonblocking send        *
C*               request                                               *
C*    NXTSND   - pointer to location following last nonblocking send   *
C*               request                                               *
C*    RCVIDS   - array holding outstanding nonblocking receive request *
C*               ID numbers                                            *
C*    RCVTAGS  - array holding message tags for outstanding nonblocking*
C*               receive requests                                      *
C*    RCVSRCS  - array holding message sources for outstanding         *
C*               nonblocking receive requests                          *
C*    SNDIDS   - array holding outstanding nonblocking send request    *
C*               ID numbers                                            *
C*    SNDTAGS  - array holding message tags for outstanding nonblocking*
C*               send requests                                         *
C*    SNDDSTS  - array holding message destinations for outstanding    *
C*               nonblocking send requests                             *
C***********************************************************************
      INTEGER FIRSTRCV, NXTRCV, FIRSTSND, NXTSND, 
     &        RCVIDS(0:NPROCSX-1), RCVTAGS(0:NPROCSX-1), 
     &        RCVSRCS(0:NPROCSX-1),
     &        SNDIDS(0:NPROCSX-1), SNDTAGS(0:NPROCSX-1),
     &        SNDDSTS(0:NPROCSX-1)
      COMMON  / MPI /
     &        FIRSTRCV, NXTRCV, FIRSTSND, NXTSND, 
     &        RCVIDS, RCVTAGS, RCVSRCS,
     &        SNDIDS, SNDTAGS, SNDDSTS
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
