C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C include precision declaration definitions                            #
#include "precision.i"
C#######################################################################
       INTEGER FUNCTION LOG2(N)
C
C This function calculates the integer base 2 logarithm of its argument.
C
C called by: ALGINP, CTRANSPOSE, INPUT, LOGTRANS, MDEX, RFTFAX, SEQFOR, 
C            SEQINV, TRANSPOSE
C calls:
C
C---- Implicit None ----------------------------------------------------
C
      IMPLICIT NONE
C
C---- Arguments --------------------------------------------------------
C
C     Input
C
C argument whose logarithm is to be calculated
      INTEGER N
C
C---- Local Variables --------------------------------------------------
C
C temporary used to calculate logarithm
      INTEGER NTMP
C
C---- Executable Statements --------------------------------------------
C
      NTMP = N
      LOG2 = 0
      DO WHILE (NTMP .GT. 1)
        LOG2 = LOG2 + 1
        NTMP = NTMP/2
      ENDDO
C
      RETURN
      END

