C#######################################################################
C PSTSWM Version 4.0 (12/1/94)                                         #
C  A message-passing benchmark code and parallel algorithm testbed     #
C  that solves the nonlinear shallow water equations using the spectral#
C  transform method.                                                   #
C Written by:                                                          #
C  Patrick Worley of Oak Ridge National Laboratory                     #
C  Ian Foster of Argonne National Laboratory                           #
C Based on the sequential code STSWM 2.0 by James Hack and Ruediger    #
C  Jakob of the National Center for Atmospheric Research.              #
C Research and development funded by the Computer Hardware, Advanced   #
C  Mathematics, and Model Physics (CHAMMP) program of the U.S.         #
C  Department of Energy.                                               # 
C                                                                      #
C Questions and comments should be directed to worley@msr.epm.ornl.gov #
C Please notify and acknowledge the authors in any research or         #
C publications utilizing PSTSWM or any part of the code.               #
C                                                                      #
C NOTICE: Neither the institutions nor the authors make any            #
C representations about the suitability of this software for any       #
C purpose. This software is provided "as is", without express or       #
C implied warranty.                                                    #
C#######################################################################
C***********************************************************************
C* Include file 'fourier.i'                                            *
C***********************************************************************
C* Common Block /FOURIER/ contains the variables defining the data     *
C* decomposition of the physical space (NLON x NLAT x nver) and        *
C* Fourier space (MM x NLAT x NVER) when transforming between the      *
C* two spaces.                                                         *
C*                                                                     *
C*    NPFC_F   - number of processors used to partition longitude      *
C*               and Fourier wavenumber dimensions                     *
C*    NPLAT_F  - number of processors used to partition latitude       *
C*               dimension                                             *
C*    NPVER_F  - number of processors used to partition vertical       *
C*               dimension                                             *
C*    MAPFC_F  - an array mapping "virtual processors" to physical     *
C*               processors for the set over which the longitude       *
C*               and Fourier wavenumber dimensions are partitioned     *
C*    MAPLAT_F - an array mapping "virtual processors" to physical     *
C*               processors for the set over which the latitude        *
C*               dimension is partitioned                              *
C*    MAPVER_F - an array mapping "virtual processors" to physical     *
C*               processors for the set over which the vertical        *
C*               dimension is partitioned                              *
C*    FCDEX_F  - index of processor in MAPFC_F array                   *
C*    LATDEX_F - index of processor in MAPLAT_F array                  *
C*    VERDEX_F - index of processor in MAPVER_F array                  *
C*    MXLLON_F - declared number of local longitudes, used to make sure*
C*               that enough space is allocated to allow physical,     *
C*               Fourier, and spectral partitions of both gridpoint    *
C*               fields and Fourier coefficients will fit into the same*
C*               memory.                                               *
C*    NLLON_F  - number of local longitudes                            *
C*    NDLON_F  - array containing number of local longitudes for each  *
C*               processor in MAPFC_F (NDLON_F(FCDEX_F) .EQ. NLLON_F)  *
C*    MXLFC_F  - declared number of local Fourier coefficients, used to*
C*               make sure that enough space is allocated to allow     *
C*               physical, Fourier, and spectral partitions of both    *
C*               gridpoint fields and Fourier coefficients will fit    *
C*               into the same memory.                                 *
C*    NLFC_F   - number of (unpacked) local wavenumbers                *
C*    MTINV_F  - array mapping Fourier wavenumbers to local indices    *
C*    MTRUE_F  - array mapping local indices to Fourier wavenumbers    *
C*    NDFC_F   - array containing number of (packed) local Fourier     *
C*               wavenumbers for each processor in MAPFC_F             *
C*               (NDFC_F(FCDEX_F) .EQ. NLFC_F-1)                       *
C*    MXLLAT_F - declared number of local latitudes for work arrays,   *
C*               used to make sure that enough space is allocated to   *
C*               allow for transposition of data arrays.               *
C*    NLLAT_F  - number of local latitudes                             *
C*    NDLAT_F  - array containing number of local latitudes for each   *
C*               processor in MAPLAT_F (NDLAT_F(LATDEX_F) .EQ. NLLAT_F)*
C*    MXLVER_F - declared number of local vertical levels for work     *
C*               arrays, used to make sure that enough space is        *
C*               allocated to allow for transposition of data arrays.  *
C*    NLVER_F  - number of local vertical levels                       *
C*    NDVER_F  - array containing number of local vertical levels for  *
C*               each processor in MAPVER_F (NDVER_F(VERDEX_F) .EQ.    *
C*               NLVER_F)                                              *
C***********************************************************************
      INTEGER NPFC_F, NPLAT_F, NPVER_F, MAPFC_F(0:NPROCSX-1),
     &        MAPLAT_F(0:NPROCSX-1), MAPVER_F(0:NPROCSX-1), FCDEX_F,
     &        LATDEX_F, VERDEX_F, MXLLON_F, NLLON_F, 
     &        NDLON_F(0:NPROCSX-1), MXLFC_F, NLFC_F, MTINV_F(0:NLONX+1), 
     &        MTRUE_F(NLONX+2), NDFC_F(0:NPROCSX-1), 
     &        MXLLAT_F, NLLAT_F, NDLAT_F(0:NPROCSX-1), 
     &        MXLVER_F, NLVER_F, NDVER_F(0:NPROCSX-1)
      COMMON  / FOURIER / 
     &        NPFC_F, NPLAT_F, NPVER_F, MAPFC_F,
     &        MAPLAT_F, MAPVER_F, FCDEX_F,
     &        LATDEX_F, VERDEX_F, MXLLON_F, NLLON_F, 
     &        NDLON_F, MXLFC_F, NLFC_F, MTINV_F, 
     &        MTRUE_F, NDFC_F, 
     &        MXLLAT_F, NLLAT_F, NDLAT_F, 
     &        MXLVER_F, NLVER_F, NDVER_F
C*                                                                     *
C***********************************************************************
C* end include file                                                    *
C***********************************************************************       
