      SUBROUTINE ALLS1(WHICH, JEX, FEX, NEQ, H, XIN, XOUT, 
     $                 WORK, IWORK, INFO)
      IMPLICIT         NONE
*
*     .. Scalar Arguments ..
      INTEGER          WHICH, NEQ, INFO
      REAL*16          H
*
*     .. Array Arguments ..
      INTEGER          IWORK(NEQ)
      REAL*16          XIN(NEQ), XOUT(NEQ), WORK(NEQ*(NEQ+1))
*
*     .. External Subroutines ..
      EXTERNAL         JEX, FEX
*
*-------------------------------------------------------------------------
*
*  Purpose
*  =======
*
*  ALLS1 is the driver routine for obtaining various palindromic schemes.
*  (See documentation for WHICH below.) It is written, together with
*  ONESTEP, for a general quadratic differential system:
*
*         y' = f(y),
*
*  where each component of f(y) is qudratic in y.
*
*                                       Ren-Cang Li, June 1, 1996
*                                       na.rcli@na-net.ornl.gov
*
*  Arguments:
*  ==========
*
*  WHICH     (input) INTEGER scalar
*            Identify WHICH palindromic schemes as follows:
*
*              -------------------------------------------
*             |                                           |
C             |    WHICH                  The METHOD      |
C             |                                           |
C             |      1                      s1odr2        |
C             |      2                      s3odr4        |
C             |      3                      s5odr4        |
C             |      4                      s5odr4a       |
C             |      5                      s7odr6        |
C             |      6                      s9odr6a       |
C             |      7                      s9odr6b       |
C             |      8                     s15odr8        |
C             |      9                     s17odr8a       |
C             |     10                     s17odr8b       |
C             |     11                    s31odr10a       |
C             |     12                    s31odr10b       |
C             |     13                    s33odr10a       |
C             |     14                    s33odr10b       |
C             |     15                    s33odr10c       |
*             |                                           |
*              -------------------------------------------
*
*  JEX       External Subroutine that calculates the Jacobian of f(y);
*
*  FEX       External Subroutine that calculates f(y).
*
*  NEQ       (input) INTEGER scalar
*            The dimension of the system.
*
*  H         (input) REAL*16 scalar
*            Stepsize.
*
*  XIN       (input) REAL*16 array, dimension (NEQ)
*            The value of y at T, the current time. (Since this is for
*            autonomous system, T does not appear as an argument.)
*
*  XOUT      (output) REAL*16 array, dimension (NEQ)
*            The calculated y at T+H.
*
*  WORK      (working)  REAL*16 array, dimension ( NEQ*NEQ+NEQ )
*
*  IWORK     (working) INTEGER array, dimension ( NEQ )
*
*  INFO      (output) INTEGER scalar
*            It may be used as a flag to indicate, e.g., the successfullness
*            of doing Gaussian elimination with partial pivoting.
C
C--------------------------------------------------------------------
C
C  Common block that defines various palindromic schemes.
C
      REAL*16          DT2(2), DT3(3), DT4(3), DT5(4), DT6(5),
     $                 DT7(5), DT8(8), DT9(9), DT10(9), DT11(16),
     $                 DT12(16), DT13(17), DT14(17), DT15(17)
      COMMON /DELTAS/DT2, DT3, DT4, DT5, DT6, DT7, DT8, DT9, DT10,
     $              DT11, DT12, DT13, DT14, DT15
C
C  Excutable statements
C
      IF (WHICH .EQ. 1) THEN
C
C        s1odr2
C
         CALL ONESTEP(JEX, FEX, NEQ, H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
      ELSE IF (WHICH .EQ. 2) THEN
C
C        s3odr4
C
         CALL ONESTEP(JEX, FEX, NEQ, DT2(1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT2(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT2(1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
      ELSE IF (WHICH .EQ. 3) THEN
C
C        s5odr4
C
         CALL ONESTEP(JEX, FEX, NEQ, DT3(1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT3(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT3(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT3(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT3(1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
      ELSE IF (WHICH .EQ. 4) THEN
C
C        s5odr4a
C
         CALL ONESTEP(JEX, FEX, NEQ, DT4(1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT4(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT4(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT4(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT4(1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
      ELSE IF (WHICH .EQ. 5) THEN
C
C        s7odr6
C
         CALL ONESTEP(JEX, FEX, NEQ, DT5(1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT5(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT5(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT5(4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT5(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT5(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT5(1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
      ELSE IF (WHICH .EQ. 6) THEN
C
C        s9odr6a
C
         CALL ONESTEP(JEX, FEX, NEQ, DT6(1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT6(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT6(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT6(4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT6(5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT6(4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT6(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT6(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT6(1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
      ELSE IF (WHICH .EQ. 7) THEN
C
C        s9odr6b
C
         CALL ONESTEP(JEX, FEX, NEQ, DT7(1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT7(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT7(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT7(4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT7(5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT7(4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT7(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT7(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT7(1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
      ELSE IF (WHICH .EQ. 8) THEN
C
C        s15odr8
C
         CALL ONESTEP(JEX, FEX, NEQ, DT8(1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT8(1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
      ELSE IF (WHICH .EQ. 9) THEN
C
C        s17odr8a
C
         CALL ONESTEP(JEX, FEX, NEQ, DT9(1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(9)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT9(1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
      ELSE IF (WHICH .EQ. 10) THEN
C
C        s17odr8b
C
         CALL ONESTEP(JEX, FEX, NEQ, DT10(1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(9)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT10(1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
C
      ELSE IF (WHICH .EQ. 11) THEN
C
C        s31odr10a
C
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 9)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11(10)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11(11)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11(12)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11(13)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11(14)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11(15)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11(16)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11(15)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11(14)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11(13)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11(12)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11(11)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11(10)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 9)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT11( 1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
C
      ELSE IF (WHICH .EQ. 12) THEN
C
C        s31odr10b
C
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 9)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12(10)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12(11)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12(12)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12(13)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12(14)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12(15)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12(16)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12(15)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12(14)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12(13)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12(12)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12(11)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12(10)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 9)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT12( 1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
C
      ELSE IF (WHICH .EQ. 13) THEN
C
C        s33odr10a
C
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 9)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(10)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(11)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(12)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(13)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(14)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(15)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(16)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(17)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(16)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(15)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(14)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(13)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(12)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(11)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13(10)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 9)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT13( 1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
C
      ELSE IF (WHICH .EQ. 14) THEN
C
C        s33odr10b
C
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 9)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(10)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(11)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(12)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(13)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(14)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(15)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(16)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(17)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(16)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(15)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(14)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(13)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(12)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(11)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14(10)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 9)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT14( 1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
C
      ELSE IF (WHICH .EQ. 15) THEN
C
C        s33odr10c
C
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 1)*H,  XIN, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 9)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(10)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(11)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(12)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(13)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(14)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(15)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(16)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(17)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(16)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(15)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(14)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(13)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(12)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(11)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15(10)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 9)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 8)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 7)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 6)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 5)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 4)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 3)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 2)*H, XOUT, WORK, 
     $                WORK(NEQ+1), IWORK, INFO)
         CALL ONESTEP(JEX, FEX, NEQ, DT15( 1)*H, WORK, XOUT, 
     $                WORK(NEQ+1), IWORK, INFO)
C
      ELSE IF (WHICH .GT. 15) THEN
	   PRINT*, ' ERROR in ALLS1: Out of Bound'
      END IF
C
C     End of ALLS1
C
      RETURN
      END
