% Test script for the topological epsilon-algorithms of Brezinski
% testTEA12
% This script show the use of the TEA1 and TEA2 algoritms for implementing
% the topological epsilon-algorithms of Brezinski.

% Authors: Claude Brezinski, Michela Redivo-Zaglia
% V1.0 - December 2016
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clear variables
format short e
format compact

% Initializations

% From the theory all eps_6^(n) will be the vector zero
MAXCOL = 6;
NBC = 11;

% Set tolerance for denominators
TOL = 1e-20;

% Define the vector Y
Y = rand(5,1);

disp('************************************************** ')
disp('An example of the topological epsilon-algorithms ')
disp('of Brezinski')
disp('************************************************** ')
disp(' ')

% Built the NBC terms of the vector sequence

v = [20, 16, 10, 8, 2]';
for n = 1:NBC
    switch n
        case 1
            %Sn(:,n) = 1.59999999*v;
            Sn(:,n) = 2*v;
        case 2
            %Sn(:,n) = 1.19999999*v;
            Sn(:,n) = 1.2*v;
        case 3
            Sn(:,n) = v;
        otherwise
            Sn(:,n) = Sn(:,n-1)/2 + Sn(:,n-2)/4 + Sn(:,n-3)/8;
    end
end
%

% Start the topological epsilon-algorithms

EPSINI1 = Sn(:,1); 
EPSINI2 = Sn(:,1); 
disp('S_0 = ')
disp(num2str(EPSINI1,'%20.10e \n'));
[EPSINI1,EPSVEC1]=TEA1(EPSINI1,[],MAXCOL,Y,TOL,0);
[EPSINI2,EPSVEC2]=TEA2(EPSINI2,[],MAXCOL,Y,TOL,0);
disp(['=== diagonal ', num2str(1,'%d'), ' computed ==='])
disp(' ')
for n = 1:NBC-1
   EPSINI1 = Sn(:,n+1);
   EPSINI2 = Sn(:,n+1);
   disp(['S_',num2str(n,'%d')]);
   disp(num2str(EPSINI1(:),'%20.10e'));
   [EPSINI1,EPSVEC1]=TEA1(EPSINI1,EPSVEC1,MAXCOL,Y,TOL);
   [EPSINI2,EPSVEC2]=TEA2(EPSINI2,EPSVEC2,MAXCOL,Y,TOL);
   disp(['=== diagonal ', num2str(n+1,'%d'), ' computed ==='])
   disp(['=== TEA1 ==='])
   disp(cell2mat(EPSVEC1))
   disp(['=== TEA2 ==='])
   disp(cell2mat(EPSVEC2))
   disp('epsilon TEA1 = ')
   disp(num2str(EPSINI1(:),'%20.10e'))
   disp('epsilon TEA2 = ')
   disp(num2str(EPSINI2(:),'%20.10e'))
   disp(' ')
end 

% Summary

disp([' Number of terms of the vector sequence        = ', ...
    num2str(NBC,'%d')]);
disp([' Tolerance for topological epsilon algorithms  = ', ...
    num2str(TOL,'%6.1e')]);
disp([' Maximum column                                = ', ...
    num2str(MAXCOL,'%d')]);