function [X,Y] = Fiter_EA(X,A,Y)
% FITER_EA   Computes the next iterate (Method of El-Sayed and Al-Dbiban)
%            Computes the next iterate of the sequence from the 
%            previous one by using the Method of El-Sayed and Al-Dbiban 
%            (2005) for solving a nonlinear matrix equation 
%            The relations of the method are
%                Y_{k+1} = (I - X_k) Y_k + I
%                X_{k+1} = I - A^T Y_{k+1} A 
%                with X_0 = Y_0 = I
%
% [X,Y] = Fiter_EA(X,A,Y)

% Authors: Claude Brezinski, Michela Redivo-Zaglia
% V1.0 - December 2016
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
m = size(A,1);
Y = (eye(m)-X)*Y+eye(m);
X = eye(m)-A'*Y*A;