% Test script for the scalar epsilon-algorithm of Wynn
% testSEAW
% This script show the use of the particular rule in the scalar
% epsilon-algorithm of Wynn.

% Authors: Claude Brezinski, Michela Redivo-Zaglia
% V1.0 - December 2016
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

clearSEAW
clear variables
format short e
format compact

% Initializations

MAXCOL = 4;
NBC = 5;
NDIGIT = 15;
% Set tolerance for denominators
TOL = 0;
% Tolerance in the perturbed terms case
% TOL = 1e-20;

disp('************************************************** ')
disp('An example of the scalar epsilon-algorithm of Wynn')
disp('with the use of the particular rule')
disp('************************************************** ')
disp(' ')

% Built the NBC terms of the scalar sequence

x=2;
S(1)=0;
for n = 2:NBC
    S(n)=S(n-1)+x.^(n-2)/factorial(n-2);
    % Term of the sequence perturbed
    % S(n)=S(n-1)+x.^(n-2)/factorial(n-2)+1e-7;
end

% Start the scalar epsilon-algorithm

EPSINIS = S(1); 
disp(['S_0 = ',num2str(EPSINIS,'%20.5e')]);
[EPSINIS,EPSSCA,NSING]=SEAW(EPSINIS,[],MAXCOL,TOL,NDIGIT,0);
disp(['=== diagonal ', num2str(1,'%d'), ' computed ==='])
disp(' ')
for n = 1:NBC-1
   EPSINIS = S(n+1);
   disp(['S_',num2str(n,'%d'),' = ',num2str(EPSINIS,'%20.5e')]);
   [EPSINIS,EPSSCA,NSING]=SEAW(EPSINIS,EPSSCA,MAXCOL,TOL,NDIGIT);
   disp(['=== diagonal ', num2str(n+1,'%d'), ' computed ==='])
   disp(EPSSCA(1:end))
   disp(['epsilon = ',num2str(EPSINIS,'%20.5e')])
   disp(' ')
end 

% Summary

disp([' Number of terms of the scalar sequence  = ',num2str(NBC,'%d')]);
disp([' Tolerance for scalar epsilon algorithm  = ',num2str(TOL,'%6.1e')]);
disp([' Number of the common digits             = ',num2str(NDIGIT,'%d')]);
disp([' Maximum column                          = ',num2str(MAXCOL,'%d')]);
disp([' Total number of singularities found in the eps-array = ', ...
    num2str(NSING,'%d')]);