% Script to create figures and obtain information after errors of the demo
% plot_demo
% This script allows to create figures and to obtain the summary of the 
% data when an error occurs in the demo.

%  AUTHORS: Claude Brezinski and Michela Redivo-Zaglia
%  V1.0 - December 2016
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  

% Choose the Method
disp('Insert the method for which we want to obtain results and figures')
meth=input('(AM = 1, RM = 2) ');
if ~ismember(meth,[1,2])
    error (' plotSTEA - The method do not exist');
end
switch meth
  case 1
    % Graphical representations
    figure(3)
    if ~isempty(sol)
        if swist == 2
            LX=length(nerrX); LEPSsav=length(nerrEPSsav);
            LEPS=length(nerrEPS);
            semilogy([0:LX-1],nerrX,'k-',[0:LEPSsav-1], ...
            nerrEPSsav,'r--', [0:LEPS-1],nerrEPS,'b-.','LineWidth',2)
            legend('||x-sol||','||eps - sol|| stea1', ...
                '||eps - sol|| stea2', 'LOCATION','best');
            title(['EXAMPLE ',swi,'. AM with STEA1 and STEA2'])
        else
            LX=length(nerrX); LEPS=length(nerrEPS);
            semilogy([0:LX-1],nerrX,'k-',[0:LEPS-1], ...
                 nerrEPS,'r--', 'LineWidth',2)
            legend('||x-sol||','||eps - sol|| stea1', ...
                 'LOCATION','best');    
            title(['EXAMPLE ',swi,'. AM with STEA1']) 
        end
    else
        if swist == 2
            LF=length(nerrF); LFEPSsav=length(nerrFEPSsav);
            LFEPS=length(nerrFEPS);
            semilogy([0:LF-1],nerrF,'k-',[0:LFEPSsav-1], ...
              nerrFEPSsav,'r--', [0:LFEPS-1],nerrFEPS,'b-.','LineWidth',2)
            legend('||x-F(x)||','||eps-F(eps)|| stea1', ...
                '||eps-F(eps)|| stea2', 'LOCATION','best');
            title(['EXAMPLE ',swi,'. AM with STEA1 and STEA2'])
        else
            LF=length(nerrF); LFEPSsav=length(nerrFEPSsav);
            LFEPS=length(nerrFEPS);
            semilogy([0:LF-1],nerrF,'k-',[0:LFEPS-1], ...
                 nerrFEPS,'r--', 'LineWidth',2)
            legend('||x-F(x)||','||eps-F(eps)|| stea1', ...
                 'LOCATION','best');
            title(['EXAMPLE ',swi,'. AM with STEA1'])
        end
    end    

    % Final summary
    disp(' ');
    disp([' *** AM - Example ',swi,' ***'])
    disp([' Dimension m          = ',num2str(m)]);
    if (swin > 0) && (swin <6)
        disp([' alpha                = ',num2str(al,'%6.2e')]);
    end 
    disp([' Max even column      = ', num2str(MAXCOL,'%d')]);
    disp([' Number of iterations = ', num2str(NBC,'%d')]);
    disp(' ');
    disp([' *** STOPPED during ', stean]);
    disp([' *** Number of iterations completed = ',num2str(i,'%d')]);
    disp(' ');
    disp(' At last iteration of the Acceleration Method');

    if ~isempty(sol)
        disp([' ||x-sol||   = ',num2str(nerrX(end),'%6.2e')]);
        if swist == 2
            disp([' ||eps-sol|| stea1 = ',num2str(nerrEPSsav(end),'%6.2e')]);
            disp([' ||eps-sol|| stea2 = ',num2str(nerrEPS(end),'%6.2e')]); 
        else
            disp([' ||eps-sol|| stea1 = ',num2str(nerrEPS(end),'%6.2e')]); 
        end 
    else
        disp([' ||x-F(x)||           = ',num2str(nerrF(end),'%6.2e')]);
        if swist == 2
            disp([' ||eps-F(eps)|| stea1 = ',num2str(nerrFEPSsav(end),'%6.2e')]);   
            disp([' ||eps-F(eps)|| stea2 = ',num2str(nerrFEPS(end),'%6.2e')]);  
        else
            disp([' ||eps-F(eps)|| stea1 = ',num2str(nerrFEPSsav(end),'%6.2e')]);   
        end 
    end 
  case 2
    figure(30)
    if ~isempty(sol)
        if swist == 2
            LITsav=length(nerrITsav); LEPSsav=length(nerrEPSsav);
            LIT=length(nerrIT); LEPS=length(nerrEPS);
            semilogy([0:tot-1],nerrITX,'k-',[0:LITsav-1],nerrITsav,'r--',...
                [0:NBC:LITsav],nerrEPSsav,'r*', [0:LIT-1],nerrIT,'b-.', ...
                [0:NBC:LIT],nerrEPS,'b*', 'LineWidth',2)
            legend('||x_{ori}-sol||','||x-sol|| stea1', ...
                '||eps - sol|| stea1', '||x-sol|| stea2', ...
                '||eps - sol|| stea2 ', 'LOCATION','best');
        else
            LIT=length(nerrIT); LEPS=length(nerrEPS);
            semilogy([0:tot-1],nerrITX,'k-', [0:LIT-1],nerrIT,'b-.', ...
                [0:NBC:LIT],nerrEPS,'b*', 'LineWidth',2)
            legend('||x_{ori}-sol||','||x-sol|| stea1', ...
                '||eps - sol|| stea1', 'LOCATION','best');
        end
    else
        if swist == 2
            LFsav=length(nerrFsav); LFEPSsav=length(nerrFEPSsav);
            LF=length(nerrF); LFEPS=length(nerrFEPS);            
            semilogy([0:tot-1],nerrFX,'k-',[0:LFsav-1],nerrFsav,'r--', ...
               [0:NBC:LFsav],nerrFEPSsav,'r*', [0:LF-1],nerrF,'b-.', ...
               [0:NBC:LF],nerrFEPS,'b*', 'LineWidth',2)
            legend('||x_{ori}-F(x_{ori})||','||x-F(x)|| stea1', ...
               '||eps - F(eps)|| stea1', '||x-F(x)|| stea2', ...
               '||eps - F(eps)|| stea2', 'LOCATION','best');
        else
            LF=length(nerrF); LFEPS=length(nerrFEPS);            
            semilogy([0:tot-1],nerrFX,'k-', [0:LF-1],nerrF,'b-.', ...
               [0:NBC:LF],nerrFEPS,'b*', 'LineWidth',2)
            legend('||x_{ori}-F(x_{ori})||','||x-F(x)|| stea1', ...
               '||eps - F(eps)|| stea1', 'LOCATION','best');
        end
    end    
    if MAXCOL == 2*m
        if swist == 2
            title(['EXAMPLE ',swi,'. GSM with STEA1 and STEA2'])
        else
            title(['EXAMPLE ',swi,'. GSM with STEA1'])
        end
    else
        if swist == 2
            title(['EXAMPLE ',swi,'. RM with STEA1 and STEA2'])
        else
            title(['EXAMPLE ',swi,'. RM with STEA1'])
        end
    end

    figure(40)
    if ~isempty(sol)
        if swist == 2
           semilogy([0:LEPSsav-1],nerrEPSsav,'r--*',[0:LEPS-1], ...
               nerrEPS,'b-.*', 'LineWidth',2)
           legend('||eps-sol|| stea1','|eps-sol| stea2','LOCATION','best');
        else
           semilogy([0:LEPS-1], nerrEPS,'b-.*', 'LineWidth',2)
           legend('|eps-sol| stea1','LOCATION','best');
        end
    else
        if swist == 2
           semilogy([0:LFEPSsav-1],nerrFEPSsav,'r--*',[0:LFEPS-1], ...
              nerrFEPS,'b-.*', 'LineWidth',2)
           legend('||eps-F(eps)|| stea1','||eps-F(eps)|| stea2', ...
               'LOCATION','best');
        else
           semilogy([0:LFEPS-1], nerrFEPS,'b-.*', 'LineWidth',2)
           legend('||eps-F(eps)|| stea1', 'LOCATION','best');
        end
    end 
    xlabel('cycles')
    
    if MAXCOL == 2*m
        if swist == 2
            title(['EXAMPLE ',swi,'. GSM with STEA1 and STEA2'])
        else
            title(['EXAMPLE ',swi,'. GSM with STEA1'])
        end
    else
        if swist == 2
            title(['EXAMPLE ',swi,'. RM with STEA1 and STEA2'])
        else
            title(['EXAMPLE ',swi,'. RM with STEA1'])
        end
    end

    % Final summary
    disp(' ');
    if MAXCOL == 2*m
        disp([' *** GSM - Example ',swi,' ***'])
    else
        disp([' *** RM - Example ',swi,' ***'])
    end
    disp([' Dimension m                    = ',num2str(m)])
    if (swin > 0) && (swin <6)
        disp([' alpha                          = ',num2str(al,'%6.2e')]);
    end 
    disp([' Max even column                = ',num2str(MAXCOL,'%d')]);
    disp(' Number of terms for each ');
    disp([' inner iteration                = ',num2str(NBC,'%d')]);
    disp([' Number of cycles               = ',num2str(NCY,'%d')]);
    disp([' *** STOPPED during ', stean]);
    disp([' *** Number of cycles completed     = ',num2str(i,'%d')]);
    disp([' *** Number of iterations completed = ',num2str(ii,'%d')]);
    disp(' ');
    disp(' At last iteration of the Restarted Method');
    if ~isempty(sol)
        disp([' ||x_{ori}-sol||   = ',num2str(nerrITX(end),'%6.2e')]);
        if swist == 2
            disp([' ||eps-sol|| stea1 = ',num2str(nerrEPSsav(end),'%6.2e')]);
            disp([' ||eps-sol|| stea2 = ',num2str(nerrEPS(end),'%6.2e')]); 
        else
            disp([' ||eps-sol|| stea1 = ',num2str(nerrEPS(end),'%6.2e')]); 
        end
    else
        disp([' ||x_{ori}-F(x_{ori})|| = ',num2str(nerrFX(end),'%6.2e')]);
        if swist == 2
            disp([' ||eps-F(eps)|| stea1   = ',num2str(nerrFEPSsav(end), ...
               '%6.2e')]); 
            disp([' ||eps-F(eps)|| stea2   = ',num2str(nerrFEPS(end), ...
                '%6.2e')]);  
        else
            disp([' ||eps-F(eps)|| stea1   = ',num2str(nerrFEPS(end), ...
               '%6.2e')]); 
        end
    end 
end