function exhelp(swi,flag)  
% EXHELP Describes the Examples 1 to 12 of the paper 
%  and gives the values to be insert for obtaining the figures of the paper
%
% exhelp(swi,flag)
%
% Inputs:
%   swi     Example number (string)
%   flag    flag = 0 is for AM (Acceleration Method)
%           flag ~=0 is for RM (Restarted Method) with k=m (that is GSM)

% Authors: Claude Brezinski, Michela Redivo-Zaglia
% V1.0 - December 2016
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

swi = strtok(swi);
if isletter(swi(end))
    swin = str2double(swi(1:end-1));
else
    swin = str2double(swi);
end

if flag == 0
    algo=' AM';
else
    algo=' GSM';
end
disp(' ');
disp([' *** ',algo,' - EXAMPLE ',swi,' *** ']);

switch swin
    case 1
        disp(' Nonlinear system, m = 5, solution x = (1,...,1)^T')
        disp(' x_0 = (1/2,...,1/2)^T');
        if flag == 0 
            disp(' Take alpha = -0.05, MAXCOL = 4, NBC = 350');
        else
            disp(' Take alpha = -0.05, MAXCOL = 10, NCY = 5');
        end
    case 2
        disp(' Nonlinear system, m = 10, solution x = (0,...,0)^T')
        disp(' x_0 = (1/(2m),...,1/(2m))^T');
        if flag == 0 
            disp(' Take alpha = 0.1, MAXCOL = 4, NBC = 150');
        else
            disp(' Take alpha = 0.1, MAXCOL = 20, NCY = 2');
        end
    case 3
        disp(' Nonlinear system, m = 3, solution x = (-1,1,0)^T')
        disp(' x_0 = (0,0,0)^T');
        if flag == 0 
            disp(' Take alpha = 0.2, MAXCOL = 8, NBC = 300');
        else
            disp(' Take alpha = 0.1, MAXCOL = 6, NCY = 10');
        end
    case 4
        if swi(end) == 'a' 
           disp([' Non-differentiable system, m = 2, two solutions. ', ...
            'First one (1,1)^T'])
           disp(' x_0 = (1.3,1.3)^T');
           if flag == 0 
               disp(' Take alpha = -0.08, MAXCOL = 6, NBC = 25');
           else
               disp(' Take alpha = -0.08, MAXCOL = 4, NCY = 3');
           end
        else
           disp([' Non-differentiable system, m = 2, two solutions ', ...
            'Second one (-2,-2)^T']);
           disp(' x_0 = (-1,-1)^T');
           if flag == 0 
               disp(' Take alpha = 0.1, MAXCOL = 6, NBC = 25');
           else
               disp(' Take alpha = 0.1, MAXCOL = 4, NCY = 3');
           end
        end
    case 5
        disp(' Nonlinear system, m = 7, solution x=(0.1442749507.......)^T')
        disp(' x_0 = (1,...,1)^T/10');
        if flag == 0 
            disp(' Take alpha = -0.01, MAXCOL = 6, NBC = 30');
        else
            disp(' Take alpha = -0.01, MAXCOL = 14, NCY = 2');
        end
    case 6
        disp(' Linear system AX=B, m = 5, solution X = pei(5,1:2)');
        disp(' X_0 = zeros(5,2), functional y = sum of elements');
        if flag == 0 
            disp(' Take MAXCOL = 6 OR MAXCOL = 8 and NBC = 50');
        else
            disp(' Take MAXCOL = 10, NCY = 1');
        end
    case 7
        disp(' Matrix equation AX=B, m = 5, solution X_+ = I');
        disp(' Guo Method');
        disp(' X_0 = I+A^*A, functional y = trace');
        if flag == 0 
            disp(' Take MAXCOL = 4, NBC = 70');
        else
            disp(' Take MAXCOL = 10, NCY = 3');
        end
    case 8
        if swi(end) == 'a' 
           disp(' Matrix equation, m = 5, solution unknown');
           disp(' Bai Method');
           disp(' X_0 = B_0A_0, functional y = trace');
           if flag == 0 
               disp(' Take MAXCOL = 6, NBC = 35');
           else
               disp(' Take MAXCOL = 10, NCY = 2');
           end
        else
           disp(' Matrix equation, m = 5, solution known');
           disp(' Bai Method');
           disp(' X_0 = B_0A_0, functional y = trace');
           if flag == 0 
               disp(' Take MAXCOL = 6, NBC = 35');
           else
               disp(' Take MAXCOL = 10, NCY = 2');
           end
        end
    case 9
        disp(' Matrix exponential e^(At), A=UDU^-1, D frank, U orthog');
        disp(' t = -0.099, m = 100, functional y = trace');
        if flag == 0 
            disp(' Take MAXCOL = 6 OR MAXCOL =10, NBC = 44');
        else
            error(' exhelp - For this example RM is unavailable')
        end
    case 10
        disp(' Matrix series (1-At)^-1, A=UDU^-1, D frank, U orthog');
        disp(' t = -0.0099, m = 50, functional y = trace');
        if flag == 0 
            disp(' Take MAXCOL = 6, NBC = 25 OR MAXCOL =12, NBC = 20');
        else
            error(' exhelp - For this example RM is unavailable')
        end
    case 11
        disp(' Square root of A, A spd moler, m = 50');
        disp(' Higham Method, variant of Newton');
        disp(' X_0 = A, functional y = trace');
        if flag == 0 
            disp(' Take MAXCOL = 2 OR MAXCOL =4, NBC = 25');
        else
            error(' exhelp - For this example RM is unavailable')
        end
    case 12
        disp(' Square root of (I-C), C = moler/4.1e5, m = 500');
        disp(' X_0 = 0, functional y = trace');
        if flag == 0 
            disp(' Take MAXCOL = 4 OR MAXCOL =8, NBC = 30');
        else
            error(' exhelp - For this example RM is unavailable')
        end
    otherwise
        error(' exhelp - The example chosen do not exist')
end
disp(' ');