classdef  testUminus < matlab.unittest.TestCase
    %TESTUMINUS Test overloaded unary subtraction
    
    methods(Test)
        
        function testEmpty(testCase)
            x = polysym.empty;
            y = -x;
            testCase.verifyTrue(isempty(y))
        end
        
        function testDefault(testCase)
            x = polysym;
            y = -x;
            testCase.verifyEqual(y.Value,'0');
        end
        
        function testZero(testCase)
            x = polysym(0);
            y = -x;
            testCase.verifyEqual(y.Value,'0');
        end
        
        function testUminusReal(testCase)
            x = polysym(pi);
            y = -x;
            testCase.verifyEqual(y.Value,['-',x.Value]);
        end
        
        function testRealUminusChar(testCase)
            x = polysym('x');
            y = -x;
            testCase.verifyEqual(y.Value,'-x');
        end
        
        function testUminusVector(testCase)
            x = polysym(1:3);
            y = -x;
            testCase.verifyEqual(y(1).Value,'-1');
            testCase.verifyEqual(y(2).Value,'-2');
            testCase.verifyEqual(y(3).Value,'-3');
        end
        
        function testCompoundExpression(testCase)
            x = polysym('4+y');
            y = -x;
            testCase.verifyEqual(y.Value,'-(4+y)');
        end
        
        function testMultiplicativeExpression(testCase)
            x = polysym('4*y');
            y = -x;
            testCase.verifyEqual(y.Value,'-4*y');
            
        end
    end
end
