classdef  testTriu < matlab.unittest.TestCase
    %TESTTRIU Test overloaded subtraction of upper triangular part
    
    methods(Test)
        
        function testEmpty(testCase)
            p = polysym.empty;
            testCase.verifyTrue(isempty(p.triu))
        end
        
        function testDefault(testCase)
            p = polysym;
            testCase.verifyEqual(p.triu,p)
        end
        
        function testMultipleChars(testCase)
            p = polysym('xyz');
            testCase.verifyEqual(p.triu,p)
        end
        
        function testNoSecondTerm(testCase)
            M = randi(100,3);
            p = polysym(M);
            testCase.verifyEqual(p.triu,polysym(triu(p)))
        end
        
        function testPositiveDiagonal(testCase)
            M = randi(100,5);
            k = 2;
            p = polysym(M);
            testCase.verifyEqual(triu(p,k),polysym(triu(p,k)))
        end
        
        function testNegativeDiagonal(testCase)
            M = randi(100,5);
            k = -2;
            p = polysym(M);
            testCase.verifyEqual(triu(p,k),polysym(triu(p,k)))
        end
    end
end
