classdef  testTimes < matlab.unittest.TestCase
    %TESTTIMES Test overloaded element-by-element multiplication
    
    methods(Test)
        
        function testZeros(testCase)
            x = polysym(0);
            y = polysym(0);
            z = x.*y;
            testCase.verifyEqual(z.Value,'0');
        end
        
        function testOneZero(testCase)
            x = polysym(0);
            y = polysym('y');
            z = x.*y;
            testCase.verifyEqual(z.Value,'0');
        end
        
        function testZeroTimesReal(testCase)
            x = polysym(0);
            y = polysym(pi);
            z = x.*y;
            testCase.verifyEqual(z.Value,'0');
        end
        
        function testRealTimesChar(testCase)
            x = polysym('x');
            y = polysym(5);
            z = x.*y;
            testCase.verifyEqual(z.Value,'x*5');
        end
        
        function testScalarTimesVector(testCase)
            x = polysym('x');
            y = polysym(1:3);
            z = x.*y;
            testCase.verifyEqual(z(1).Value,'x');
            testCase.verifyEqual(z(2).Value,'x*2');
            testCase.verifyEqual(z(3).Value,'x*3');
        end
        
        function testVectorTimesVector(testCase)
            x = polysym({'x','y'});
            y = polysym({'u','w'});
            z = x.*y;
            testCase.verifyEqual(z(1).Value,'x*u');
            testCase.verifyEqual(z(2).Value,'y*w');
        end
        
        function testTimesTimes(testCase)
            x = polysym('x');
            y = polysym('4.*y');
            z = x.*y;
            testCase.verifyEqual(z.Value,'x*4.*y');
        end
        
        function testTimesMtimes(testCase)
            x = polysym('x');
            y = polysym('4*y');
            z = x.*y;
            testCase.verifyEqual(z.Value,'x*4*y');
        end
        
        function testLeftMultiply(testCase)
            x = polysym('x');
            z =  (1/2)*x;
            testCase.verifyEqual(z.Value,'0.5*x')
        end
        
        function testRightMultiplyParens(testCase)
            x = polysym('x');
            z = x*(1/2);
            testCase.verifyEqual(z.Value,'x*0.5')
        end
        
        function testRightMultiplyNoParens(testCase)
            x = polysym('x');
            z = x*1./2;
            testCase.verifyEqual(z.Value,'x/2')
            
        end
    end
end
