classdef  testSym < matlab.unittest.TestCase
    %TESTSYM Test conversion to sym class
    
    properties
        d
    end
    methods(TestMethodSetup)
        function setDigits(testCase)
            testCase.d = digits; % Store digits setting at time of call
            digits(32)
        end
    end
    
    methods(Test)
        function testSingleChar(testCase)
            x = polysym('x');
            y = sym(x);
            % This funny syntax ensures compatibility between R2013a and earlier
            % versions of MATLAB
            testCase.verifyTrue(logical(y==sym('x')))
        end
        
        function testCharArray(testCase)
            x = polysym('x',2);
            y = sym(x);
            tf = y==sym('x',2);     % For some reason, isequal doesn't work here.
            testCase.verifyTrue(all(tf(:)))
        end
        
        function testZero(testCase)
            x = polysym(sym(0));
            testCase.verifyEqual(x.Value,char(vpa(0)))
        end
        
        function testVpa(testCase)
            y = vpa(pi);
            x = polysym(y);
            yy = sym(x);
            testCase.verifyTrue(abs(double(y-yy))<10^(-digits+1))
        end
        
        function testDouble(testCase)
            r = randn(2);
            x = polysym(r);
            y = sym(x);
            testCase.verifyEqual(r,double(y),'AbsTol',eps*100)
        end
        
        function testImaginary(testCase)
            r = randn(2)*1i;
            x = polysym(r);
            y = sym(x);
            testCase.verifyEqual(r,double(y),'AbsTol',eps*100)
        end
        
        function testComplex(testCase)
            r = exp(1i*randn(2));
            x = polysym(r);
            y = sym(x);
            testCase.verifyEqual(r,double(y),'AbsTol',eps*100)
        end
        
        function testString(testCase)
            % For strings, the two results should be exactly equal.
            str = '3.14159265358979323846264338328';
            x = polysym(str);
            y = sym(x);
            testCase.verifyEqual(cellstr(x),{char(y)})
        end
    end
    methods(TestMethodTeardown)
        
        function teardown(testCase)
            digits(testCase.d)
            
        end
    end
end
