classdef  testSum < matlab.unittest.TestCase
    %TESTSUM Test overloaded summation method
    
    methods(Test)
        
        function testEmpty(testCase)
            x = polysym.empty;
            testCase.verifyTrue(isempty(sum(x)))
        end
        
        function testZeros(testCase)
            x = [polysym(0) polysym(0)];
            z = sum(x);
            testCase.verifyEqual(z.Value,'0');
        end
        
        function testOneZeroOneChar(testCase)
            x = [polysym(0) polysym('y')];
            z = sum(x);
            testCase.verifyEqual(z.Value,'y');
        end
        
        function testZeroSumReal(testCase)
            x = polysym(0);
            y = polysym(pi);
            z = sum([x y]);
            testCase.verifyEqual(z,y);
        end
        
        function testRealSumChar(testCase)
            x = [polysym('x') polysym(5)];
            z = sum(x);
            testCase.verifyEqual(z.Value,'x+5');
        end
        
        function testScalarSumVector(testCase)
            x = polysym(1:3);
            z = sum(x);
            testCase.verifyEqual(z.Value,'1+2+3');
        end
        
        function testVectorSumVector(testCase)
            x = polysym({'x','y';'u','w'});
            z = sum(x);
            testCase.verifyEqual(z(1).Value,'x+u');
            testCase.verifyEqual(z(2).Value,'y+w');
        end
        
        function testVectorSumVectorSecondDim(testCase)
            x = polysym({'x','y';'u','w'});
            z = sum(x,2);
            testCase.verifyEqual(z(1).Value,'x+y');
            testCase.verifyEqual(z(2).Value,'u+w');
        end
        
        function testVectorSumVectorThirdDim(testCase)
            x = polysym({'x','y';'u','w'});
            f = @() sum(x,3);
            testCase.verifyError(f,'MATLAB:polysym:diff:notLess')
        end
        
        function testAssociative1(testCase)
            x = polysym('x');
            y = polysym('4+y');
            z = sum([x y]);
            testCase.verifyEqual(z.Value,'x+4+y');
        end
        
        function testAssociative2(testCase)
            x = polysym('x');
            y = polysym('4*y');
            z = sum([x y]);
            testCase.verifyEqual(z.Value,'x+4*y');
            
        end
    end
end
