classdef  testPut_in_arrays < matlab.unittest.TestCase
    %TESTPUT_IN_ARRAYS Test method for putting components into arrays
    
    methods(Test)
        
        function testEmpty(testCase)
            p = polysym.empty;
            testCase.verifyTrue(isempty(p.put_in_arrays))
        end
        
        function testDefault(testCase)
            p = polysym;
            testCase.verifyEqual(p.put_in_arrays,{p})
        end
        
        function testSingleChar(testCase)
            p = polysym('x');
            testCase.verifyEqual(p.put_in_arrays,{p})
        end
        
        function testSingleArray(testCase)
            p = polysym('x',[2 3]);
            testCase.verifyEqual(p.put_in_arrays,{p})
        end
        
        function testIncompleteArray(testCase)
            polysyms('x1_2','x2_3')
            p = [x1_2 x2_3];
            testCase.verifyEqual(p.put_in_arrays,{p(1); p(2)})
        end
        
        function testColumnVector(testCase)
            p = polysym('x',[3 1]);
            testCase.verifyEqual(p.put_in_arrays,{p})
        end
        
        function testRowVector(testCase)
            p = polysym('x',[1 3]);
            testCase.verifyEqual(p.put_in_arrays,{p(:)})
        end
        
        function testVectorIncomplete(testCase)
            polysyms('x1','x3')
            p = [x1 x3];
            testCase.verifyEqual(p.put_in_arrays,{p(1); p(2)})
        end
        
        function testMultipleChars(testCase)
            polysyms('x','y')
            p = [x y];
            testCase.verifyEqual(p.put_in_arrays,{x; y})
        end
        
        function testMixed(testCase)
            p = polysym('w',2);
            q = polysym(pi);
            r = polysym('x',[3 1]);
            v = [p(:); q; r];
            testCase.verifyEqual(v.put_in_arrays,{q; p; r})
        end
        
        function testSameRoot(testCase)
            % The arrays x and p interfere with each other, resulting in all the
            % components being listed. It seems unlikely that a user will want to
            % define variables this way.
            p = polysym('x',[1 2]);
            x = polysym('x');
            v = [p(:); x];
            testCase.verifyEqual(v.put_in_arrays,{p(1); p(2); x})
        end
        
        function testOverlap(testCase)
            % Repetitions in terms are ignored.
            polysyms x1 x2 x3
            v = [x1 x2 x2 x3];
            testCase.verifyEqual(v.put_in_arrays,{[x1; x2; x3]})
        end
        
        function testOneIndex(testCase)
            polysyms l0 l1
            testCase.verifyEqual(put_in_arrays([l0 l1]),{l0; l1})
        end
    end
end